/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.item.tool;

import de.markusbordihn.scraptechworkshop.config.MultitoolConfig;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyData;
import de.markusbordihn.scraptechworkshop.data.multitool.DisplayMode;
import de.markusbordihn.scraptechworkshop.data.multitool.ScrapMultitoolData;
import de.markusbordihn.scraptechworkshop.data.multitool.ToolMode;
import de.markusbordihn.scraptechworkshop.energy.EnergyManager;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public record ToolModeDetector(class_1799 itemStack) {
    public ToolMode getToolModeForBlock(class_2680 state) {
        if (state.method_26164(class_3481.field_33713)) {
            return ToolMode.AXE;
        }
        if (state.method_26164(class_3481.field_33715)) {
            return ToolMode.PICKAXE;
        }
        if (state.method_26164(class_3481.field_33716)) {
            return ToolMode.SHOVEL;
        }
        if (state.method_26164(class_3481.field_33714)) {
            return ToolMode.HOE;
        }
        return ToolMode.NONE;
    }

    public void updateToolMode(class_1657 player, class_2680 targetBlock) {
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(this.itemStack);
        EnergyData energyData = EnergyManager.getEnergyData(this.itemStack, MultitoolConfig.energyMax);
        if (!data.hasBattery() || !energyData.hasEnergy(MultitoolConfig.energyPerBlock)) {
            if (!ToolMode.DEFAULT.getId().equals(data.activeMode())) {
                ScrapMultitoolData newData = data.withActiveMode(ToolMode.DEFAULT.getId());
                newData.saveToItemStack(this.itemStack);
                DisplayMode displayMode = new DisplayMode(this.itemStack);
                displayMode.updateModel(ToolMode.DEFAULT, newData.getBatteryLevel());
            }
            return;
        }
        ToolMode newMode = ToolMode.DEFAULT;
        if (targetBlock != null) {
            if (targetBlock.method_26164(class_3481.field_33713)) {
                newMode = ToolMode.AXE;
            } else if (targetBlock.method_26164(class_3481.field_33715)) {
                newMode = ToolMode.PICKAXE;
            } else if (targetBlock.method_26164(class_3481.field_33716)) {
                newMode = ToolMode.SHOVEL;
            } else if (targetBlock.method_26164(class_3481.field_33714)) {
                newMode = ToolMode.HOE;
            }
        }
        if (!newMode.getId().equals(data.activeMode())) {
            ScrapMultitoolData newData = data.withActiveMode(newMode.getId());
            newData.saveToItemStack(this.itemStack);
            DisplayMode displayMode = new DisplayMode(this.itemStack);
            displayMode.updateModel(newMode, newData.getBatteryLevel());
        }
    }

    public class_2680 getTargetBlock(class_1937 level, class_1657 player) {
        class_243 direction;
        class_243 end;
        class_243 start = player.method_5836(1.0f);
        class_3965 hitResult = level.method_17742(new class_3959(start, end = start.method_1019((direction = player.method_5720()).method_1021((double)MultitoolConfig.raycastDistance)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            return level.method_8320(hitResult.method_17777());
        }
        return null;
    }
}

