/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity;

import de.markusbordihn.scraptechworkshop.block.hololog.HoloCubeBlock;
import de.markusbordihn.scraptechworkshop.client.hololog.HolologPlayer;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologData;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologParser;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologPlaybackContext;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologStatus;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloCubeBlockEntity
extends BlockEntity {
    public static final String ID = "holocube";
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String CUBE_UUID_TAG = "CubeUUID";
    private static final String HOLOLOG_ID_TAG = "HolologId";
    private static final String PLAYER_UUID_TAG = "PlayerUUID";
    private static final String LAST_STATUS_TAG = "LastStatus";
    private static final String ENDED_TICK_TAG = "EndedTick";
    private static final ResourceLocation DEFAULT_HOLOLOG = new ResourceLocation("scrap_tech_workshop", "holologs/intro/introduction");
    private static final double MAX_PLAYER_DISTANCE = 32.0;
    private static final int AUTO_RESET_TICKS = 20;
    public static BlockEntityType<HoloCubeBlockEntity> TYPE;
    private UUID cubeUUID;
    private ResourceLocation holologId;
    private UUID playerUUID;
    private UUID currentPlayerId;
    private HolologStatus lastKnownStatus = HolologStatus.READY;
    private long endedAtTick = -1L;

    public HoloCubeBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
        this.cubeUUID = UUID.randomUUID();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HoloCubeBlockEntity blockEntity) {
        if (!level.f_46443_) {
            return;
        }
        HolologStatus status = (HolologStatus)((Object)state.m_61143_(HoloCubeBlock.STATUS));
        ResourceLocation holologId = blockEntity.getHolologId();
        if (holologId == null) {
            if (status != HolologStatus.READY) {
                log.warn("[{}] Hololog ID is null but status is {}, resetting to READY", (Object)blockEntity.cubeUUID, (Object)status);
                HoloCubeBlock.updateStatus(level, pos, HolologStatus.READY);
            }
            return;
        }
        if (status == HolologStatus.ENDED) {
            if (blockEntity.endedAtTick < 0L) {
                blockEntity.endedAtTick = level.m_46467_();
            } else if (level.m_46467_() - blockEntity.endedAtTick > 20L) {
                log.debug("[{}] Auto-resetting from ENDED to READY", (Object)blockEntity.cubeUUID);
                HoloCubeBlock.updateStatus(level, pos, HolologStatus.READY);
                blockEntity.endedAtTick = -1L;
                blockEntity.stopPlayback();
            }
            return;
        }
        blockEntity.endedAtTick = -1L;
        boolean playerInRange = HoloCubeBlockEntity.hasNonSpectatorPlayerInRange(level, pos);
        if (status == HolologStatus.PLAYING) {
            log.trace("[{}] PLAYING - currentPlayerId: {}, playerInRange: {}", (Object)blockEntity.cubeUUID, (Object)blockEntity.currentPlayerId, (Object)playerInRange);
            if (!playerInRange && blockEntity.currentPlayerId != null) {
                log.debug("[{}] No player in range, stopping playback", (Object)blockEntity.cubeUUID);
                HoloCubeBlock.updateStatus(level, pos, HolologStatus.READY);
                blockEntity.stopPlayback();
                return;
            }
            if (blockEntity.currentPlayerId == null && playerInRange) {
                log.info("[{}] Starting playback for hololog: {}", (Object)blockEntity.cubeUUID, (Object)holologId);
                blockEntity.startPlayback(level, pos, holologId);
            }
        } else if (status == HolologStatus.READY && blockEntity.currentPlayerId != null) {
            blockEntity.stopPlayback();
        }
        blockEntity.lastKnownStatus = status;
    }

    private static boolean hasNonSpectatorPlayerInRange(Level level, BlockPos pos) {
        return level.m_6907_().stream().filter(player -> !player.m_5833_()).anyMatch(player -> {
            boolean inRange;
            double distance = player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            boolean bl = inRange = distance <= 1024.0;
            if (log.isTraceEnabled()) {
                log.trace("Player {} at distance {:.2f} blocks (max: {}): {}", (Object)player.m_7755_().getString(), (Object)Math.sqrt(distance), (Object)32.0, (Object)(inRange ? "IN RANGE" : "out of range"));
            }
            return inRange;
        });
    }

    private void startPlayback(Level level, BlockPos pos, ResourceLocation holologId) {
        log.info("[{}] startPlayback() called for hololog: {}", (Object)this.cubeUUID, (Object)holologId);
        if (holologId == null) {
            log.error("[{}] Cannot start playback: holologId is null", (Object)this.cubeUUID);
            return;
        }
        if (!level.f_46443_) {
            log.error("[{}] startPlayback() called on server side - this should never happen!", (Object)this.cubeUUID);
            return;
        }
        ResourceLocation localizedId = HolologParser.getLocalizedId(holologId);
        log.debug("[{}] Localized hololog ID: {}", (Object)this.cubeUUID, (Object)localizedId);
        Optional<HolologData> holologData = HolologParser.getHololog(localizedId);
        if (holologData.isEmpty()) {
            log.error("[{}] Failed to load hololog data for: {} (localized: {})", (Object)this.cubeUUID, (Object)holologId, (Object)localizedId);
            HoloCubeBlock.updateStatus(level, pos, HolologStatus.READY);
            return;
        }
        HolologData data = holologData.get();
        if (data.lines().isEmpty()) {
            log.error("[{}] Hololog has no lines: {}", (Object)this.cubeUUID, (Object)localizedId);
            HoloCubeBlock.updateStatus(level, pos, HolologStatus.READY);
            return;
        }
        log.info("[{}] Hololog loaded successfully: {} (lines: {}, default delay: {})", (Object)this.cubeUUID, (Object)localizedId, (Object)data.lines().size(), (Object)data.lineDelayTicks());
        HolologPlaybackContext.WorldContext context = new HolologPlaybackContext.WorldContext(level, pos);
        this.currentPlayerId = HolologPlayer.play(data, context, text -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && !player.m_5833_()) {
                player.m_5661_((Component)Component.m_237113_((String)("\u00a77[Hololog] \u00a7f" + text)), false);
            }
        }, () -> {
            log.info("[{}] Playback finished", (Object)this.cubeUUID);
            HoloCubeBlock.updateStatus(level, pos, HolologStatus.ENDED);
        });
        if (this.currentPlayerId == null) {
            log.error("[{}] HolologPlayer.play() returned null player ID!", (Object)this.cubeUUID);
            HoloCubeBlock.updateStatus(level, pos, HolologStatus.READY);
        } else {
            log.info("[{}] Playback started with player ID: {}", (Object)this.cubeUUID, (Object)this.currentPlayerId);
        }
    }

    private void stopPlayback() {
        if (this.currentPlayerId != null) {
            log.debug("[{}] Stopping playback", (Object)this.cubeUUID);
            HolologPlayer.stop(this.currentPlayerId);
            this.currentPlayerId = null;
        }
    }

    public void cleanup() {
        this.stopPlayback();
    }

    public void m_7651_() {
        super.m_7651_();
        this.cleanup();
    }

    public UUID getCubeUUID() {
        return this.cubeUUID;
    }

    public ResourceLocation getHolologId() {
        return this.holologId != null ? this.holologId : DEFAULT_HOLOLOG;
    }

    public void setHolologId(ResourceLocation holologId) {
        log.debug("[{}] Setting hololog ID to: {}", (Object)this.cubeUUID, (Object)holologId);
        this.holologId = holologId;
        this.m_6596_();
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void setPlayerUUID(UUID playerUUID) {
        log.debug("[{}] Setting player UUID to: {}", (Object)this.cubeUUID, (Object)playerUUID);
        this.playerUUID = playerUUID;
        this.m_6596_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(CUBE_UUID_TAG)) {
            this.cubeUUID = tag.m_128342_(CUBE_UUID_TAG);
        }
        if (tag.m_128441_(HOLOLOG_ID_TAG)) {
            try {
                this.holologId = new ResourceLocation(tag.m_128461_(HOLOLOG_ID_TAG));
            }
            catch (Exception e) {
                log.warn("[{}] Failed to load hololog ID: {}", (Object)this.cubeUUID, (Object)e.getMessage());
                this.holologId = DEFAULT_HOLOLOG;
            }
        }
        if (tag.m_128441_(PLAYER_UUID_TAG)) {
            this.playerUUID = tag.m_128342_(PLAYER_UUID_TAG);
        }
        if (tag.m_128441_(LAST_STATUS_TAG)) {
            try {
                this.lastKnownStatus = HolologStatus.valueOf(tag.m_128461_(LAST_STATUS_TAG).toUpperCase());
            }
            catch (Exception e) {
                log.warn("[{}] Failed to load last status: {}", (Object)this.cubeUUID, (Object)e.getMessage());
                this.lastKnownStatus = HolologStatus.READY;
            }
        }
        if (tag.m_128441_(ENDED_TICK_TAG)) {
            this.endedAtTick = tag.m_128454_(ENDED_TICK_TAG);
        }
        log.debug("[{}] Loaded HoloCube data", (Object)this.cubeUUID);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128362_(CUBE_UUID_TAG, this.cubeUUID);
        tag.m_128359_(LAST_STATUS_TAG, this.lastKnownStatus.name());
        tag.m_128356_(ENDED_TICK_TAG, this.endedAtTick);
        if (this.holologId != null) {
            tag.m_128359_(HOLOLOG_ID_TAG, this.holologId.toString());
        }
        if (this.playerUUID != null) {
            tag.m_128362_(PLAYER_UUID_TAG, this.playerUUID);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private void syncToClient() {
        Level currentLevel = this.f_58857_;
        if (currentLevel != null && !currentLevel.f_46443_) {
            currentLevel.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.syncToClient();
    }
}

