/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.hololog;

import de.markusbordihn.scraptechworkshop.data.hololog.HolologData;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologPlaybackContext;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.FastColor;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public final class HolologPlayerEffects {
    private static final double PARTICLE_SPAWN_SPREAD = 0.5;
    private static final double PARTICLE_VELOCITY_HORIZONTAL = 0.02;
    private static final double PARTICLE_VELOCITY_VERTICAL = 0.05;

    private HolologPlayerEffects() {
    }

    public static void playEffects(HolologData.HolologEffects effects, HolologPlaybackContext context, Vec3 effectPos) {
        if (!(context.getLevel() instanceof ClientLevel)) {
            return;
        }
        for (HolologData.HolologSound sound : effects.sfx()) {
            context.playSound(sound.id(), sound.volume(), sound.pitch());
        }
        for (HolologData.HolologParticle particle : effects.fx()) {
            HolologPlayerEffects.spawnParticles(particle, effectPos, context);
        }
    }

    private static void spawnParticles(HolologData.HolologParticle particle, Vec3 pos, HolologPlaybackContext context) {
        ParticleOptions particleType = HolologPlayerEffects.getParticleType(particle);
        for (int i = 0; i < particle.count(); ++i) {
            Vec3 spawnPos = pos.m_82520_((Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5);
            Vec3 velocity = new Vec3((Math.random() - 0.5) * 0.02, Math.random() * 0.05, (Math.random() - 0.5) * 0.02);
            context.spawnParticle(particleType, spawnPos, velocity);
        }
    }

    private static ParticleOptions getParticleType(HolologData.HolologParticle particle) {
        String particleId = particle.id().m_135815_();
        if ("dust".equals(particleId) && particle.color() != null) {
            Vector3f color = HolologPlayerEffects.parseColor(particle.color());
            return new DustParticleOptions(color, particle.scale());
        }
        return switch (particleId) {
            case "smoke" -> ParticleTypes.f_123762_;
            case "portal" -> ParticleTypes.f_123760_;
            case "crit" -> ParticleTypes.f_123797_;
            case "flash" -> ParticleTypes.f_123747_;
            default -> ParticleTypes.f_123810_;
        };
    }

    private static Vector3f parseColor(String hexColor) {
        if (hexColor == null || hexColor.isEmpty()) {
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }
        try {
            int color = Integer.parseInt(hexColor.replace("#", ""), 16);
            float r = (float)FastColor.ARGB32.m_13665_((int)(color | 0xFF000000)) / 255.0f;
            float g = (float)FastColor.ARGB32.m_13667_((int)(color | 0xFF000000)) / 255.0f;
            float b = (float)FastColor.ARGB32.m_13669_((int)(color | 0xFF000000)) / 255.0f;
            return new Vector3f(r, g, b);
        }
        catch (NumberFormatException e) {
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }
    }
}

