/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.hololog;

import de.markusbordihn.scraptechworkshop.client.hololog.HolologPlayer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class HolologPlayerManager {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final Map<UUID, HolologPlayer> ACTIVE_PLAYERS = new HashMap<UUID, HolologPlayer>();
    private static final Map<ResourceLocation, UUID> ACTIVE_HOLOLOG_IDS = new HashMap<ResourceLocation, UUID>();

    private HolologPlayerManager() {
    }

    public static UUID register(HolologPlayer player, ResourceLocation holologId) {
        UUID existingPlayerId = ACTIVE_HOLOLOG_IDS.get(holologId);
        if (existingPlayerId != null && ACTIVE_PLAYERS.containsKey(existingPlayerId)) {
            log.debug("Hololog {} is already playing with ID {}, reusing existing player", (Object)holologId, (Object)existingPlayerId);
            return existingPlayerId;
        }
        UUID id = UUID.randomUUID();
        ACTIVE_PLAYERS.put(id, player);
        ACTIVE_HOLOLOG_IDS.put(holologId, id);
        log.info("Registered hololog player {} for hololog: {}", (Object)id, (Object)holologId);
        return id;
    }

    public static HolologPlayer get(UUID playerId) {
        return ACTIVE_PLAYERS.get(playerId);
    }

    public static void remove(UUID playerId) {
        HolologPlayer player = ACTIVE_PLAYERS.remove(playerId);
        if (player != null) {
            ACTIVE_HOLOLOG_IDS.values().removeIf(id -> id.equals(playerId));
            log.debug("Removed hololog player: {}", (Object)playerId);
        }
    }

    public static void stopAll() {
        ACTIVE_PLAYERS.values().forEach(player -> player.stop());
        ACTIVE_PLAYERS.clear();
        ACTIVE_HOLOLOG_IDS.clear();
        log.debug("Stopped all hololog players");
    }

    public static void tickAll() {
        if (ACTIVE_PLAYERS.isEmpty()) {
            log.trace("Ticking {} active hololog players", (Object)ACTIVE_PLAYERS.size());
        }
        ACTIVE_PLAYERS.values().removeIf(player -> {
            boolean shouldRemove;
            if (player.isPlaying()) {
                player.tick();
            }
            boolean bl = shouldRemove = player.isStopped() && player.hasPlayedEndEffects();
            if (shouldRemove) {
                log.debug("Removing completed hololog player");
            }
            return shouldRemove;
        });
    }

    public static int getCurrentLine(ResourceLocation holologId) {
        HolologPlayer player;
        UUID playerId = ACTIVE_HOLOLOG_IDS.get(holologId);
        if (playerId != null && (player = ACTIVE_PLAYERS.get(playerId)) != null) {
            return player.getCurrentLine();
        }
        return -1;
    }
}

