/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.scraptechworkshop.block.entity.HoloCubeBlockEntity;
import de.markusbordihn.scraptechworkshop.block.hololog.HoloCubeBlock;
import de.markusbordihn.scraptechworkshop.client.hololog.HolologPlayer;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologData;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologParser;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologStatus;
import de.markusbordihn.scraptechworkshop.entity.hololog.HolologHumanoidEntity;
import de.markusbordihn.scraptechworkshop.registry.entity.HolologEntityRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloCubeBlockEntityRenderer<T extends HoloCubeBlockEntity>
implements BlockEntityRenderer<T> {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final double HOLOGRAM_CENTER_X = 0.5;
    private static final double HOLOGRAM_CENTER_Z = 0.5;
    private static final double HOLOGRAM_Y_OFFSET_ITEM = 0.7;
    private static final double HOLOGRAM_Y_OFFSET_BLOCK = 0.8;
    private static final double HOLOGRAM_Y_OFFSET_DEFAULT = 0.5;
    private static final float BLOCK_SCALE_MULTIPLIER = 0.6f;
    private static final float ENTITY_SCALE_MULTIPLIER = 0.8f;
    private static final float ENTITY_HEAD_BOB_SPEED = 0.1f;
    private static final float ENTITY_HEAD_BOB_AMOUNT = 3.0f;
    private static final int RENDER_DISTANCE = 32;
    private final Map<ResourceLocation, Entity> entityCache = new HashMap<ResourceLocation, Entity>();

    public HoloCubeBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (blockEntity.m_58900_().m_61143_(HoloCubeBlock.STATUS) != HolologStatus.PLAYING) {
            return;
        }
        ResourceLocation holologId = ((HoloCubeBlockEntity)((Object)blockEntity)).getHolologId();
        if (holologId == null) {
            return;
        }
        Optional<HolologData> holologData = HolologParser.getHololog(HolologParser.getLocalizedId(holologId));
        if (holologData.isEmpty()) {
            return;
        }
        HolologData.HolologDisplayEntity displayEntity = this.getDisplayEntity(holologData.get());
        if (displayEntity == null) {
            displayEntity = HolologData.HolologDisplayEntity.DEFAULT_VILLAGER;
        }
        try {
            switch (displayEntity.type()) {
                case ENTITY: {
                    this.renderEntity(blockEntity, displayEntity, poseStack, buffer, combinedLight);
                    break;
                }
                case BLOCK: {
                    this.renderBlock(blockEntity, displayEntity, poseStack, buffer, combinedLight, combinedOverlay);
                    break;
                }
                case ITEM: {
                    this.renderItem(blockEntity, displayEntity, poseStack, buffer, combinedLight, combinedOverlay);
                    break;
                }
                case HOLO_ENTITY: {
                    this.renderHoloEntity(blockEntity, displayEntity, poseStack, buffer, combinedLight);
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to render hologram display {} for block entity at {}: {}", (Object)displayEntity.id(), (Object)blockEntity.m_58899_(), (Object)e.getMessage());
        }
    }

    private HolologData.HolologDisplayEntity getDisplayEntity(HolologData hololog) {
        HolologData.HolologLine line;
        int currentLine = HolologPlayer.getCurrentLine(hololog.id());
        int displayLineIndex = Math.max(0, currentLine - 1);
        if (currentLine > 0 && displayLineIndex < hololog.lines().size() && (line = hololog.lines().get(displayLineIndex)).displayEntity() != null) {
            return line.displayEntity();
        }
        return hololog.displayEntity();
    }

    private void renderEntity(T blockEntity, HolologData.HolologDisplayEntity displayEntity, PoseStack poseStack, MultiBufferSource buffer, int combinedLight) {
        Entity entity = this.getOrCreateEntity(blockEntity.m_58904_(), displayEntity.id());
        if (entity == null) {
            return;
        }
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        EntityRenderer renderer = dispatcher.m_114382_(entity);
        Level level = blockEntity.m_58904_();
        if (level != null) {
            entity.f_19797_ = (int)level.m_46467_();
        }
        poseStack.m_85836_();
        this.prepareHologramPose(blockEntity, displayEntity, poseStack);
        renderer.m_7392_(entity, 0.0f, 0.0f, poseStack, buffer, combinedLight);
        poseStack.m_85849_();
    }

    private void renderHoloEntity(T blockEntity, HolologData.HolologDisplayEntity displayEntity, PoseStack poseStack, MultiBufferSource buffer, int combinedLight) {
        HolologHumanoidEntity holoEntity = this.getOrCreateHoloEntity(blockEntity.m_58904_(), displayEntity);
        if (holoEntity == null) {
            return;
        }
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        EntityRenderer renderer = dispatcher.m_114382_((Entity)holoEntity);
        Level level = blockEntity.m_58904_();
        if (level != null) {
            holoEntity.f_19797_ = (int)level.m_46467_();
        }
        poseStack.m_85836_();
        this.prepareHologramPose(blockEntity, displayEntity, poseStack);
        renderer.m_7392_((Entity)holoEntity, 0.0f, 0.0f, poseStack, buffer, combinedLight);
        poseStack.m_85849_();
    }

    private void renderBlock(T blockEntity, HolologData.HolologDisplayEntity displayEntity, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        poseStack.m_85836_();
        this.prepareHologramPose(blockEntity, displayEntity, poseStack);
        Minecraft.m_91087_().m_91289_().m_110912_(((Block)BuiltInRegistries.f_256975_.m_7745_(displayEntity.id())).m_49966_(), poseStack, buffer, combinedLight, combinedOverlay);
        poseStack.m_85849_();
    }

    private void renderItem(T blockEntity, HolologData.HolologDisplayEntity displayEntity, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        poseStack.m_85836_();
        this.prepareHologramPose(blockEntity, displayEntity, poseStack);
        Minecraft.m_91087_().m_91291_().m_269128_(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(displayEntity.id())), ItemDisplayContext.GROUND, combinedLight, combinedOverlay, poseStack, buffer, blockEntity.m_58904_(), 0);
        poseStack.m_85849_();
    }

    private Entity getOrCreateEntity(Level level, ResourceLocation entityId) {
        Entity cached;
        if (level == null) {
            return null;
        }
        if (this.entityCache.containsKey(entityId) && (cached = this.entityCache.get(entityId)) != null && !cached.m_213877_()) {
            return cached;
        }
        Optional entityType = BuiltInRegistries.f_256780_.m_6612_(entityId);
        if (entityType.isEmpty()) {
            log.warn("Entity type not found: {}", (Object)entityId);
            return null;
        }
        Entity entity = ((EntityType)entityType.get()).m_20615_(level);
        if (entity != null) {
            entity.m_6842_(false);
            this.entityCache.put(entityId, entity);
        }
        return entity;
    }

    private HolologHumanoidEntity getOrCreateHoloEntity(Level level, HolologData.HolologDisplayEntity displayEntity) {
        HolologHumanoidEntity holoEntity;
        Entity cached;
        if (level == null || HolologEntityRegistry.HOLOLOG_HUMANOID_ENTITY_TYPE == null) {
            return null;
        }
        ResourceLocation cacheKey = displayEntity.texture();
        if (cacheKey == null) {
            cacheKey = new ResourceLocation("scrap_tech_workshop", "hololog_humanoid_default");
        }
        if (this.entityCache.containsKey(cacheKey) && (cached = this.entityCache.get(cacheKey)) instanceof HolologHumanoidEntity) {
            HolologHumanoidEntity holoEntity2 = (HolologHumanoidEntity)cached;
            if (!cached.m_213877_()) {
                return holoEntity2;
            }
        }
        if ((holoEntity = (HolologHumanoidEntity)HolologEntityRegistry.HOLOLOG_HUMANOID_ENTITY_TYPE.m_20615_(level)) != null) {
            holoEntity.m_6842_(false);
            if (displayEntity.texture() != null) {
                holoEntity.setTexture(displayEntity.texture());
            }
            holoEntity.setSlim(displayEntity.slim());
            this.entityCache.put(cacheKey, (Entity)holoEntity);
        }
        return holoEntity;
    }

    private void prepareHologramPose(T blockEntity, HolologData.HolologDisplayEntity displayEntity, PoseStack poseStack) {
        double yOffset;
        double d = displayEntity.type() == HolologData.DisplayType.ITEM ? 0.7 : (yOffset = displayEntity.type() == HolologData.DisplayType.BLOCK ? 0.8 : 0.5);
        if (displayEntity.type() == HolologData.DisplayType.BLOCK) {
            poseStack.m_85837_(0.5, yOffset, 0.5);
            float scale = displayEntity.scale() * 0.6f;
            poseStack.m_85841_(scale, scale, scale);
            Level level = blockEntity.m_58904_();
            if (level != null && displayEntity.rotationSpeed() > 0.0f) {
                float time = level.m_46467_();
                float rotationSpeed = displayEntity.rotationSpeed();
                poseStack.m_252781_(Axis.f_252436_.m_252977_(time * rotationSpeed));
            }
            poseStack.m_85837_(-0.5, -0.5, -0.5);
        } else {
            poseStack.m_85837_(0.5, yOffset, 0.5);
        }
        if (displayEntity.type() == HolologData.DisplayType.ENTITY || displayEntity.type() == HolologData.DisplayType.HOLO_ENTITY) {
            boolean hasCustomRotation = false;
            if (displayEntity.type() == HolologData.DisplayType.HOLO_ENTITY) {
                boolean bl = hasCustomRotation = displayEntity.rotationX() != 0.0f || displayEntity.rotationY() != 0.0f || displayEntity.rotationZ() != 0.0f;
            }
            if (!hasCustomRotation) {
                Minecraft minecraft = Minecraft.m_91087_();
                if (minecraft.f_91074_ != null) {
                    Vec3 blockCenter = Vec3.m_82512_((Vec3i)blockEntity.m_58899_()).m_82520_(0.0, yOffset, 0.0);
                    Vec3 playerPos = minecraft.f_91074_.m_146892_();
                    Vec3 lookDir = playerPos.m_82546_(blockCenter).m_82541_();
                    float yaw = (float)Math.toDegrees(Math.atan2(lookDir.f_82479_, lookDir.f_82481_));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(yaw));
                    Level level = blockEntity.m_58904_();
                    if (level != null) {
                        float time = (float)level.m_46467_() + (float)minecraft.m_261169_() / 1.0E9f;
                        float headBob = (float)Math.sin(time * 0.1f) * 3.0f;
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(headBob));
                    }
                }
            } else {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(displayEntity.rotationX()));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(displayEntity.rotationY()));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(displayEntity.rotationZ()));
            }
            float scale = displayEntity.scale() * 0.8f;
            poseStack.m_85841_(scale, scale, scale);
        } else if (displayEntity.type() == HolologData.DisplayType.ITEM) {
            Level level = blockEntity.m_58904_();
            if (level != null && displayEntity.rotationSpeed() > 0.0f) {
                float time = level.m_46467_();
                float rotationSpeed = displayEntity.rotationSpeed();
                poseStack.m_252781_(Axis.f_252436_.m_252977_(time * rotationSpeed));
            }
            float scale = displayEntity.scale();
            poseStack.m_85841_(scale, scale, scale);
        }
    }

    public int m_142163_() {
        return 32;
    }
}

