/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.hololog;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface HolologPlaybackContext {
    public Level getLevel();

    public Vec3 getEffectPosition();

    default public void spawnParticle(ParticleOptions particle, Vec3 pos, Vec3 speed) {
        Level level = this.getLevel();
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            clientLevel.m_7106_(particle, pos.f_82479_, pos.f_82480_, pos.f_82481_, speed.f_82479_, speed.f_82480_, speed.f_82481_);
        }
    }

    default public void playSound(ResourceLocation soundId, float volume, float pitch) {
        SoundEvent sound = SoundEvent.m_262824_((ResourceLocation)soundId);
        Vec3 pos = this.getEffectPosition();
        this.getLevel().m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, sound, SoundSource.BLOCKS, volume, pitch, false);
    }

    public record UIContext(Level level, Vec3 position) implements HolologPlaybackContext
    {
        @Override
        public Level getLevel() {
            return this.level;
        }

        @Override
        public Vec3 getEffectPosition() {
            return this.position;
        }
    }

    public record WorldContext(Level level, BlockPos blockPos) implements HolologPlaybackContext
    {
        @Override
        public Level getLevel() {
            return this.level;
        }

        @Override
        public Vec3 getEffectPosition() {
            return Vec3.m_82512_((Vec3i)this.blockPos).m_82520_(0.0, 0.75, 0.0);
        }
    }
}

