/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.item;

import de.markusbordihn.scraptechworkshop.block.ScrapPileBlock;
import de.markusbordihn.scraptechworkshop.data.ScrapPileVariant;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ScrapPileBlockItem
extends BlockItem {
    public static final String MIXED_ID = "mixed_scrap_pile";
    public static final String METAL_ID = "metal_scrap_pile";
    public static final String TECH_ID = "tech_scrap_pile";
    private final ScrapPileVariant variant;

    public ScrapPileBlockItem(Block block, Item.Properties properties, ScrapPileVariant variant) {
        super(block, properties);
        this.variant = variant;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ScrapPileVariant existingVariant;
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState existingState = level.m_8055_(pos = context.m_8083_());
        if (existingState.m_60734_() instanceof ScrapPileBlock && (existingVariant = (ScrapPileVariant)((Object)existingState.m_61143_(ScrapPileBlock.VARIANT))) == this.variant) {
            int currentSize = (Integer)existingState.m_61143_((Property)ScrapPileBlock.SIZE);
            if (currentSize < 4) {
                if (!level.f_46443_) {
                    BlockState newState = (BlockState)existingState.m_61124_((Property)ScrapPileBlock.SIZE, (Comparable)Integer.valueOf(currentSize + 1));
                    level.m_7731_(pos, newState, 3);
                    Player player = context.m_43723_();
                    if (player != null && !player.m_150110_().f_35937_) {
                        context.m_43722_().m_41774_(1);
                    }
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.FAIL;
        }
        return super.m_6225_(context);
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        BlockState state;
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState existingState = level.m_8055_(pos = context.m_8083_());
        if (existingState.m_60734_() instanceof ScrapPileBlock) {
            int currentSize;
            ScrapPileVariant existingVariant = (ScrapPileVariant)((Object)existingState.m_61143_(ScrapPileBlock.VARIANT));
            if (existingVariant == this.variant && (currentSize = ((Integer)existingState.m_61143_((Property)ScrapPileBlock.SIZE)).intValue()) < 4) {
                BlockState newState = (BlockState)existingState.m_61124_((Property)ScrapPileBlock.SIZE, (Comparable)Integer.valueOf(currentSize + 1));
                level.m_7731_(pos, newState, 3);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.FAIL;
        }
        InteractionResult result = super.m_40576_(context);
        if (result.m_19077_() && !level.f_46443_ && (state = level.m_8055_(pos)).m_60734_() instanceof ScrapPileBlock) {
            BlockState newState = (BlockState)((BlockState)state.m_61124_((Property)ScrapPileBlock.SIZE, (Comparable)Integer.valueOf(1))).m_61124_(ScrapPileBlock.VARIANT, (Comparable)((Object)this.variant));
            level.m_7731_(pos, newState, 3);
        }
        return result;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.scrap_tech_workshop.scrap_pile.tooltip"));
        tooltip.add((Component)Component.m_237115_((String)"item.scrap_tech_workshop.scrap_pile.stacking"));
        String variantKey = switch (this.variant) {
            default -> throw new IncompatibleClassChangeError();
            case ScrapPileVariant.MIXED -> MIXED_ID;
            case ScrapPileVariant.METAL -> METAL_ID;
            case ScrapPileVariant.TECH -> TECH_ID;
        };
        tooltip.add((Component)Component.m_237115_((String)("item.scrap_tech_workshop." + variantKey + ".tooltip")));
    }

    public ScrapPileVariant getVariant() {
        return this.variant;
    }
}

