/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.item.component;

import de.markusbordihn.scraptechworkshop.item.ModItems;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EnergyCellItem
extends Item {
    public static final String ID = "energy_cell";
    public static final int ENERGY_MAX = 5000;
    private final int initialEnergy;

    public EnergyCellItem(Item.Properties properties) {
        this(properties, 5000);
    }

    public EnergyCellItem(Item.Properties properties, int initialEnergy) {
        super(properties.m_41487_(1).m_41503_(5000).m_41497_(Rarity.UNCOMMON));
        this.initialEnergy = Math.max(1, Math.min(initialEnergy, 5000));
    }

    public int getEnergy(ItemStack itemStack) {
        return 5000 - itemStack.m_41773_();
    }

    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        this.setEnergy(stack, this.initialEnergy);
        return stack;
    }

    public void setEnergy(ItemStack itemStack, int energy) {
        itemStack.m_41721_(5000 - Math.max(1, Math.min(energy, 5000)));
    }

    public void consumeEnergy(ItemStack itemStack, int amount) {
        int currentEnergy = this.getEnergy(itemStack);
        this.setEnergy(itemStack, Math.max(1, currentEnergy - amount));
    }

    public boolean hasEnergy(ItemStack itemStack, int amount) {
        return this.getEnergy(itemStack) >= amount;
    }

    public float getEnergyPercentage(ItemStack itemStack) {
        return (float)this.getEnergy(itemStack) / 5000.0f;
    }

    public ItemStack createEmptyBattery() {
        return new ItemStack((ItemLike)ModItems.EMPTY_ENERGY_CELL.get());
    }

    public boolean m_142522_(ItemStack itemStack) {
        return true;
    }

    public int m_142159_(ItemStack itemStack) {
        float energyRatio = this.getEnergyPercentage(itemStack);
        return energyRatio > 0.6f ? 65280 : (energyRatio > 0.3f ? 0xFFFF00 : 0xFF0000);
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"item.scrap_tech_workshop.energy_cell.description"));
        int energy = this.getEnergy(itemStack);
        tooltipComponents.add((Component)Component.m_237113_((String)("Energy: " + energy + "/5000")).m_130938_(style -> style.m_178520_(this.m_142159_(itemStack))));
        super.m_7373_(itemStack, level, tooltipComponents, isAdvanced);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return false;
    }
}

