/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.item.tool.multitool;

import de.markusbordihn.scraptechworkshop.Constants;
import de.markusbordihn.scraptechworkshop.config.MultitoolConfig;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyData;
import de.markusbordihn.scraptechworkshop.data.multitool.DisplayMode;
import de.markusbordihn.scraptechworkshop.data.multitool.ScrapMultitoolData;
import de.markusbordihn.scraptechworkshop.data.multitool.ToolMode;
import de.markusbordihn.scraptechworkshop.energy.EnergyManager;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.item.multitool.ToolModeDetector;
import de.markusbordihn.scraptechworkshop.menu.ScrapMultitoolMenuProvider;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapMultitoolItem
extends DiggerItem {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");

    public ScrapMultitoolItem(Item.Properties properties) {
        super(4.0f, -2.4f, (Tier)Tiers.IRON, BlockTags.f_144282_, properties.m_41503_(MultitoolConfig.energyMax).m_41497_(Rarity.RARE));
    }

    public static ItemStack createWithBattery() {
        ItemStack battery = new ItemStack((ItemLike)ModItems.SLIGHTLY_DAMAGED_ENERGY_CELL.get());
        Item item = battery.m_41720_();
        if (item instanceof EnergyCellItem) {
            EnergyCellItem energyCell = (EnergyCellItem)item;
            energyCell.setEnergy(battery, 2500);
        }
        ItemStack multitool = new ItemStack((ItemLike)ModItems.SCRAP_MULTITOOL.get());
        ScrapMultitoolData data = ScrapMultitoolData.createDefault().withBattery(battery);
        data.saveToItemStack(multitool);
        Item item2 = multitool.m_41720_();
        if (item2 instanceof ScrapMultitoolItem) {
            ScrapMultitoolItem multitoolItem = (ScrapMultitoolItem)item2;
            multitoolItem.syncEnergyWithBattery(multitool);
        }
        DisplayMode displayMode = new DisplayMode(multitool);
        displayMode.updateModel(ToolMode.fromId(data.activeMode()), data.getBatteryLevel());
        return multitool;
    }

    public void m_7836_(ItemStack itemStack, Level level, Player player) {
        super.m_7836_(itemStack, level, player);
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        if (!data.hasBattery()) {
            ItemStack battery = new ItemStack((ItemLike)ModItems.SLIGHTLY_DAMAGED_ENERGY_CELL.get());
            Item item = battery.m_41720_();
            if (item instanceof EnergyCellItem) {
                EnergyCellItem energyCell = (EnergyCellItem)item;
                energyCell.setEnergy(battery, 2500);
            }
            data = data.withBattery(battery);
            data.saveToItemStack(itemStack);
            this.syncEnergyWithBattery(itemStack);
            DisplayMode displayMode = new DisplayMode(itemStack);
            displayMode.updateModel(ToolMode.fromId(data.activeMode()), data.getBatteryLevel());
        }
    }

    public float m_8102_(ItemStack itemStack, BlockState state) {
        boolean isEffective;
        ToolModeDetector detector = new ToolModeDetector(itemStack);
        detector.updateToolMode(null, state);
        if (!this.hasEnergyFromBattery(itemStack, MultitoolConfig.energyPerBlock)) {
            return 1.0f;
        }
        ToolMode mode = detector.getToolModeForBlock(state);
        if (mode != ToolMode.NONE) {
            return this.getPoweredSpeed(mode);
        }
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        ToolMode activeToolMode = ToolMode.fromId(data.activeMode());
        switch (activeToolMode) {
            case PICKAXE: {
                boolean bl = state.m_204336_(BlockTags.f_144282_);
                break;
            }
            case AXE: {
                boolean bl = state.m_204336_(BlockTags.f_144280_);
                break;
            }
            case SHOVEL: {
                boolean bl = state.m_204336_(BlockTags.f_144283_);
                break;
            }
            case HOE: {
                boolean bl = state.m_204336_(BlockTags.f_144281_);
                break;
            }
            default: {
                boolean bl = isEffective = state.m_204336_(BlockTags.f_144282_);
            }
        }
        if (isEffective) {
            return this.getPoweredSpeed(activeToolMode);
        }
        return super.m_8102_(itemStack, state);
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
            if (!ToolMode.SWORD.getId().equals(data.activeMode())) {
                ScrapMultitoolData newData = data.withActiveMode(ToolMode.SWORD.getId());
                newData.saveToItemStack(itemStack);
                DisplayMode displayMode = new DisplayMode(itemStack);
                displayMode.updateModel(ToolMode.SWORD, newData.getBatteryLevel());
            }
        }
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        return this.consumeEnergyFromBattery(itemStack, data, MultitoolConfig.energyPerAttack);
    }

    public boolean m_6813_(ItemStack itemStack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        ScrapMultitoolData data;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ToolModeDetector detector = new ToolModeDetector(itemStack);
            detector.updateToolMode(player, state);
        }
        if (this.consumeEnergyFromBattery(itemStack, data = ScrapMultitoolData.fromItemStack(itemStack), MultitoolConfig.energyPerBlock)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                ToolModeDetector detector = new ToolModeDetector(itemStack);
                detector.updateToolMode(player, state);
            }
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_6144_() && !level.f_46443_) {
            this.openMultitoolScreen(player, itemStack, hand);
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.f_46443_);
        }
        if (!level.f_46443_) {
            ToolModeDetector detector = new ToolModeDetector(itemStack);
            BlockState targetBlock = detector.getTargetBlock(level, player);
            detector.updateToolMode(player, targetBlock);
        }
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        if (!level.f_46443_ && this.hasEnergyFromBattery(itemStack, MultitoolConfig.energyPerUse)) {
            Vec3 playerPos = player.m_20182_().m_82520_(0.0, 1.0, 0.0);
            Vec3 lookDirection = player.m_20154_();
            Vec3 particlePos = playerPos.m_82549_(lookDirection.m_82490_(1.5));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 5, 0.1, 0.1, 0.1, 0.02);
            }
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11739_, SoundSource.PLAYERS, 0.5f, 1.2f);
            this.consumeEnergyFromBattery(itemStack, data, MultitoolConfig.energyPerUse);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            return InteractionResult.PASS;
        }
        return super.m_6225_(context);
    }

    private float getPoweredSpeed(ToolMode mode) {
        return switch (mode) {
            case ToolMode.PICKAXE -> 6.0f;
            case ToolMode.AXE -> 6.0f;
            case ToolMode.SHOVEL -> 6.0f;
            case ToolMode.HOE -> 4.0f;
            case ToolMode.SWORD -> 6.0f;
            default -> 6.0f;
        };
    }

    private void openMultitoolScreen(Player player, ItemStack stack, InteractionHand hand) {
        if (Constants.IS_FABRIC) {
            try {
                log.warn("Fabric screen opening not yet implemented");
            }
            catch (Exception e) {
                log.error("Failed to open multitool screen", (Throwable)e);
            }
        } else {
            player.m_5893_((MenuProvider)new ScrapMultitoolMenuProvider(stack, hand));
        }
    }

    public boolean m_142522_(ItemStack itemStack) {
        return true;
    }

    public int m_142159_(ItemStack itemStack) {
        EnergyData energyData = EnergyManager.getEnergyData(itemStack, MultitoolConfig.energyMax);
        float energyRatio = energyData.getPercentage();
        return energyRatio > 0.6f ? 65280 : (energyRatio > 0.3f ? 0xFFFF00 : 0xFF0000);
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"item.scrap_tech_workshop.scrap_multitool.description"));
        EnergyData energyData = EnergyManager.getEnergyData(itemStack, MultitoolConfig.energyMax);
        int displayEnergy = energyData.getDisplayEnergy();
        tooltipComponents.add((Component)Component.m_237113_((String)("Energy: " + displayEnergy + "%")).m_130938_(style -> style.m_178520_(this.m_142159_(itemStack))));
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        if (data.hasBattery()) {
            tooltipComponents.add((Component)Component.m_237113_((String)"Battery: Installed").m_130938_(style -> style.m_178520_(65280)));
        }
        String mode = data.activeMode();
        ToolMode activeMode = ToolMode.fromId(mode);
        MutableComponent modeComponent = switch (activeMode) {
            case ToolMode.AXE -> Component.m_237113_((String)"Mode: Axe (Auto-detected)").m_130938_(style -> style.m_178520_(0xFF8800));
            case ToolMode.PICKAXE -> Component.m_237113_((String)"Mode: Pickaxe (Auto-detected)").m_130938_(style -> style.m_178520_(0x888888));
            case ToolMode.SHOVEL -> Component.m_237113_((String)"Mode: Shovel (Auto-detected)").m_130938_(style -> style.m_178520_(0xBB8844));
            case ToolMode.HOE -> Component.m_237113_((String)"Mode: Hoe (Auto-detected)").m_130938_(style -> style.m_178520_(43520));
            case ToolMode.SWORD -> Component.m_237113_((String)"Mode: Sword (Combat)").m_130938_(style -> style.m_178520_(0xFF0000));
            default -> Component.m_237113_((String)"Mode: Normal").m_130938_(style -> style.m_178520_(0xAAAAAA));
        };
        tooltipComponents.add((Component)modeComponent);
        tooltipComponents.add((Component)Component.m_237113_((String)"Shift + Right-click to configure").m_130938_(style -> style.m_131155_(Boolean.valueOf(true))));
        super.m_7373_(itemStack, level, tooltipComponents, isAdvanced);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean m_8120_(ItemStack itemStack) {
        return false;
    }

    public void syncEnergyWithBattery(ItemStack itemStack) {
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        if (data.hasBattery()) {
            ItemStack battery = data.battery();
            Item item = battery.m_41720_();
            if (item instanceof EnergyCellItem) {
                EnergyCellItem batteryItem = (EnergyCellItem)item;
                int batteryEnergy = batteryItem.getEnergy(battery);
                if (batteryEnergy <= 1) {
                    ItemStack emptyBattery = batteryItem.createEmptyBattery();
                    ScrapMultitoolData updatedData = data.withBattery(emptyBattery);
                    updatedData.saveToItemStack(itemStack);
                    EnergyManager.setEnergy(itemStack, MultitoolConfig.energyMax, 0);
                    return;
                }
                float energyRatio = (float)batteryEnergy / 5000.0f;
                int multitoolEnergy = Math.round((float)MultitoolConfig.energyMax * energyRatio);
                EnergyManager.setEnergy(itemStack, MultitoolConfig.energyMax, multitoolEnergy);
            } else {
                EnergyManager.setEnergy(itemStack, MultitoolConfig.energyMax, 0);
            }
        } else {
            EnergyManager.setEnergy(itemStack, MultitoolConfig.energyMax, 0);
        }
    }

    private boolean consumeEnergyFromBattery(ItemStack itemStack, ScrapMultitoolData data, int amount) {
        if (!data.hasBattery()) {
            return false;
        }
        ItemStack battery = data.battery();
        if (!(battery.m_41720_() instanceof EnergyCellItem)) {
            return false;
        }
        int batteryEnergy = ((EnergyCellItem)battery.m_41720_()).getEnergy(battery);
        if (batteryEnergy < amount) {
            return false;
        }
        EnergyManager.consumeWithBatteryBackup(itemStack, MultitoolConfig.energyMax, amount, battery);
        ScrapMultitoolData updatedData = data.withBattery(battery);
        updatedData.saveToItemStack(itemStack);
        this.syncEnergyWithBattery(itemStack);
        return true;
    }

    private boolean hasEnergyFromBattery(ItemStack itemStack, int amount) {
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        if (!data.hasBattery()) {
            return false;
        }
        ItemStack battery = data.battery();
        Item item = battery.m_41720_();
        if (!(item instanceof EnergyCellItem)) {
            return false;
        }
        EnergyCellItem batteryItem = (EnergyCellItem)item;
        return batteryItem.getEnergy(battery) >= amount;
    }
}

