/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity.collectorstation;

import de.markusbordihn.scraptechworkshop.block.collectorstation.CollectorStationBlock;
import de.markusbordihn.scraptechworkshop.block.entity.AbstractWorkshopBlockEntity;
import de.markusbordihn.scraptechworkshop.block.entity.collectorstation.CollectorStationContainer;
import de.markusbordihn.scraptechworkshop.config.CollectorStationConfig;
import de.markusbordihn.scraptechworkshop.data.collectorstation.CollectorStationStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerConsumer;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerData;
import de.markusbordihn.scraptechworkshop.item.upgrade.ChargeUpgradeItem;
import de.markusbordihn.scraptechworkshop.item.upgrade.SpeedUpgradeItem;
import de.markusbordihn.scraptechworkshop.loot.ScrapLootGenerator;
import de.markusbordihn.scraptechworkshop.menu.CollectorStationMenu;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CollectorStationBlockEntity
extends AbstractWorkshopBlockEntity
implements EnergyPowerConsumer {
    public static final int BATTERY_SLOT = 0;
    public static final int FIRST_STORAGE_SLOT = 1;
    public static final int LAST_STORAGE_SLOT = 24;
    public static final int STORAGE_SLOTS = 24;
    public static final int FIRST_UPGRADE_SLOT = 25;
    public static final int LAST_UPGRADE_SLOT = 28;
    public static final int TOTAL_SLOTS = 29;
    private static final Logger log = LogManager.getLogger();
    private static final int ENERGY_CONSUMPTION_INTERVAL = 20;
    private static final int ITEM_ADDITION_INTERVAL = 10;
    private static final int ENERGY_CONSUMPTION_AMOUNT = 5;
    private static final float SOUND_VOLUME = 0.5f;
    private static final float SOUND_PITCH = 1.0f;
    private static final String TRANSLATION_KEY = "container.scrap_tech_workshop.collector_station";
    private static final String STATE_TIMER_TAG = "StateTimer";
    private static final String BIOME_TAG = "Biome";
    private static final int DATA_STATUS = 0;
    private static final int DATA_STATE_TIMER = 1;
    private static final int DATA_COUNT = 2;
    private static final int ENERGY_CAPACITY_MAH = 5000;
    private static final int ENERGY_CHARGE_INTERVAL = 5;
    public static BlockEntityType<CollectorStationBlockEntity> TYPE;
    private final CollectorStationContainer container;
    private final int tickOffset;
    private int stateTimer = 0;
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> CollectorStationBlockEntity.this.getStatus().ordinal();
                case 1 -> CollectorStationBlockEntity.this.stateTimer;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CollectorStationBlockEntity.this.setStatus(CollectorStationStatus.values()[value]);
                    break;
                }
                case 1: {
                    CollectorStationBlockEntity.this.stateTimer = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private EnergyPowerData energyData = EnergyPowerData.empty();
    private String cachedBiome = "";
    private List<ItemStack> pendingItems = new ArrayList<ItemStack>();
    private int processingIndex = 0;

    public CollectorStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(TYPE, blockPos, blockState);
        this.tickOffset = Math.abs((blockPos.m_123341_() * 31 + blockPos.m_123342_() * 17 + blockPos.m_123343_() * 13) % CollectorStationConfig.checkInterval);
        this.container = new CollectorStationContainer(this);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, CollectorStationBlockEntity blockEntity) {
        if (level.f_46443_) {
            blockEntity.clientTick(level, blockPos, blockState);
        } else {
            blockEntity.serverTick(level, blockPos, blockState);
        }
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.container.getItems();
    }

    @Override
    protected WorldlyContainer getContainerDelegate() {
        return this.container;
    }

    private void clientTick(Level level, BlockPos blockPos, BlockState blockState) {
    }

    private void serverTick(Level level, BlockPos blockPos, BlockState blockState) {
        CollectorStationStatus currentStatus = this.getStatus();
        if ((level.m_46467_() + (long)this.tickOffset) % 5L == 0L) {
            this.chargeFromBattery(this.getEnergyTransferRate());
        }
        if (!this.hasStableEnergy(CollectorStationConfig.energyPerCycle)) {
            if (currentStatus != CollectorStationStatus.NO_POWER) {
                this.setStatus(CollectorStationStatus.NO_POWER);
                this.stateTimer = 0;
            }
            return;
        }
        if ((level.m_46467_() + (long)this.tickOffset) % (long)CollectorStationConfig.checkInterval != 0L) {
            return;
        }
        switch (this.getStatus()) {
            case NO_POWER: {
                this.setStatus(CollectorStationStatus.CHARGING);
                this.stateTimer = 0;
                log.debug("[CollectorStation@{}] Status changed: NO_POWER -> CHARGING", (Object)blockPos);
                this.playSound(level, blockPos, SoundEvents.f_11739_, 0.3f, 1.2f);
                break;
            }
            case CHARGING: {
                int chargeMultiplier = this.getChargeMultiplierBonus();
                this.stateTimer += CollectorStationConfig.checkInterval * chargeMultiplier;
                if (this.stateTimer == CollectorStationConfig.checkInterval * chargeMultiplier) {
                    this.playSound(level, blockPos, SoundEvents.f_11737_, 0.5f, 1.5f);
                }
                if (this.stateTimer % 20 == 0) {
                    this.consumeEnergy(5);
                }
                if (this.stateTimer < CollectorStationConfig.chargingTime) break;
                if (this.hasSpaceInStorage()) {
                    this.setStatus(CollectorStationStatus.COLLECTING);
                    this.stateTimer = 0;
                    this.cachedBiome = ((ResourceKey)level.m_204166_(blockPos).m_203543_().get()).m_135782_().toString();
                    log.debug("[CollectorStation@{}] Status changed: CHARGING -> COLLECTING (Biome: {})", (Object)blockPos, (Object)this.cachedBiome);
                    this.playSound(level, blockPos, SoundEvents.f_12312_, 0.5f, 0.8f);
                    break;
                }
                this.setStatus(CollectorStationStatus.NO_STORAGE);
                this.stateTimer = 0;
                log.debug("[CollectorStation@{}] Status changed: CHARGING -> NO_STORAGE (storage full)", (Object)blockPos);
                this.playSound(level, blockPos, SoundEvents.f_12055_, 0.5f, 0.7f);
                break;
            }
            case NO_STORAGE: {
                if (!this.hasSpaceInStorage()) break;
                this.setStatus(CollectorStationStatus.COLLECTING);
                this.stateTimer = 0;
                this.cachedBiome = ((ResourceKey)level.m_204166_(blockPos).m_203543_().get()).m_135782_().toString();
                log.debug("[CollectorStation@{}] Status changed: NO_STORAGE -> COLLECTING (Biome: {})", (Object)blockPos, (Object)this.cachedBiome);
                this.playSound(level, blockPos, SoundEvents.f_12312_, 0.5f, 0.8f);
                break;
            }
            case COLLECTING: {
                int speedMultiplier = this.getSpeedMultiplierBonus();
                this.stateTimer += CollectorStationConfig.checkInterval * speedMultiplier;
                if (this.stateTimer < CollectorStationConfig.collectingTime) break;
                this.setStatus(CollectorStationStatus.RETURNING);
                this.stateTimer = 0;
                log.debug("[CollectorStation@{}] Status changed: COLLECTING -> RETURNING (collected for {} ticks)", (Object)blockPos, (Object)CollectorStationConfig.collectingTime);
                this.playSound(level, blockPos, SoundEvents.f_12311_, 0.5f, 0.9f);
                break;
            }
            case RETURNING: {
                this.stateTimer += CollectorStationConfig.checkInterval;
                if (this.stateTimer < CollectorStationConfig.returningTime) break;
                this.setStatus(CollectorStationStatus.PROCESSING);
                this.stateTimer = 0;
                this.processingIndex = 0;
                log.debug("[CollectorStation@{}] Status changed: RETURNING -> PROCESSING", (Object)blockPos);
                this.playSound(level, blockPos, SoundEvents.f_11668_, 0.3f, 1.5f);
                this.pendingItems = ScrapLootGenerator.generateScrapForBiome(level, blockPos, this.cachedBiome);
                log.debug("[CollectorStation@{}] Generated {} scrap items to process", (Object)blockPos, (Object)this.pendingItems.size());
                break;
            }
            case PROCESSING: {
                this.stateTimer += CollectorStationConfig.checkInterval;
                if (this.stateTimer % 10 == 0 && this.processingIndex < this.pendingItems.size()) {
                    ItemStack scrap = this.pendingItems.get(this.processingIndex);
                    if (!scrap.m_41619_()) {
                        this.addSingleScrapItem(scrap, blockPos);
                        this.playSound(level, blockPos, SoundEvents.f_12019_, 0.3f, 1.2f);
                    }
                    ++this.processingIndex;
                }
                if (this.stateTimer < CollectorStationConfig.processingTime || this.processingIndex < this.pendingItems.size()) break;
                this.setStatus(CollectorStationStatus.CHARGING);
                this.stateTimer = 0;
                this.pendingItems.clear();
                this.processingIndex = 0;
                log.debug("[CollectorStation@{}] Status changed: PROCESSING -> CHARGING (cycle complete)", (Object)blockPos);
                this.playSound(level, blockPos, SoundEvents.f_11738_, 0.4f, 1.0f);
            }
        }
        this.m_6596_();
    }

    private boolean hasSpaceInStorage() {
        for (int i = 1; i <= 24; ++i) {
            ItemStack stack = this.container.m_8020_(i);
            if (!stack.m_41619_() && stack.m_41613_() >= stack.m_41741_()) continue;
            return true;
        }
        return false;
    }

    private int getSpeedMultiplierBonus() {
        int totalMultiplier = 1;
        for (int i = 25; i <= 28; ++i) {
            Item item;
            ItemStack stack = this.container.m_8020_(i);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof SpeedUpgradeItem)) continue;
            SpeedUpgradeItem speedUpgrade = (SpeedUpgradeItem)item;
            totalMultiplier += speedUpgrade.getSpeedMultiplier() - 1;
        }
        return totalMultiplier;
    }

    private int getChargeMultiplierBonus() {
        int totalMultiplier = 1;
        for (int i = 25; i <= 28; ++i) {
            Item item;
            ItemStack stack = this.container.m_8020_(i);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ChargeUpgradeItem)) continue;
            ChargeUpgradeItem chargeUpgrade = (ChargeUpgradeItem)item;
            totalMultiplier += chargeUpgrade.getChargeMultiplier() - 1;
        }
        return totalMultiplier;
    }

    private void addSingleScrapItem(ItemStack scrap, BlockPos blockPos) {
        if (scrap.m_41619_()) {
            return;
        }
        for (int i = 1; i <= 24; ++i) {
            ItemStack slotStack = this.container.m_8020_(i);
            if (slotStack.m_41619_()) {
                this.container.m_6836_(i, scrap.m_41777_());
                log.debug("[CollectorStation@{}] Added {} x{} to slot {}", (Object)blockPos, (Object)scrap.m_41720_(), (Object)scrap.m_41613_(), (Object)i);
                return;
            }
            if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)scrap) || slotStack.m_41613_() + scrap.m_41613_() > slotStack.m_41741_()) continue;
            slotStack.m_41769_(scrap.m_41613_());
            log.debug("[CollectorStation@{}] Stacked {} x{} into slot {} (total: {})", (Object)blockPos, (Object)scrap.m_41720_(), (Object)scrap.m_41613_(), (Object)i, (Object)slotStack.m_41613_());
            return;
        }
        log.warn("[CollectorStation@{}] No space for {} x{}", (Object)blockPos, (Object)scrap.m_41720_(), (Object)scrap.m_41613_());
    }

    private void playSound(Level level, BlockPos blockPos, SoundEvent sound, float volume, float pitch) {
        if (level != null && !level.f_46443_) {
            level.m_5594_(null, blockPos, sound, SoundSource.BLOCKS, volume, pitch);
        }
    }

    @Override
    public ItemStack getBattery() {
        return this.container.m_8020_(0);
    }

    @Override
    public EnergyPowerData getEnergyData() {
        return new EnergyPowerData(this.energyData.currentEnergy(), this.container.m_8020_(0), this.energyData.debounceData());
    }

    @Override
    public void setEnergyData(EnergyPowerData data) {
        this.energyData = new EnergyPowerData(data.currentEnergy(), data.battery(), data.debounceData());
        this.container.m_6836_(0, data.battery());
        this.m_6596_();
    }

    @Override
    public int getEnergyCapacity() {
        return 5000;
    }

    @Override
    public void markDirty() {
        this.m_6596_();
    }

    public CollectorStationContainer getContainer() {
        return this.container;
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    public CollectorStationStatus getStatus() {
        Level currentLevel = this.m_58904_();
        if (currentLevel != null && this.m_58900_().m_61138_(CollectorStationBlock.STATE)) {
            return (CollectorStationStatus)((Object)this.m_58900_().m_61143_(CollectorStationBlock.STATE));
        }
        return CollectorStationStatus.NO_POWER;
    }

    private void setStatus(CollectorStationStatus newStatus) {
        BlockState currentState;
        Level currentLevel = this.m_58904_();
        if (currentLevel != null && this.m_58900_().m_61138_(CollectorStationBlock.STATE) && (currentState = this.m_58900_()).m_61143_(CollectorStationBlock.STATE) != newStatus) {
            currentLevel.m_7731_(this.f_58858_, (BlockState)currentState.m_61124_(CollectorStationBlock.STATE, (Comparable)((Object)newStatus)), 3);
        }
    }

    public int getStateTimer() {
        return this.stateTimer;
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.stateTimer = compoundTag.m_128451_(STATE_TIMER_TAG);
        this.loadEnergyPowerConsumer(compoundTag);
        this.cachedBiome = compoundTag.m_128461_(BIOME_TAG);
        this.energyData = new EnergyPowerData(this.energyData.currentEnergy(), this.container.m_8020_(0), this.energyData.debounceData());
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128405_(STATE_TIMER_TAG, this.stateTimer);
        this.saveEnergyPowerConsumer(compoundTag);
        compoundTag.m_128359_(BIOME_TAG, this.cachedBiome);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)TRANSLATION_KEY);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new CollectorStationMenu(windowId, playerInventory, this, this.containerData);
    }
}

