/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.windturbine;

import de.markusbordihn.scraptechworkshop.block.entity.windturbine.ScrapWindTurbineBlockEntity;
import de.markusbordihn.scraptechworkshop.block.multiblock.MultiBlockStructure;
import de.markusbordihn.scraptechworkshop.data.windturbine.ScrapWindTurbineStatus;
import de.markusbordihn.scraptechworkshop.menu.MenuManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ScrapWindTurbineBlock
extends BaseEntityBlock
implements MultiBlockStructure {
    public static final String ID = "scrap_wind_turbine";
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<ScrapWindTurbineStatus> STATUS = EnumProperty.m_61587_((String)"status", ScrapWindTurbineStatus.class);
    private static final VoxelShape SHAPE_UPPER = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHAPE_LOWER_NORTH = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_LOWER_SOUTH = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_LOWER_WEST = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_LOWER_EAST = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public ScrapWindTurbineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(STATUS, (Comparable)((Object)ScrapWindTurbineStatus.IDLE))).m_61124_((Property)HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public static void updateStatus(Level level, BlockPos blockPos, ScrapWindTurbineStatus newStatus) {
        BlockState currentState = level.m_8055_(blockPos);
        if (currentState.m_60734_() instanceof ScrapWindTurbineBlock && currentState.m_61143_(STATUS) != newStatus) {
            level.m_7731_(blockPos, (BlockState)currentState.m_61124_(STATUS, (Comparable)((Object)newStatus)), 3);
        }
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        if (this.isUpperBlock(blockState)) {
            return SHAPE_UPPER;
        }
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        return switch (facing) {
            case Direction.NORTH -> SHAPE_LOWER_NORTH;
            case Direction.SOUTH -> SHAPE_LOWER_SOUTH;
            case Direction.WEST -> SHAPE_LOWER_WEST;
            case Direction.EAST -> SHAPE_LOWER_EAST;
            default -> SHAPE_LOWER_NORTH;
        };
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return this.isUpperBlock(blockState) ? null : new ScrapWindTurbineBlockEntity(blockPos, blockState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return this.isUpperBlock(blockState) ? null : ScrapWindTurbineBlock.m_152132_(blockEntityType, ScrapWindTurbineBlockEntity.TYPE, ScrapWindTurbineBlockEntity::tick);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos mainPos = this.getMainBlockPos(blockPos, blockState);
        BlockEntity blockEntity = level.m_7702_(mainPos);
        if (blockEntity instanceof ScrapWindTurbineBlockEntity) {
            ScrapWindTurbineBlockEntity windTurbineBlockEntity = (ScrapWindTurbineBlockEntity)blockEntity;
            MenuManager.openMenu(player, windTurbineBlockEntity);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!level.f_46443_) {
            this.placeMultiBlock(level, pos, (BlockState)state.m_61124_((Property)HALF, (Comparable)DoubleBlockHalf.LOWER), (Block)this);
        }
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!blockState.m_60713_(newState.m_60734_())) {
            BlockPos mainPos = this.getMainBlockPos(blockPos, blockState);
            BlockEntity blockEntity = level.m_7702_(mainPos);
            if (blockEntity instanceof ScrapWindTurbineBlockEntity) {
                ScrapWindTurbineBlockEntity windTurbineBlockEntity = (ScrapWindTurbineBlockEntity)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)mainPos, (Container)windTurbineBlockEntity.getContainer());
            }
            this.removeMultiBlock(level, blockPos, blockState);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (pos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(pos.m_7494_()).m_247087_()) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_(STATUS, (Comparable)((Object)ScrapWindTurbineStatus.IDLE))).m_61124_((Property)HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, STATUS, HALF});
    }
}

