/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.hololog;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.scraptechworkshop.client.renderer.hololog.HoloLogPlayerAudio;
import de.markusbordihn.scraptechworkshop.client.renderer.hololog.HoloLogPlayerEffects;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogData;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogDisplayEntity;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogDisplayRecipe;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogLine;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogPlaybackContext;
import java.util.UUID;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HoloLogPlaybackBase {
    protected static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    protected final HoloLogData holoLogData;
    protected final HoloLogPlaybackContext context;
    protected final UUID playerId;
    protected final Runnable onComplete;
    protected PlaybackState state = PlaybackState.STOPPED;
    protected int currentLineIndex = 0;
    protected boolean endEffectsPlayed = false;
    protected boolean voiceOverStarted = false;

    protected HoloLogPlaybackBase(HoloLogData holoLogData, HoloLogPlaybackContext context, UUID playerId, Runnable onComplete) {
        this.holoLogData = holoLogData;
        this.context = context;
        this.playerId = playerId;
        this.onComplete = onComplete;
    }

    public void start() {
        this.state = PlaybackState.PLAYING;
        this.currentLineIndex = 0;
        this.endEffectsPlayed = false;
        this.voiceOverStarted = false;
        log.info("Starting holo log playback: {} (lines: {}, default delay: {}s)", (Object)this.holoLogData.id(), (Object)this.holoLogData.lines().size(), (Object)Float.valueOf(this.holoLogData.lineDelay()));
        HoloLogPlayerEffects.playEffects(this.holoLogData.start(), this.context, this.context.getEffectPosition());
        this.onPlaybackStart();
    }

    public void stop() {
        this.state = PlaybackState.STOPPED;
        HoloLogPlayerAudio.stopVoiceOver(this.playerId);
        this.onPlaybackStop();
    }

    public abstract void tick();

    protected abstract void onPlaybackStart();

    protected abstract void onPlaybackStop();

    protected void startVoiceOver(float currentTime) {
        if (!this.voiceOverStarted && this.holoLogData.hasVoiceOver() && currentTime >= this.holoLogData.voiceOverDelay()) {
            HoloLogPlayerAudio.playVoiceOver(this.playerId, this.holoLogData.voiceOver(), this.context);
            this.voiceOverStarted = true;
            log.debug("Started voice-over at {}s (delay: {}s)", (Object)Float.valueOf(currentTime), (Object)Float.valueOf(this.holoLogData.voiceOverDelay()));
        }
    }

    protected void completePlayback() {
        if (!this.endEffectsPlayed) {
            HoloLogPlayerEffects.playEffects(this.holoLogData.end(), this.context, this.context.getEffectPosition());
            this.endEffectsPlayed = true;
            if (this.onComplete != null) {
                log.info("Holo log playback completed: {}", (Object)this.holoLogData.id());
                this.onComplete.run();
            }
        }
        this.state = PlaybackState.STOPPED;
    }

    public boolean isPlaying() {
        return this.state == PlaybackState.PLAYING;
    }

    public boolean isStopped() {
        return this.state == PlaybackState.STOPPED;
    }

    public HoloLogDisplayEntity getCurrentDisplayEntity() {
        HoloLogLine line;
        int displayLineIndex = this.getDisplayLineIndex();
        if (displayLineIndex >= 0 && displayLineIndex < this.holoLogData.lines().size() && (line = this.holoLogData.lines().get(displayLineIndex)).displayEntity() != null) {
            return line.displayEntity();
        }
        return this.holoLogData.displayEntity();
    }

    public HoloLogDisplayRecipe getCurrentDisplayRecipe() {
        HoloLogLine line;
        int displayLineIndex = this.getDisplayLineIndex();
        if (displayLineIndex >= 0 && displayLineIndex < this.holoLogData.lines().size() && (line = this.holoLogData.lines().get(displayLineIndex)).displayRecipe() != null) {
            return line.displayRecipe();
        }
        return this.holoLogData.displayRecipe();
    }

    protected int getDisplayLineIndex() {
        return this.currentLineIndex;
    }

    protected abstract void renderEntity(PoseStack var1, ResourceLocation var2, float var3, int var4);

    protected abstract void renderEntity(PoseStack var1, MultiBufferSource var2, ResourceLocation var3, float var4, int var5);

    protected abstract void renderHoloEntity(PoseStack var1, HoloLogDisplayEntity var2, float var3, int var4);

    protected abstract void renderHoloEntity(PoseStack var1, MultiBufferSource var2, HoloLogDisplayEntity var3, float var4, int var5);

    protected abstract void renderBlock(PoseStack var1, ResourceLocation var2, int var3);

    protected abstract void renderBlock(PoseStack var1, MultiBufferSource var2, ResourceLocation var3, int var4);

    protected abstract void renderItem(PoseStack var1, ResourceLocation var2, int var3);

    protected abstract void renderItem(PoseStack var1, MultiBufferSource var2, ResourceLocation var3, int var4);

    public void renderDisplayEntity(PoseStack poseStack, float partialTick, int lightLevel) {
        HoloLogDisplayEntity displayEntity = this.getCurrentDisplayEntity();
        if (displayEntity == null) {
            return;
        }
        try {
            switch (displayEntity.type()) {
                case ENTITY: {
                    if (displayEntity.id() == null) break;
                    this.renderEntity(poseStack, displayEntity.id(), partialTick, lightLevel);
                    break;
                }
                case HOLO_ENTITY: {
                    if (displayEntity.id() == null) break;
                    this.renderHoloEntity(poseStack, displayEntity, partialTick, lightLevel);
                    break;
                }
                case BLOCK: {
                    if (displayEntity.id() == null) break;
                    this.renderBlock(poseStack, displayEntity.id(), lightLevel);
                    break;
                }
                case ITEM: {
                    if (displayEntity.id() == null) break;
                    this.renderItem(poseStack, displayEntity.id(), lightLevel);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to render display entity: {}", (Object)e.getMessage());
        }
    }

    public void renderDisplayEntity(PoseStack poseStack, MultiBufferSource buffer, float partialTick, int lightLevel) {
        HoloLogDisplayEntity displayEntity = this.getCurrentDisplayEntity();
        if (displayEntity == null) {
            return;
        }
        this.renderDisplayEntity(poseStack, buffer, displayEntity, partialTick, lightLevel);
    }

    public void renderDisplayEntity(PoseStack poseStack, MultiBufferSource buffer, HoloLogDisplayEntity displayEntity, float partialTick, int lightLevel) {
        if (displayEntity == null) {
            return;
        }
        try {
            switch (displayEntity.type()) {
                case ENTITY: {
                    if (displayEntity.id() == null) break;
                    this.renderEntity(poseStack, buffer, displayEntity.id(), partialTick, lightLevel);
                    break;
                }
                case HOLO_ENTITY: {
                    if (displayEntity.id() == null) break;
                    this.renderHoloEntity(poseStack, buffer, displayEntity, partialTick, lightLevel);
                    break;
                }
                case BLOCK: {
                    if (displayEntity.id() == null) break;
                    this.renderBlock(poseStack, buffer, displayEntity.id(), lightLevel);
                    break;
                }
                case ITEM: {
                    if (displayEntity.id() == null) break;
                    this.renderItem(poseStack, buffer, displayEntity.id(), lightLevel);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to render display entity: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    protected static enum PlaybackState {
        STOPPED,
        PLAYING;

    }
}

