/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.scraptechworkshop.Constants;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class BaseContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected BaseContainerScreen(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    protected void renderDefaultBackground(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Constants.TEXTURE_DEMO_BACKGROUND);
        int standardWidth = 176;
        int standardHeight = 166;
        int splitX = Math.min(width / 2, standardWidth / 2);
        int splitY = Math.min(height / 2, standardHeight / 2);
        guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, x, y, 0, 0, Math.min(splitX, width), Math.min(splitY, height));
        if (width > splitX) {
            guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, x + splitX, y, standardWidth - (width - splitX), 0, width - splitX, Math.min(splitY, height));
        }
        if (height > splitY) {
            guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, x, y + splitY, 0, standardHeight - (height - splitY), Math.min(splitX, width), height - splitY);
        }
        if (width > splitX && height > splitY) {
            guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, x + splitX, y + splitY, standardWidth - (width - splitX), standardHeight - (height - splitY), width - splitX, height - splitY);
        }
    }

    protected void renderSlot(GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Constants.TEXTURE_INVENTORY);
        guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, x - 1, y - 1, 7, 7, 18, 18);
    }

    protected void renderSlots(GuiGraphics guiGraphics, int x, int y, int columns, int rows) {
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                this.renderSlot(guiGraphics, x + column * 18, y + row * 18);
            }
        }
    }

    protected void renderPlayerInventoryAt(GuiGraphics guiGraphics, int x, int y, int inventoryStartY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Constants.TEXTURE_INVENTORY);
        guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, x + 7, y + inventoryStartY - 1, 7, 83, 162, 54);
        guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, x + 7, y + inventoryStartY + 57, 7, 141, 162, 18);
    }

    protected void renderEnergyBar(GuiGraphics guiGraphics, int x, int y, int barWidth, int barHeight, int currentEnergy, int maxEnergy) {
        guiGraphics.m_280509_(x, y, x + barWidth, y + barHeight, -11184811);
        if (currentEnergy > 0 && maxEnergy > 0) {
            int energyBarHeight = (int)((float)currentEnergy / (float)maxEnergy * (float)barHeight);
            guiGraphics.m_280509_(x, y + (barHeight - energyBarHeight), x + barWidth, y + barHeight, -16711936);
        }
    }

    protected void renderEnergyBarWithFrame(GuiGraphics guiGraphics, int x, int y, int barWidth, int barHeight, int currentEnergy, int maxEnergy) {
        guiGraphics.m_280509_(x - 1, y - 1, x + barWidth + 1, y + barHeight + 1, -7631989);
        this.renderEnergyBar(guiGraphics, x, y, barWidth, barHeight, currentEnergy, maxEnergy);
    }

    protected void renderProgressBar(GuiGraphics guiGraphics, int x, int y, int width, int height, int current, int max, int color) {
        guiGraphics.m_280509_(x, y, x + width, y + height, -11184811);
        if (max > 0 && current > 0) {
            int filledWidth = current * width / max;
            guiGraphics.m_280509_(x, y, x + filledWidth, y + height, 0xFF000000 | color);
        }
        guiGraphics.m_280509_(x, y, x + width, y + 1, -16777216);
        guiGraphics.m_280509_(x, y + height - 1, x + width, y + height, -16777216);
        guiGraphics.m_280509_(x, y, x + 1, y + height, -16777216);
        guiGraphics.m_280509_(x + width - 1, y, x + width, y + height, -16777216);
    }

    protected void renderEnergyTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, int currentEnergy, int maxEnergy) {
        this.renderEnergyTooltip(guiGraphics, mouseX, mouseY, currentEnergy, maxEnergy, 3.7f);
    }

    protected void renderEnergyTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, int currentEnergy, int maxEnergy, float voltage) {
        int percentage = maxEnergy > 0 ? currentEnergy * 100 / maxEnergy : 0;
        MutableComponent tooltip = Component.m_237113_((String)String.format("%d / %d mAh (%.1fV) - %d%%", currentEnergy, maxEnergy, Float.valueOf(voltage), percentage));
        guiGraphics.m_280557_(this.f_96547_, (Component)tooltip, mouseX, mouseY);
    }

    protected boolean isMouseOverEnergyBar(int mouseX, int mouseY, int barX, int barY, int barWidth, int barHeight) {
        return mouseX >= barX && mouseX <= barX + barWidth && mouseY >= barY && mouseY <= barY + barHeight;
    }

    protected void renderEnergyTab(GuiGraphics guiGraphics, int x, int y, int tabWidth, int tabHeight) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Constants.TEXTURE_DEMO_BACKGROUND);
        int cornerHeight = Math.min(tabHeight / 2, 10);
        guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, x, y, 0, 0, tabWidth, cornerHeight);
        int middleHeight = tabHeight - cornerHeight * 2;
        if (middleHeight > 0) {
            guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, x, y + cornerHeight, 0, 5, tabWidth, middleHeight);
        }
        guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, x, y + tabHeight - cornerHeight, 0, 166 - cornerHeight, tabWidth, cornerHeight);
    }

    protected void renderEnergyPowerUI(GuiGraphics guiGraphics, int x, int y, int batterySlotX, int batterySlotY, int energyBarX, int energyBarY, int energyBarWidth, int energyBarHeight, int currentEnergy, int energyCapacity) {
        int tabWidth = 26;
        int tabHeight = 93;
        int tabX = x - tabWidth;
        int tabY = y;
        this.renderEnergyTab(guiGraphics, tabX, tabY, tabWidth, tabHeight);
        this.renderSlot(guiGraphics, x + batterySlotX, y + batterySlotY);
        this.renderEnergyBarWithFrame(guiGraphics, x + energyBarX, y + energyBarY, energyBarWidth, energyBarHeight, currentEnergy, energyCapacity);
    }

    protected void renderEnergyPowerTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int leftPos, int topPos, int batterySlotX, int batterySlotY, int energyBarX, int energyBarY, int energyBarWidth, int energyBarHeight, int currentEnergy, int energyCapacity, String batteryTooltipKey, int batterySlotIndex) {
        int relativeX = mouseX - leftPos;
        int relativeY = mouseY - topPos;
        if (relativeX >= batterySlotX - 1 && relativeX <= batterySlotX + 17 && relativeY >= batterySlotY - 1 && relativeY <= batterySlotY + 17 && this.f_97732_.m_38853_(batterySlotIndex).m_7993_().m_41619_()) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)batteryTooltipKey), mouseX, mouseY);
        }
        if (this.isMouseOverEnergyBar(relativeX, relativeY, energyBarX, energyBarY, energyBarWidth, energyBarHeight)) {
            this.renderEnergyTooltip(guiGraphics, mouseX, mouseY, currentEnergy, energyCapacity);
        }
    }
}

