/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.screen.rechargestation;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.scraptechworkshop.client.screen.BaseContainerScreen;
import de.markusbordihn.scraptechworkshop.data.rechargestation.RechargeStationStatus;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.menu.RechargeStationMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RechargeStationScreen
extends BaseContainerScreen<RechargeStationMenu> {
    private static final String TRANSLATION_KEY_PREFIX = "gui.scrap_tech_workshop.recharge_station.";
    private static final String TRANSLATION_NO_POWER = "gui.scrap_tech_workshop.recharge_station.no_power";
    private static final String TRANSLATION_CHARGING = "gui.scrap_tech_workshop.recharge_station.charging";
    private static final String TRANSLATION_DONE = "gui.scrap_tech_workshop.recharge_station.done";
    private static final String TRANSLATION_IDLE = "gui.scrap_tech_workshop.recharge_station.idle";
    private static final String TRANSLATION_INPUT_SLOT = "gui.scrap_tech_workshop.recharge_station.input_slot";
    private static final String TRANSLATION_BATTERY_SLOT = "gui.scrap_tech_workshop.recharge_station.battery_slot";
    private static final int SCREEN_WIDTH = 176;
    private static final int SCREEN_HEIGHT = 181;
    private static final int PROGRESS_BAR_AREA_X1 = 68;
    private static final int PROGRESS_BAR_AREA_X2 = 108;
    private static final int PROGRESS_BAR_AREA_Y1 = 56;
    private static final int PROGRESS_BAR_AREA_Y2 = 61;
    private static final int INPUT_SLOT_X = 80;
    private static final int INPUT_SLOT_Y = 35;

    public RechargeStationScreen(RechargeStationMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 181;
        this.f_97731_ = 88;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.renderDefaultBackground(guiGraphics, x, y, this.f_97726_, this.f_97727_);
        this.renderEnergyPowerUI(guiGraphics, x, y, -20, 6, -20, 26, 16, 60, ((RechargeStationMenu)this.f_97732_).getCurrentEnergy(), ((RechargeStationMenu)this.f_97732_).getEnergyCapacity());
        this.renderSlot(guiGraphics, x + 80, y + 35);
        this.renderPlayerInventoryAt(guiGraphics, x, y, 99);
        int progressBarX = x + 68;
        int progressBarY = y + 56;
        int progressBarWidth = 40;
        int progressBarHeight = 5;
        guiGraphics.m_280509_(progressBarX, progressBarY, progressBarX + progressBarWidth, progressBarY + progressBarHeight, -12566464);
        if (((RechargeStationMenu)this.f_97732_).isCharging()) {
            int scaledProgress = ((RechargeStationMenu)this.f_97732_).getScaledProgress();
            guiGraphics.m_280509_(progressBarX, progressBarY, progressBarX + scaledProgress, progressBarY + progressBarHeight, -16711936);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Item item;
        super.m_280003_(guiGraphics, mouseX, mouseY);
        ItemStack inputStack = ((RechargeStationMenu)this.f_97732_).m_38853_(0).m_7993_();
        if (!inputStack.m_41619_() && (item = inputStack.m_41720_()) instanceof EnergyCellItem) {
            EnergyCellItem energyCell = (EnergyCellItem)item;
            int currentEnergy = energyCell.getEnergy(inputStack);
            int maxEnergy = 5000;
            String batteryText = currentEnergy + " / " + maxEnergy + " mAh";
            int textWidth = this.f_96547_.m_92895_(batteryText);
            int batteryTextX = 68 + (40 - textWidth) / 2;
            int batteryTextY = 64;
            guiGraphics.m_280056_(this.f_96547_, batteryText, batteryTextX, batteryTextY, 0x404040, false);
        }
    }

    protected void m_280072_(GuiGraphics guiGraphics, int x, int y) {
        super.m_280072_(guiGraphics, x, y);
        this.renderEnergyPowerTooltips(guiGraphics, x, y, this.f_97735_, this.f_97736_, -20, 6, -20, 26, 16, 60, ((RechargeStationMenu)this.f_97732_).getCurrentEnergy(), ((RechargeStationMenu)this.f_97732_).getEnergyCapacity(), TRANSLATION_BATTERY_SLOT, 1);
        int relativeX = x - this.f_97735_;
        int relativeY = y - this.f_97736_;
        if (relativeX >= 68 && relativeX <= 108 && relativeY >= 56 && relativeY <= 61) {
            RechargeStationStatus status = ((RechargeStationMenu)this.f_97732_).getRechargeStationStatus();
            MutableComponent statusText = switch (status) {
                default -> throw new IncompatibleClassChangeError();
                case RechargeStationStatus.NO_POWER -> Component.m_237115_((String)TRANSLATION_NO_POWER);
                case RechargeStationStatus.CHARGING -> Component.m_237115_((String)TRANSLATION_CHARGING);
                case RechargeStationStatus.DONE -> Component.m_237115_((String)TRANSLATION_DONE);
                case RechargeStationStatus.IDLE -> Component.m_237115_((String)TRANSLATION_IDLE);
            };
            guiGraphics.m_280557_(this.f_96547_, (Component)statusText, x, y);
        }
        if (!((RechargeStationMenu)this.f_97732_).isCharging() && relativeX >= 79 && relativeX <= 97 && relativeY >= 34 && relativeY <= 52 && ((RechargeStationMenu)this.f_97732_).m_38853_(0).m_7993_().m_41619_()) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)TRANSLATION_INPUT_SLOT), x, y);
        }
    }
}

