/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.screen.windturbine;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.scraptechworkshop.client.screen.BaseContainerScreen;
import de.markusbordihn.scraptechworkshop.data.windturbine.ScrapWindTurbineStatus;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.menu.ScrapWindTurbineMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;

public class ScrapWindTurbineScreen
extends BaseContainerScreen<ScrapWindTurbineMenu> {
    private static final String TRANSLATION_KEY_PREFIX = "gui.scrap_tech_workshop.scrap_wind_turbine.";
    private static final String TRANSLATION_WIND_SPEED = "gui.scrap_tech_workshop.scrap_wind_turbine.wind_speed";
    private static final String TRANSLATION_POWER_GEN = "gui.scrap_tech_workshop.scrap_wind_turbine.power_generation";
    private static final String TRANSLATION_BATTERY_SLOT = "gui.scrap_tech_workshop.scrap_wind_turbine.battery_slot";
    private static final String TRANSLATION_CHARGING_SLOT = "gui.scrap_tech_workshop.scrap_wind_turbine.charging_slot";
    private static final String TRANSLATION_STATUS_IDLE = "gui.scrap_tech_workshop.scrap_wind_turbine.status.idle";
    private static final String TRANSLATION_STATUS_NO_WIND = "gui.scrap_tech_workshop.scrap_wind_turbine.status.no_wind";
    private static final String TRANSLATION_STATUS_LOW_WIND = "gui.scrap_tech_workshop.scrap_wind_turbine.status.low_wind";
    private static final String TRANSLATION_STATUS_GENERATING = "gui.scrap_tech_workshop.scrap_wind_turbine.status.generating";
    private static final String TRANSLATION_STATUS_ERROR = "gui.scrap_tech_workshop.scrap_wind_turbine.status.error";
    private static final String TRANSLATION_STATUS_ERROR_HINT = "gui.scrap_tech_workshop.scrap_wind_turbine.status.error.hint";
    private static final String TRANSLATION_STATUS_LOW_WIND_HINT = "gui.scrap_tech_workshop.scrap_wind_turbine.status.low_wind.hint";
    private static final int SCREEN_WIDTH = 176;
    private static final int SCREEN_HEIGHT = 201;
    private static final int UI_LEFT_MARGIN = 8;
    private static final int WIND_SPEED_BAR_Y = 50;
    private static final int POWER_GEN_BAR_Y = 70;
    private static final int WIND_SPEED_TEXT_Y = 38;
    private static final int POWER_GEN_TEXT_Y = 58;
    private static final int STATUS_TEXT_Y = 78;
    private static final int HINT_TEXT_Y = 88;
    private static final int PROGRESS_BAR_WIDTH = 70;
    private static final int CHARGING_SLOT_ENERGY_BAR_OFFSET_Y = 20;
    private static final int ENERGY_BAR_X_OFFSET = -20;
    private static final int ENERGY_BAR_Y = 6;
    private static final int ENERGY_BAR_TOOLTIP_X_OFFSET = -20;
    private static final int ENERGY_BAR_TOOLTIP_Y = 26;
    private static final int ENERGY_BAR_WIDTH = 16;
    private static final int ENERGY_BAR_HEIGHT = 60;
    private float displayWindSpeed = 0.0f;
    private float displayPowerGen = 0.0f;
    private long lastFluctuationTime = 0L;

    public ScrapWindTurbineScreen(ScrapWindTurbineMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 201;
        this.f_97731_ = 107;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.renderDefaultBackground(guiGraphics, x, y, this.f_97726_, this.f_97727_);
        this.renderEnergyPowerUI(guiGraphics, x, y, -20, 6, -20, 26, 16, 60, ((ScrapWindTurbineMenu)this.f_97732_).getEnergy(), ((ScrapWindTurbineMenu)this.f_97732_).getEnergyCapacity());
        this.renderSlot(guiGraphics, x + 135, y + 43);
        int chargingSlotEnergy = this.getChargingBatteryEnergy();
        this.renderProgressBar(guiGraphics, x + 135 - 1, y + 43 + 20, 18, 2, chargingSlotEnergy, 5000, 16766720);
        this.updateFluctuatingValues();
        this.renderProgressBar(guiGraphics, x + 8, y + 50, 70, 4, (int)(this.displayWindSpeed * 10.0f), 250, 4890584);
        this.renderProgressBar(guiGraphics, x + 8, y + 70, 70, 4, (int)this.displayPowerGen, 50, 4905802);
        this.renderPlayerInventoryAt(guiGraphics, x, y, 119);
        this.renderInfoText(guiGraphics, x, y);
    }

    private void updateFluctuatingValues() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastFluctuationTime > 1000L) {
            int baseWindSpeed = ((ScrapWindTurbineMenu)this.f_97732_).getWindSpeed();
            int basePowerGen = ((ScrapWindTurbineMenu)this.f_97732_).getPowerGeneration();
            if (baseWindSpeed > 0) {
                float fluctuation = (float)((Math.random() * 4.0 - 2.0) / 100.0);
                this.displayWindSpeed = (float)baseWindSpeed / 10.0f * (1.0f + fluctuation);
                this.displayPowerGen = (float)basePowerGen * (1.0f + fluctuation);
            } else {
                this.displayWindSpeed = 0.0f;
                this.displayPowerGen = 0.0f;
            }
            this.lastFluctuationTime = currentTime;
        }
        if (this.displayWindSpeed == 0.0f && ((ScrapWindTurbineMenu)this.f_97732_).getWindSpeed() > 0) {
            this.displayWindSpeed = (float)((ScrapWindTurbineMenu)this.f_97732_).getWindSpeed() / 10.0f;
            this.displayPowerGen = ((ScrapWindTurbineMenu)this.f_97732_).getPowerGeneration();
        }
    }

    private void renderInfoText(GuiGraphics guiGraphics, int x, int y) {
        MutableComponent windSpeedText = Component.m_237110_((String)TRANSLATION_WIND_SPEED, (Object[])new Object[]{String.format("%.1f", Float.valueOf(this.displayWindSpeed))});
        MutableComponent powerGenText = Component.m_237110_((String)TRANSLATION_POWER_GEN, (Object[])new Object[]{String.format("%.1f", Float.valueOf(this.displayPowerGen))});
        guiGraphics.m_280614_(this.f_96547_, (Component)windSpeedText, x + 8, y + 38, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)powerGenText, x + 8, y + 58, 0x404040, false);
        this.renderStatusInfo(guiGraphics, x, y);
    }

    private void renderStatusInfo(GuiGraphics guiGraphics, int x, int y) {
        MutableComponent statusText;
        ScrapWindTurbineStatus status = ((ScrapWindTurbineMenu)this.f_97732_).getWindTurbineStatus();
        int color = 0x404040;
        switch (status) {
            case IDLE: {
                statusText = Component.m_237115_((String)TRANSLATION_STATUS_IDLE);
                color = 0xAAAAAA;
                break;
            }
            case NO_WIND: {
                statusText = Component.m_237115_((String)TRANSLATION_STATUS_NO_WIND);
                color = 0xFFAA00;
                break;
            }
            case LOW_WIND: {
                statusText = Component.m_237115_((String)TRANSLATION_STATUS_LOW_WIND);
                color = 0xFFCC00;
                break;
            }
            case GENERATING: {
                statusText = Component.m_237115_((String)TRANSLATION_STATUS_GENERATING);
                color = 65280;
                break;
            }
            case ERROR: {
                statusText = Component.m_237115_((String)TRANSLATION_STATUS_ERROR);
                color = 0xFF0000;
                break;
            }
            default: {
                statusText = Component.m_237113_((String)"Unknown");
            }
        }
        guiGraphics.m_280614_(this.f_96547_, (Component)statusText, x + 8, y + 78, color, false);
        if (status == ScrapWindTurbineStatus.ERROR) {
            MutableComponent hintText = Component.m_237115_((String)TRANSLATION_STATUS_ERROR_HINT);
            guiGraphics.m_280614_(this.f_96547_, (Component)hintText, x + 8, y + 88, 0xFF5555, false);
        } else if (status == ScrapWindTurbineStatus.LOW_WIND) {
            MutableComponent hintText = Component.m_237115_((String)TRANSLATION_STATUS_LOW_WIND_HINT);
            guiGraphics.m_280614_(this.f_96547_, (Component)hintText, x + 8, y + 88, 0xFFAA55, false);
        }
    }

    private int getChargingBatteryEnergy() {
        Item item;
        Slot slot = ((ScrapWindTurbineMenu)this.f_97732_).m_38853_(((ScrapWindTurbineMenu)this.f_97732_).getChargingBatterySlotIndex());
        if (slot != null && !slot.m_7993_().m_41619_() && (item = slot.m_7993_().m_41720_()) instanceof EnergyCellItem) {
            EnergyCellItem energyCell = (EnergyCellItem)item;
            return energyCell.getEnergy(slot.m_7993_());
        }
        return 0;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.renderEnergyPowerTooltips(guiGraphics, mouseX, mouseY, x, y, -20, 6, -20, 26, 16, 60, ((ScrapWindTurbineMenu)this.f_97732_).getEnergy(), ((ScrapWindTurbineMenu)this.f_97732_).getEnergyCapacity(), TRANSLATION_BATTERY_SLOT, ((ScrapWindTurbineMenu)this.f_97732_).getEnergyTabBatterySlotIndex());
        int relativeX = mouseX - x;
        int relativeY = mouseY - y;
        if (relativeX >= 135 && relativeX <= 151 && relativeY >= 43 && relativeY <= 59) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)TRANSLATION_CHARGING_SLOT), mouseX, mouseY);
        }
        super.m_280072_(guiGraphics, mouseX, mouseY);
    }
}

