/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.config;

import de.markusbordihn.scraptechworkshop.config.Config;
import java.io.File;
import java.util.Properties;

public class MultitoolConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "multitool.cfg";
    public static final String CONFIG_FILE_HEADER = " Multitool Configuration\n\n This configuration file allows you to define the general settings for the Scrap Multitool.\n energyMax: Maximum energy capacity (default: 10000)\n energyPerUse: Energy consumed per general use (default: 1)\n energyPerBlock: Energy consumed per block mined (default: 2)\n energyPerAttack: Energy consumed per attack (default: 5)\n poweredSpeedPickaxe: Mining speed when in pickaxe mode (default: 6.0)\n poweredSpeedAxe: Mining speed when in axe mode (default: 6.0)\n poweredSpeedShovel: Mining speed when in shovel mode (default: 6.0)\n poweredSpeedHoe: Mining speed when in hoe mode (default: 4.0)\n poweredSpeedSword: Attack speed when in sword mode (default: 6.0)\n poweredSpeedDefault: Default powered speed (default: 6.0)\n raycastDistance: Distance for automatic tool mode detection in blocks (default: 5)\n\n";
    public static final String MULTITOOL_ID = "scrap_multitool";
    public static final String MODE_NORMAL = "normal";
    public static final String MODE_PICKAXE = "pickaxe";
    public static final String MODE_AXE = "axe";
    public static final String MODE_SHOVEL = "shovel";
    public static final String MODE_HOE = "hoe";
    public static final String MODE_SWORD = "sword";
    public static final int DEFAULT_ENERGY_MAX = 10000;
    public static final int DEFAULT_ENERGY_PER_USE = 1;
    public static final int DEFAULT_ENERGY_PER_BLOCK = 2;
    public static final int DEFAULT_ENERGY_PER_ATTACK = 5;
    public static final float DEFAULT_POWERED_SPEED_PICKAXE = 6.0f;
    public static final float DEFAULT_POWERED_SPEED_AXE = 6.0f;
    public static final float DEFAULT_POWERED_SPEED_SHOVEL = 6.0f;
    public static final float DEFAULT_POWERED_SPEED_HOE = 4.0f;
    public static final float DEFAULT_POWERED_SPEED_SWORD = 6.0f;
    public static final float DEFAULT_POWERED_SPEED_DEFAULT = 6.0f;
    public static final int DEFAULT_RAYCAST_DISTANCE = 5;
    public static int energyMax = 10000;
    public static int energyPerUse = 1;
    public static int energyPerBlock = 2;
    public static int energyPerAttack = 5;
    public static float poweredSpeedPickaxe = 6.0f;
    public static float poweredSpeedAxe = 6.0f;
    public static float poweredSpeedShovel = 6.0f;
    public static float poweredSpeedHoe = 4.0f;
    public static float poweredSpeedSword = 6.0f;
    public static float poweredSpeedDefault = 6.0f;
    public static int raycastDistance = 5;

    public static void registerConfig() {
        MultitoolConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        MultitoolConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = MultitoolConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = MultitoolConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        energyMax = Math.max(1000, MultitoolConfig.parseConfigValue(properties, "energyMax", energyMax));
        energyPerUse = Math.max(0, MultitoolConfig.parseConfigValue(properties, "energyPerUse", energyPerUse));
        energyPerBlock = Math.max(1, MultitoolConfig.parseConfigValue(properties, "energyPerBlock", energyPerBlock));
        energyPerAttack = Math.max(1, MultitoolConfig.parseConfigValue(properties, "energyPerAttack", energyPerAttack));
        poweredSpeedPickaxe = Math.max(1.0f, MultitoolConfig.parseConfigValue(properties, "poweredSpeedPickaxe", poweredSpeedPickaxe));
        poweredSpeedAxe = Math.max(1.0f, MultitoolConfig.parseConfigValue(properties, "poweredSpeedAxe", poweredSpeedAxe));
        poweredSpeedShovel = Math.max(1.0f, MultitoolConfig.parseConfigValue(properties, "poweredSpeedShovel", poweredSpeedShovel));
        poweredSpeedHoe = Math.max(1.0f, MultitoolConfig.parseConfigValue(properties, "poweredSpeedHoe", poweredSpeedHoe));
        poweredSpeedSword = Math.max(1.0f, MultitoolConfig.parseConfigValue(properties, "poweredSpeedSword", poweredSpeedSword));
        poweredSpeedDefault = Math.max(1.0f, MultitoolConfig.parseConfigValue(properties, "poweredSpeedDefault", poweredSpeedDefault));
        raycastDistance = Math.max(1, Math.min(10, MultitoolConfig.parseConfigValue(properties, "raycastDistance", raycastDistance)));
        MultitoolConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }

    public static float getPoweredSpeed(String mode) {
        return switch (mode) {
            case MODE_PICKAXE -> poweredSpeedPickaxe;
            case MODE_AXE -> poweredSpeedAxe;
            case MODE_SHOVEL -> poweredSpeedShovel;
            case MODE_HOE -> poweredSpeedHoe;
            case MODE_SWORD -> poweredSpeedSword;
            default -> poweredSpeedDefault;
        };
    }
}

