/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.config;

import de.markusbordihn.scraptechworkshop.config.Config;
import java.io.File;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapFishingConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "scrap_fishing.cfg";
    public static final String CONFIG_FILE_HEADER = " Scrap Fishing Configuration\n\n This configuration file allows you to define the settings for the Scrap Fishing system.\n\n Scrap Chances (percentage 0-100):\n - vanilla_rod_scrap_chance: Chance to catch scrap with vanilla fishing rod (default: 15%)\n - scrap_rod_scrap_chance: Chance to catch scrap with scrap fishing rod (default: 35%)\n - magnet_rod_scrap_chance: Chance to catch scrap with magnet fishing rod (default: 50%)\n\n Vanilla Rod Loot Weights (higher = more common):\n - vanilla_plastic_weight: Weight for plastic scrap (default: 40)\n - vanilla_rubber_weight: Weight for rubber scrap (default: 30)\n - vanilla_fastener_weight: Weight for fastener scrap (default: 20)\n - vanilla_metal_weight: Weight for metal scrap (default: 15)\n - vanilla_iron_weight: Weight for iron scrap (default: 10)\n - vanilla_circuit_weight: Weight for circuit scrap (default: 5)\n - vanilla_glass_weight: Weight for glass scrap (default: 10)\n\n Scrap Rod Loot Weights (higher = more common):\n - scrap_rod_metal_weight: Weight for metal scrap (default: 35)\n - scrap_rod_iron_weight: Weight for iron scrap (default: 30)\n - scrap_rod_copper_weight: Weight for copper scrap (default: 25)\n - scrap_rod_circuit_weight: Weight for circuit scrap (default: 20)\n - scrap_rod_capacitor_weight: Weight for capacitor scrap (default: 15)\n - scrap_rod_plastic_weight: Weight for plastic scrap (default: 20)\n - scrap_rod_rubber_weight: Weight for rubber scrap (default: 15)\n - scrap_rod_glass_weight: Weight for glass scrap (default: 10)\n\n Magnet Rod Loot Weights (higher = more common):\n - magnet_rod_circuit_weight: Weight for circuit scrap (default: 35)\n - magnet_rod_capacitor_weight: Weight for capacitor scrap (default: 30)\n - magnet_rod_coil_weight: Weight for coil scrap (default: 25)\n - magnet_rod_metal_weight: Weight for metal scrap (default: 30)\n - magnet_rod_iron_weight: Weight for iron scrap (default: 25)\n - magnet_rod_copper_weight: Weight for copper scrap (default: 20)\n - magnet_rod_alloy_weight: Weight for alloy scrap (default: 20)\n - magnet_rod_plastic_weight: Weight for plastic scrap (default: 5)\n\n Sound Settings:\n - enable_sounds: Enable sound effects for scrap fishing (default: true)\n - sound_volume: Volume for scrap fishing sounds 0.0-1.0 (default: 0.5)\n\n";
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    public static int vanillaRodScrapChance = 15;
    public static int scrapRodScrapChance = 35;
    public static int magnetRodScrapChance = 50;
    public static int vanillaPlasticWeight = 40;
    public static int vanillaRubberWeight = 30;
    public static int vanillaFastenerWeight = 20;
    public static int vanillaMetalWeight = 15;
    public static int vanillaIronWeight = 10;
    public static int vanillaCircuitWeight = 5;
    public static int vanillaGlassWeight = 10;
    public static int scrapRodMetalWeight = 35;
    public static int scrapRodIronWeight = 30;
    public static int scrapRodCopperWeight = 25;
    public static int scrapRodCircuitWeight = 20;
    public static int scrapRodCapacitorWeight = 15;
    public static int scrapRodPlasticWeight = 20;
    public static int scrapRodRubberWeight = 15;
    public static int scrapRodGlassWeight = 10;
    public static int magnetRodCircuitWeight = 35;
    public static int magnetRodCapacitorWeight = 30;
    public static int magnetRodCoilWeight = 25;
    public static int magnetRodMetalWeight = 30;
    public static int magnetRodIronWeight = 25;
    public static int magnetRodCopperWeight = 20;
    public static int magnetRodAlloyWeight = 20;
    public static int magnetRodPlasticWeight = 5;
    public static boolean enableSounds = true;
    public static float soundVolume = 0.5f;

    private ScrapFishingConfig() {
    }

    public static void registerConfig() {
        ScrapFishingConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        ScrapFishingConfig.loadConfig();
    }

    public static void loadConfig() {
        ScrapFishingConfig.parseConfigFile();
    }

    public static void load() {
        log.info("{} Loading Scrap Fishing configuration ...", (Object)"Scrap Tech Workshop");
        ScrapFishingConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = ScrapFishingConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = ScrapFishingConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        vanillaRodScrapChance = Math.max(0, Math.min(100, ScrapFishingConfig.parseConfigValue(properties, "vanilla_rod_scrap_chance", vanillaRodScrapChance)));
        scrapRodScrapChance = Math.max(0, Math.min(100, ScrapFishingConfig.parseConfigValue(properties, "scrap_rod_scrap_chance", scrapRodScrapChance)));
        magnetRodScrapChance = Math.max(0, Math.min(100, ScrapFishingConfig.parseConfigValue(properties, "magnet_rod_scrap_chance", magnetRodScrapChance)));
        vanillaPlasticWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "vanilla_plastic_weight", vanillaPlasticWeight));
        vanillaRubberWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "vanilla_rubber_weight", vanillaRubberWeight));
        vanillaFastenerWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "vanilla_fastener_weight", vanillaFastenerWeight));
        vanillaMetalWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "vanilla_metal_weight", vanillaMetalWeight));
        vanillaIronWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "vanilla_iron_weight", vanillaIronWeight));
        vanillaCircuitWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "vanilla_circuit_weight", vanillaCircuitWeight));
        vanillaGlassWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "vanilla_glass_weight", vanillaGlassWeight));
        scrapRodMetalWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "scrap_rod_metal_weight", scrapRodMetalWeight));
        scrapRodIronWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "scrap_rod_iron_weight", scrapRodIronWeight));
        scrapRodCopperWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "scrap_rod_copper_weight", scrapRodCopperWeight));
        scrapRodCircuitWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "scrap_rod_circuit_weight", scrapRodCircuitWeight));
        scrapRodCapacitorWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "scrap_rod_capacitor_weight", scrapRodCapacitorWeight));
        scrapRodPlasticWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "scrap_rod_plastic_weight", scrapRodPlasticWeight));
        scrapRodRubberWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "scrap_rod_rubber_weight", scrapRodRubberWeight));
        scrapRodGlassWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "scrap_rod_glass_weight", scrapRodGlassWeight));
        magnetRodCircuitWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "magnet_rod_circuit_weight", magnetRodCircuitWeight));
        magnetRodCapacitorWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "magnet_rod_capacitor_weight", magnetRodCapacitorWeight));
        magnetRodCoilWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "magnet_rod_coil_weight", magnetRodCoilWeight));
        magnetRodMetalWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "magnet_rod_metal_weight", magnetRodMetalWeight));
        magnetRodIronWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "magnet_rod_iron_weight", magnetRodIronWeight));
        magnetRodCopperWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "magnet_rod_copper_weight", magnetRodCopperWeight));
        magnetRodAlloyWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "magnet_rod_alloy_weight", magnetRodAlloyWeight));
        magnetRodPlasticWeight = Math.max(0, ScrapFishingConfig.parseConfigValue(properties, "magnet_rod_plastic_weight", magnetRodPlasticWeight));
        enableSounds = ScrapFishingConfig.parseConfigValue(properties, "enable_sounds", enableSounds);
        soundVolume = Math.max(0.0f, Math.min(1.0f, ScrapFishingConfig.parseConfigValue(properties, "sound_volume", soundVolume)));
        ScrapFishingConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }
}

