/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface EnergyBatteryHandler {
    public int getEnergyCapacity();

    public int getCurrentEnergy();

    public void setCurrentEnergy(int var1);

    public ItemStack getBattery();

    public void setBattery(ItemStack var1);

    public void markDirty();

    default public boolean chargeFromBattery(int amount) {
        Item item;
        ItemStack battery = this.getBattery();
        if (battery.m_41619_() || !((item = battery.m_41720_()) instanceof EnergyCellItem)) {
            return false;
        }
        EnergyCellItem batteryItem = (EnergyCellItem)item;
        int batteryEnergy = batteryItem.getEnergy(battery);
        if (batteryEnergy <= 1) {
            this.setBattery(batteryItem.createEmptyBattery());
            this.markDirty();
            return false;
        }
        int currentEnergy = this.getCurrentEnergy();
        int capacity = this.getEnergyCapacity();
        int neededEnergy = Math.min(amount, capacity - currentEnergy);
        if (neededEnergy <= 0) {
            return false;
        }
        int energyToTransfer = Math.min(neededEnergy, batteryEnergy);
        batteryItem.consumeEnergy(battery, energyToTransfer);
        this.setCurrentEnergy(currentEnergy + energyToTransfer);
        if (batteryItem.getEnergy(battery) <= 1) {
            this.setBattery(batteryItem.createEmptyBattery());
        } else {
            this.setBattery(battery);
        }
        this.markDirty();
        return true;
    }
}

