/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import de.markusbordihn.scraptechworkshop.energy.EnergyBatteryHandler;
import de.markusbordihn.scraptechworkshop.energy.EnergyDebounceData;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;

public interface EnergyPowerConsumer
extends EnergyBatteryHandler {
    public static final String ENERGY_TAG = "Energy";
    public static final String BATTERY_TAG = "Battery";
    public static final String LAST_ENERGY_RECEIVE_TIME_TAG = "LastEnergyReceiveTime";
    public static final int DEFAULT_ENERGY_DEBOUNCE_THRESHOLD = 10;
    public static final int DEFAULT_ENERGY_DEBOUNCE_TICKS = 40;

    @Override
    public void markDirty();

    public EnergyPowerData getEnergyData();

    public void setEnergyData(EnergyPowerData var1);

    @Override
    default public int getCurrentEnergy() {
        return this.getEnergyData().currentEnergy();
    }

    @Override
    default public void setCurrentEnergy(int energy) {
        this.setEnergyData(this.getEnergyData().withCurrentEnergy(energy));
    }

    @Override
    default public ItemStack getBattery() {
        return this.getEnergyData().battery();
    }

    @Override
    default public void setBattery(ItemStack battery) {
        this.setEnergyData(this.getEnergyData().withBattery(battery));
    }

    default public int getEnergyTransferRate() {
        return 50;
    }

    default public ContainerData getEnergyPowerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> EnergyPowerConsumer.this.getCurrentEnergy();
                    case 1 -> EnergyPowerConsumer.this.getEnergyCapacity();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                if (index == 0) {
                    EnergyPowerConsumer.this.setCurrentEnergy(value);
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    default public boolean consumeEnergy(int amount) {
        if (this.getCurrentEnergy() >= amount) {
            this.setCurrentEnergy(this.getCurrentEnergy() - amount);
            return true;
        }
        return false;
    }

    default public boolean canAcceptExternalEnergy() {
        return this.getCurrentEnergy() < this.getEnergyCapacity();
    }

    default public int receiveEnergy(int amount, boolean simulate) {
        int capacity = this.getEnergyCapacity();
        int currentEnergy = this.getCurrentEnergy();
        int energyReceived = Math.min(amount, capacity - currentEnergy);
        if (!simulate && energyReceived > 0) {
            this.setCurrentEnergy(currentEnergy + energyReceived);
            this.updateEnergyReceiveTime();
        }
        return energyReceived;
    }

    default public void updateEnergyReceiveTime() {
        EnergyPowerData data = this.getEnergyData();
        this.setEnergyData(data.withDebounceData(data.debounceData().withReceiveTime(System.currentTimeMillis() / 50L, this.getCurrentEnergy())));
    }

    default public boolean hasStableEnergy(int requiredEnergy) {
        return this.hasStableEnergy(requiredEnergy, 10);
    }

    default public boolean hasStableEnergy(int requiredEnergy, int threshold) {
        int currentEnergy = this.getCurrentEnergy();
        if (currentEnergy < requiredEnergy) {
            return false;
        }
        return currentEnergy >= requiredEnergy + threshold || this.isReceivingEnergy(40);
    }

    default public boolean isReceivingEnergy(int debounceTicks) {
        long currentTime = System.currentTimeMillis() / 50L;
        return this.getEnergyData().debounceData().isReceivingEnergy(currentTime, debounceTicks);
    }

    default public void loadEnergyPowerConsumer(CompoundTag compoundTag) {
        long lastReceiveTime;
        int energy = compoundTag.m_128451_(ENERGY_TAG);
        ItemStack battery = ItemStack.f_41583_;
        if (compoundTag.m_128441_(BATTERY_TAG)) {
            battery = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_(BATTERY_TAG));
        }
        EnergyDebounceData debounceData = (lastReceiveTime = compoundTag.m_128454_(LAST_ENERGY_RECEIVE_TIME_TAG)) > 0L ? new EnergyDebounceData(lastReceiveTime, energy) : EnergyDebounceData.empty();
        this.setEnergyData(new EnergyPowerData(energy, battery, debounceData));
    }

    default public void saveEnergyPowerConsumer(CompoundTag compoundTag) {
        EnergyPowerData data = this.getEnergyData();
        compoundTag.m_128405_(ENERGY_TAG, data.currentEnergy());
        if (!data.battery().m_41619_()) {
            CompoundTag batteryTag = new CompoundTag();
            data.battery().m_41739_(batteryTag);
            compoundTag.m_128365_(BATTERY_TAG, (Tag)batteryTag);
        }
        if (data.debounceData() != null) {
            compoundTag.m_128356_(LAST_ENERGY_RECEIVE_TIME_TAG, data.debounceData().lastEnergyReceiveTime());
        }
    }
}

