/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import de.markusbordihn.scraptechworkshop.energy.EnergyBatteryHandler;
import de.markusbordihn.scraptechworkshop.energy.EnergyDebounceData;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerConsumer;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerData;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.item.component.EmptyEnergyCellItem;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface EnergyPowerGenerator
extends EnergyBatteryHandler {
    public static final String ENERGY_TAG = "Energy";
    public static final String BATTERY_TAG = "Battery";
    public static final int TICKS_PER_SECOND = 20;

    @Override
    public int getEnergyCapacity();

    @Override
    public void markDirty();

    public EnergyPowerData getEnergyData();

    public void setEnergyData(EnergyPowerData var1);

    @Override
    default public int getCurrentEnergy() {
        return this.getEnergyData().currentEnergy();
    }

    @Override
    default public void setCurrentEnergy(int energy) {
        this.setEnergyData(this.getEnergyData().withCurrentEnergy(energy));
    }

    @Override
    default public ItemStack getBattery() {
        return this.getEnergyData().battery();
    }

    @Override
    default public void setBattery(ItemStack battery) {
        this.setEnergyData(this.getEnergyData().withBattery(battery));
    }

    default public int getEnergyTransferRate() {
        return 50;
    }

    default public ContainerData getEnergyPowerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> EnergyPowerGenerator.this.getCurrentEnergy();
                    case 1 -> EnergyPowerGenerator.this.getEnergyCapacity();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                if (index == 0) {
                    EnergyPowerGenerator.this.setCurrentEnergy(value);
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    default public int getAdaptiveTransferRate(int baseTransferRate) {
        if (this.getCurrentEnergy() > baseTransferRate) {
            return baseTransferRate;
        }
        return Math.max(1, baseTransferRate / 20);
    }

    default public boolean generateEnergy(int amount) {
        int capacity;
        int currentEnergy = this.getCurrentEnergy();
        if (currentEnergy >= (capacity = this.getEnergyCapacity())) {
            return false;
        }
        int energyToAdd = Math.min(amount, capacity - currentEnergy);
        this.setCurrentEnergy(currentEnergy + energyToAdd);
        return true;
    }

    default public int extractEnergy(int amount, boolean simulate) {
        int currentEnergy = this.getCurrentEnergy();
        int energyExtracted = Math.min(amount, currentEnergy);
        if (!simulate && energyExtracted > 0) {
            this.setCurrentEnergy(currentEnergy - energyExtracted);
        }
        return energyExtracted;
    }

    default public void loadEnergyPowerGenerator(CompoundTag compoundTag) {
        int energy = compoundTag.m_128451_(ENERGY_TAG);
        ItemStack battery = ItemStack.f_41583_;
        if (compoundTag.m_128441_(BATTERY_TAG)) {
            battery = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_(BATTERY_TAG));
        }
        this.setEnergyData(new EnergyPowerData(energy, battery, EnergyDebounceData.empty()));
    }

    default public void saveEnergyPowerGenerator(CompoundTag compoundTag) {
        EnergyPowerData data = this.getEnergyData();
        compoundTag.m_128405_(ENERGY_TAG, data.currentEnergy());
        if (!data.battery().m_41619_()) {
            CompoundTag batteryTag = new CompoundTag();
            data.battery().m_41739_(batteryTag);
            compoundTag.m_128365_(BATTERY_TAG, (Tag)batteryTag);
        }
    }

    default public int distributeToPlatformEnergySystem(Level level, BlockPos blockPos, int availableEnergy, int maxTransferRate) {
        try {
            Class<?> distributorClass = Class.forName("de.markusbordihn.scraptechworkshop.energy.compat.EnergyDistributor");
            Method method = distributorClass.getMethod("distributeToAdjacentBlocks", Level.class, BlockPos.class, Integer.TYPE, Integer.TYPE);
            Object result = method.invoke(null, level, blockPos, availableEnergy, maxTransferRate);
            return (Integer)result;
        }
        catch (Exception e) {
            return 0;
        }
    }

    default public int distributeEnergy(Level level, BlockPos blockPos, int chargingBatterySlot, int maxTransferRate) {
        Container container;
        ItemStack battery;
        int batterySpace;
        EnergyPowerGenerator energyPowerGenerator;
        if (level == null || level.f_46443_) {
            return 0;
        }
        int availableEnergy = this.getCurrentEnergy();
        if (availableEnergy <= 0) {
            return 0;
        }
        int totalDistributed = 0;
        int platformDistributed = this.distributeToPlatformEnergySystem(level, blockPos, availableEnergy, maxTransferRate);
        if (platformDistributed > 0) {
            this.extractEnergy(platformDistributed, false);
            totalDistributed += platformDistributed;
            this.markDirty();
        }
        ArrayList<EnergyConsumerInfo> consumers = new ArrayList<EnergyConsumerInfo>();
        for (Direction direction : Direction.values()) {
            int spaceAvailable;
            EnergyPowerConsumer consumer;
            BlockPos adjacentPos = blockPos.m_121945_(direction);
            BlockEntity blockEntity = level.m_7702_(adjacentPos);
            if (!(blockEntity instanceof EnergyPowerConsumer) || !(consumer = (EnergyPowerConsumer)blockEntity).canAcceptExternalEnergy() || (spaceAvailable = consumer.getEnergyCapacity() - consumer.getCurrentEnergy()) <= 0) continue;
            consumers.add(new EnergyConsumerInfo(consumer, spaceAvailable));
        }
        if (chargingBatterySlot >= 0 && (energyPowerGenerator = this) instanceof Container && (batterySpace = this.getBatterySpaceAvailable(battery = (container = (Container)energyPowerGenerator).m_8020_(chargingBatterySlot))) > 0) {
            consumers.add(new EnergyConsumerInfo(container, chargingBatterySlot, battery, batterySpace));
        }
        if (consumers.isEmpty()) {
            return totalDistributed;
        }
        int totalSpace = consumers.stream().mapToInt(c -> c.spaceAvailable).sum();
        int energyToDistribute = Math.min(Math.min(availableEnergy - totalDistributed, maxTransferRate), totalSpace);
        if (energyToDistribute <= 0) {
            return totalDistributed;
        }
        int remainingEnergy = energyToDistribute;
        for (int i = 0; i < consumers.size(); ++i) {
            int energyForThis;
            EnergyConsumerInfo consumer = (EnergyConsumerInfo)consumers.get(i);
            if (i == consumers.size() - 1) {
                energyForThis = Math.min(remainingEnergy, consumer.spaceAvailable);
            } else {
                energyForThis = Math.min(energyToDistribute * consumer.spaceAvailable / totalSpace, consumer.spaceAvailable);
                energyForThis = Math.min(energyForThis, remainingEnergy);
            }
            if (energyForThis <= 0) continue;
            int actualTransferred = consumer.receiveEnergy(energyForThis);
            totalDistributed += actualTransferred;
            remainingEnergy -= actualTransferred;
        }
        if (totalDistributed > 0) {
            this.extractEnergy(totalDistributed, false);
            this.markDirty();
        }
        return totalDistributed;
    }

    default public int getBatterySpaceAvailable(ItemStack battery) {
        if (battery.m_41619_()) {
            return 0;
        }
        if (battery.m_41720_() instanceof EmptyEnergyCellItem) {
            return 5000;
        }
        Item item = battery.m_41720_();
        if (item instanceof EnergyCellItem) {
            EnergyCellItem batteryItem = (EnergyCellItem)item;
            int currentEnergy = batteryItem.getEnergy(battery);
            return 5000 - currentEnergy;
        }
        return 0;
    }

    public static class EnergyConsumerInfo {
        private final EnergyPowerConsumer blockConsumer;
        private final Container batteryContainer;
        private final int batterySlot;
        private final ItemStack battery;
        private final int spaceAvailable;

        public EnergyConsumerInfo(EnergyPowerConsumer consumer, int spaceAvailable) {
            this.blockConsumer = consumer;
            this.batteryContainer = null;
            this.batterySlot = -1;
            this.battery = null;
            this.spaceAvailable = spaceAvailable;
        }

        public EnergyConsumerInfo(Container container, int slot, ItemStack battery, int spaceAvailable) {
            this.blockConsumer = null;
            this.batteryContainer = container;
            this.batterySlot = slot;
            this.battery = battery;
            this.spaceAvailable = spaceAvailable;
        }

        public int receiveEnergy(int amount) {
            if (this.blockConsumer != null) {
                return this.blockConsumer.receiveEnergy(amount, false);
            }
            if (this.battery != null && this.batteryContainer != null) {
                return this.chargeBatteryItem(this.batteryContainer, this.batterySlot, this.battery, amount);
            }
            return 0;
        }

        private int chargeBatteryItem(Container container, int slot, ItemStack battery, int amount) {
            if (battery.m_41720_() instanceof EmptyEnergyCellItem) {
                ItemStack chargedBattery = new ItemStack((ItemLike)ModItems.ENERGY_CELL.get());
                Item item = chargedBattery.m_41720_();
                if (item instanceof EnergyCellItem) {
                    EnergyCellItem energyCell = (EnergyCellItem)item;
                    int energyToAdd = Math.min(amount, 5000);
                    energyCell.setEnergy(chargedBattery, energyToAdd);
                    container.m_6836_(slot, chargedBattery);
                    return energyToAdd;
                }
            } else {
                Item chargedBattery = battery.m_41720_();
                if (chargedBattery instanceof EnergyCellItem) {
                    EnergyCellItem batteryItem = (EnergyCellItem)chargedBattery;
                    int currentEnergy = batteryItem.getEnergy(battery);
                    int energyToAdd = Math.min(amount, 5000 - currentEnergy);
                    batteryItem.setEnergy(battery, currentEnergy + energyToAdd);
                    return energyToAdd;
                }
            }
            return 0;
        }
    }
}

