/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy.compat;

import de.markusbordihn.scraptechworkshop.energy.EnergyConverter;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerGenerator;
import net.minecraftforge.energy.IEnergyStorage;

public class ForgeEnergyGeneratorWrapper
implements IEnergyStorage {
    private final EnergyPowerGenerator energyGenerator;

    public ForgeEnergyGeneratorWrapper(EnergyPowerGenerator energyGenerator) {
        this.energyGenerator = energyGenerator;
    }

    public int receiveEnergy(int forgeEnergyReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int currentMilliampereHour = this.energyGenerator.getCurrentEnergy();
        int milliampereHourExtracted = Math.min(EnergyConverter.forgeEnergyToMilliampereHour(maxExtract), currentMilliampereHour);
        if (!simulate && milliampereHourExtracted > 0) {
            this.energyGenerator.extractEnergy(milliampereHourExtracted, false);
            this.energyGenerator.markDirty();
        }
        return EnergyConverter.milliampereHourToForgeEnergy(milliampereHourExtracted);
    }

    public int getEnergyStored() {
        return EnergyConverter.milliampereHourToForgeEnergy(this.energyGenerator.getCurrentEnergy());
    }

    public int getMaxEnergyStored() {
        return EnergyConverter.milliampereHourToForgeEnergy(this.energyGenerator.getEnergyCapacity());
    }

    public boolean canExtract() {
        return this.energyGenerator.getCurrentEnergy() > 0;
    }

    public boolean canReceive() {
        return false;
    }
}

