/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy.compat;

import de.markusbordihn.scraptechworkshop.energy.EnergyConverter;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerGenerator;
import de.markusbordihn.scraptechworkshop.energy.compat.MekanismEnergyCompat;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MekanismEnergyGeneratorWrapper
implements InvocationHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String MEKANISM_ENERGY_PACKAGE = "mekanism.api.energy";
    private static final String STRICT_ENERGY_HANDLER_CLASS = "mekanism.api.energy.IStrictEnergyHandler";
    private static Class<?> strictEnergyHandlerClass;
    private static Class<?> floatingLongClass;
    private static Method createFloatingLongMethod;
    private static Method floatingLongValueMethod;
    private static boolean initialized;
    private final EnergyPowerGenerator energyGenerator;

    public MekanismEnergyGeneratorWrapper(EnergyPowerGenerator energyGenerator) {
        this.energyGenerator = energyGenerator;
    }

    public static boolean initialize() {
        if (initialized) {
            return strictEnergyHandlerClass != null;
        }
        initialized = true;
        if (!MekanismEnergyCompat.isMekanismLoaded()) {
            return false;
        }
        try {
            strictEnergyHandlerClass = Class.forName(STRICT_ENERGY_HANDLER_CLASS);
            floatingLongClass = Class.forName("mekanism.api.energy.FloatingLong");
            createFloatingLongMethod = floatingLongClass.getMethod("create", Long.TYPE);
            floatingLongValueMethod = floatingLongClass.getMethod("longValue", new Class[0]);
            LOGGER.info("Mekanism Energy API successfully loaded via reflection");
            return true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            LOGGER.warn("Failed to load Mekanism Energy API via reflection: {}", (Object)e.getMessage());
            strictEnergyHandlerClass = null;
            return false;
        }
    }

    public static Object createProxy(EnergyPowerGenerator generator) {
        if (!MekanismEnergyGeneratorWrapper.initialize()) {
            return null;
        }
        MekanismEnergyGeneratorWrapper handler = new MekanismEnergyGeneratorWrapper(generator);
        return Proxy.newProxyInstance(strictEnergyHandlerClass.getClassLoader(), new Class[]{strictEnergyHandlerClass}, (InvocationHandler)handler);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        try {
            switch (methodName) {
                case "insertEnergy": {
                    return this.createFloatingLong(0L);
                }
                case "extractEnergy": {
                    if (args != null && args.length >= 1) {
                        long requestedJoules = this.getFloatingLongValue(args[0]);
                        long extractedJoules = this.extractEnergyInJoules(requestedJoules);
                        return this.createFloatingLong(extractedJoules);
                    }
                    return this.createFloatingLong(0L);
                }
                case "getEnergy": {
                    long currentJoules = EnergyConverter.milliampereHourToMekanismJoules(this.energyGenerator.getCurrentEnergy());
                    return this.createFloatingLong(currentJoules);
                }
                case "getMaxEnergy": {
                    long maxJoules = EnergyConverter.milliampereHourToMekanismJoules(this.energyGenerator.getEnergyCapacity());
                    return this.createFloatingLong(maxJoules);
                }
                case "setEnergy": {
                    return null;
                }
                case "getEnergyContainers": {
                    return Collections.emptyList();
                }
                case "getSideFor": {
                    return null;
                }
            }
            LOGGER.debug("Unhandled Mekanism method call: {}", (Object)methodName);
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Error handling Mekanism method {}: {}", (Object)methodName, (Object)e.getMessage());
            return null;
        }
    }

    private long extractEnergyInJoules(long requestedJoules) {
        int currentMah = this.energyGenerator.getCurrentEnergy();
        if (currentMah <= 0) {
            return 0L;
        }
        int requestedMah = EnergyConverter.mekanismJoulesToMilliampereHour(requestedJoules);
        int extractedMah = Math.min(requestedMah, currentMah);
        if (extractedMah > 0) {
            this.energyGenerator.extractEnergy(extractedMah, false);
            this.energyGenerator.markDirty();
        }
        return EnergyConverter.milliampereHourToMekanismJoules(extractedMah);
    }

    private Object createFloatingLong(long value) throws Exception {
        return createFloatingLongMethod.invoke(null, value);
    }

    private long getFloatingLongValue(Object floatingLong) throws Exception {
        return (Long)floatingLongValueMethod.invoke(floatingLong, new Object[0]);
    }

    static {
        initialized = false;
    }
}

