/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.menu;

import de.markusbordihn.scraptechworkshop.block.entity.rechargestation.RechargeStationBlockEntity;
import de.markusbordihn.scraptechworkshop.block.rechargestation.RechargeStationBlock;
import de.markusbordihn.scraptechworkshop.data.rechargestation.RechargeStationStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerConsumer;
import de.markusbordihn.scraptechworkshop.menu.EnergyPowerMenu;
import de.markusbordihn.scraptechworkshop.menu.slots.DummySlot;
import de.markusbordihn.scraptechworkshop.menu.slots.EnergyCellSlot;
import de.markusbordihn.scraptechworkshop.menu.slots.RechargeStationInputSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RechargeStationMenu
extends EnergyPowerMenu {
    public static final int INPUT_SLOT_X = 80;
    public static final int INPUT_SLOT_Y = 35;
    public static final int PLAYER_INVENTORY_START_Y = 99;
    public static final int PROGRESS_BAR_X = 68;
    public static final int PROGRESS_BAR_Y = 56;
    public static final int PROGRESS_BAR_WIDTH = 40;
    public static final int PROGRESS_BAR_HEIGHT = 5;
    public static final int ADDITIONAL_CONTAINER_DATA_SIZE = 2;
    public static final int PROGRESS_DATA_INDEX = 0;
    public static final int MAX_PROGRESS_DATA_INDEX = 1;
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String LOG_PREFIX = "[RECHARGE_STATION]";
    public static MenuType<RechargeStationMenu> TYPE;
    private final RechargeStationBlockEntity blockEntity;
    private final Level level;
    private final ContainerData additionalData;
    private final SimpleContainer dummyContainer;
    private final BlockPos blockPos;

    public RechargeStationMenu(int windowId, Inventory playerInventory, FriendlyByteBuf additionalData) {
        this(windowId, playerInventory, RechargeStationMenu.getBlockEntityFromData(playerInventory, additionalData), (ContainerData)new SimpleContainerData(2));
    }

    public RechargeStationMenu(int windowId, Inventory playerInventory, BlockEntity entity, ContainerData additionalData) {
        SimpleContainerData simpleContainerData;
        if (entity instanceof EnergyPowerConsumer) {
            EnergyPowerConsumer consumer = (EnergyPowerConsumer)entity;
            simpleContainerData = consumer.getEnergyPowerData();
        } else {
            simpleContainerData = new SimpleContainerData(2);
        }
        super(TYPE, windowId, (ContainerData)simpleContainerData);
        this.level = playerInventory.f_35978_.m_9236_();
        this.additionalData = additionalData != null ? additionalData : new SimpleContainerData(2);
        this.dummyContainer = new SimpleContainer(2);
        if (entity instanceof RechargeStationBlockEntity) {
            RechargeStationBlockEntity rechargeStationBlockEntity;
            this.blockEntity = rechargeStationBlockEntity = (RechargeStationBlockEntity)entity;
            this.blockPos = rechargeStationBlockEntity.m_58899_();
        } else {
            log.error("{} Expected RechargeStationBlockEntity but got {} at {}", (Object)LOG_PREFIX, (Object)entity, entity != null ? entity.m_58899_() : "NULL");
            this.blockEntity = null;
            this.blockPos = null;
        }
        RechargeStationMenu.m_38869_((Container)playerInventory, (int)2);
        this.addRechargeStationSlots();
        this.addPlayerInventoryAndHotbar(playerInventory, 99);
        this.m_38884_(this.additionalData);
    }

    private static BlockEntity getBlockEntityFromData(Inventory playerInventory, FriendlyByteBuf additionalData) {
        if (additionalData == null) {
            log.error("{} additionalData is NULL", (Object)LOG_PREFIX);
            return null;
        }
        try {
            BlockPos pos = additionalData.m_130135_();
            Level level = playerInventory.f_35978_.m_9236_();
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity == null) {
                log.error("{} BlockEntity is NULL at {}", (Object)LOG_PREFIX, (Object)pos);
                return null;
            }
            return blockEntity;
        }
        catch (Exception e) {
            log.error("{} Error reading BlockEntity from additionalData: {}", (Object)LOG_PREFIX, (Object)e.getMessage());
            return null;
        }
    }

    private void addRechargeStationSlots() {
        RechargeStationBlockEntity entityToUse = this.getValidBlockEntity();
        if (entityToUse != null) {
            this.m_38897_(new RechargeStationInputSlot((Container)entityToUse, 0, 80, 35));
            this.m_38897_(new EnergyCellSlot((Container)entityToUse, 1, -20, 6));
        } else {
            for (int i = 0; i < 2; ++i) {
                this.m_38897_(new DummySlot((Container)this.dummyContainer, i, -1000, -1000));
            }
            log.warn("{} Using dummy slots because BlockEntity is not available", (Object)LOG_PREFIX);
        }
    }

    private RechargeStationBlockEntity getValidBlockEntity() {
        BlockEntity entity;
        if (this.blockEntity != null) {
            return this.blockEntity;
        }
        if (this.blockPos != null && this.level != null && (entity = this.level.m_7702_(this.blockPos)) instanceof RechargeStationBlockEntity) {
            RechargeStationBlockEntity rechargeStationEntity = (RechargeStationBlockEntity)entity;
            log.debug("{} Resolved BlockEntity on delayed lookup", (Object)LOG_PREFIX);
            return rechargeStationEntity;
        }
        return null;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack returnStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            returnStack = slotStack.m_41777_();
            if (index < 2 ? !this.m_38903_(slotStack, 2, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, 2, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return returnStack;
    }

    public boolean m_6875_(Player player) {
        if (this.blockEntity == null) {
            return false;
        }
        return RechargeStationMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
    }

    public boolean isCharging() {
        int progress = this.additionalData.m_6413_(0);
        int maxProgress = this.additionalData.m_6413_(1);
        return progress > 0 && progress < maxProgress;
    }

    public int getScaledProgress() {
        int progress = this.additionalData.m_6413_(0);
        int maxProgress = this.additionalData.m_6413_(1);
        return maxProgress != 0 && progress != 0 ? progress * 40 / maxProgress : 0;
    }

    public RechargeStationBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public RechargeStationStatus getRechargeStationStatus() {
        if (this.blockEntity == null || this.blockEntity.m_58904_() == null) {
            return RechargeStationStatus.IDLE;
        }
        return (RechargeStationStatus)((Object)this.blockEntity.m_58900_().m_61143_(RechargeStationBlock.STATUS));
    }
}

