/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import de.markusbordihn.scraptechworkshop.energy.EnergyPowerData;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface EnergyPowerConsumer {
    public static final String ENERGY_TAG = "Energy";
    public static final String BATTERY_TAG = "Battery";

    public int getEnergyCapacity();

    public int getBatterySlot();

    public void markDirty();

    public EnergyPowerData getEnergyData();

    public void setEnergyData(EnergyPowerData var1);

    default public int getCurrentEnergy() {
        return this.getEnergyData().currentEnergy();
    }

    default public void setCurrentEnergy(int energy) {
        this.setEnergyData(this.getEnergyData().withCurrentEnergy(energy));
    }

    default public ItemStack getBattery() {
        return this.getEnergyData().battery();
    }

    default public void setBattery(ItemStack battery) {
        this.setEnergyData(this.getEnergyData().withBattery(battery));
    }

    default public int getEnergyTransferRate() {
        return 50;
    }

    default public ContainerData getEnergyPowerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> EnergyPowerConsumer.this.getCurrentEnergy();
                    case 1 -> EnergyPowerConsumer.this.getEnergyCapacity();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                if (index == 0) {
                    EnergyPowerConsumer.this.setCurrentEnergy(value);
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    default public boolean hasEnergy(int amount) {
        return this.getCurrentEnergy() >= amount;
    }

    default public boolean consumeEnergy(int amount) {
        if (this.getCurrentEnergy() >= amount) {
            this.setCurrentEnergy(this.getCurrentEnergy() - amount);
            return true;
        }
        return false;
    }

    default public boolean chargeFromBattery(int amount) {
        Item item;
        ItemStack battery = this.getBattery();
        if (battery.m_41619_() || !((item = battery.m_41720_()) instanceof EnergyCellItem)) {
            return false;
        }
        EnergyCellItem batteryItem = (EnergyCellItem)item;
        int batteryEnergy = batteryItem.getEnergy(battery);
        if (batteryEnergy <= 1) {
            this.setBattery(batteryItem.createEmptyBattery());
            this.markDirty();
            return false;
        }
        int currentEnergy = this.getCurrentEnergy();
        int capacity = this.getEnergyCapacity();
        int neededEnergy = Math.min(amount, capacity - currentEnergy);
        if (neededEnergy <= 0) {
            return false;
        }
        int energyToTransfer = Math.min(neededEnergy, batteryEnergy);
        batteryItem.consumeEnergy(battery, energyToTransfer);
        this.setCurrentEnergy(currentEnergy + energyToTransfer);
        if (batteryItem.getEnergy(battery) <= 1) {
            this.setBattery(batteryItem.createEmptyBattery());
        } else {
            this.setBattery(battery);
        }
        this.markDirty();
        return true;
    }

    default public int getEnergyPercentage() {
        int capacity = this.getEnergyCapacity();
        return capacity > 0 ? this.getCurrentEnergy() * 100 / capacity : 0;
    }

    default public boolean hasBattery() {
        ItemStack battery = this.getBattery();
        return !battery.m_41619_() && battery.m_41720_() instanceof EnergyCellItem;
    }

    default public boolean canAcceptExternalEnergy() {
        return this.getCurrentEnergy() < this.getEnergyCapacity();
    }

    default public int receiveEnergy(int amount, boolean simulate) {
        int capacity = this.getEnergyCapacity();
        int currentEnergy = this.getCurrentEnergy();
        int energyReceived = Math.min(amount, capacity - currentEnergy);
        if (!simulate && energyReceived > 0) {
            this.setCurrentEnergy(currentEnergy + energyReceived);
        }
        return energyReceived;
    }

    default public void loadEnergyPowerConsumer(CompoundTag compoundTag) {
        int energy = compoundTag.m_128451_(ENERGY_TAG);
        ItemStack battery = ItemStack.f_41583_;
        if (compoundTag.m_128441_(BATTERY_TAG)) {
            battery = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_(BATTERY_TAG));
        }
        this.setEnergyData(new EnergyPowerData(energy, battery));
    }

    default public void saveEnergyPowerConsumer(CompoundTag compoundTag) {
        EnergyPowerData data = this.getEnergyData();
        compoundTag.m_128405_(ENERGY_TAG, data.currentEnergy());
        if (!data.battery().m_41619_()) {
            CompoundTag batteryTag = new CompoundTag();
            data.battery().m_41739_(batteryTag);
            compoundTag.m_128365_(BATTERY_TAG, (Tag)batteryTag);
        }
    }
}

