/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.saveddata;

import com.mojang.serialization.DynamicOps;
import de.markusbordihn.scraptechworkshop.data.holocube.HoloCubePlayerData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloCubeStorage
extends SavedData {
    public static final String DATA_NAME = "scrap_tech_workshop_holo_cubes";
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String HOLO_CUBES_TAG = "HoloCubes";
    private static HoloCubeStorage instance;
    private final List<HoloCubePlayerData> holoCubeList;

    public HoloCubeStorage(List<HoloCubePlayerData> holoCubes) {
        log.info("Creating new HoloCubeStorage with {} entries", (Object)holoCubes.size());
        this.holoCubeList = new ArrayList<HoloCubePlayerData>(holoCubes);
    }

    public HoloCubeStorage() {
        this(new ArrayList<HoloCubePlayerData>());
    }

    public static void init(ServerLevel serverLevel) {
        if (serverLevel == null) {
            log.error("Cannot initialize HoloCubeStorage without a valid level!");
            return;
        }
        log.info("Initializing HoloCubeStorage with level: {}", (Object)serverLevel);
        instance = HoloCubeStorage.get(serverLevel);
    }

    public static HoloCubeStorage get() {
        if (instance == null) {
            throw new IllegalStateException("HoloCubeStorage is not initialized!");
        }
        return instance;
    }

    public static HoloCubeStorage get(ServerLevel serverLevel) {
        if (instance == null) {
            instance = (HoloCubeStorage)serverLevel.m_8895_().m_164861_(HoloCubeStorage::load, HoloCubeStorage::new, DATA_NAME);
        }
        return instance;
    }

    public static void reset() {
        log.info("Resetting Holo Cube Storage instance ...");
        instance = null;
    }

    public static HoloCubeStorage load(CompoundTag compoundTag) {
        List loadedData = HoloCubePlayerData.CODEC.listOf().parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128423_(HOLO_CUBES_TAG)).resultOrPartial(error -> log.error("Failed to decode holocube data: {}", error)).orElse(new ArrayList());
        return new HoloCubeStorage(loadedData);
    }

    public boolean hasReceivedHoloCube(UUID playerUUID, ResourceLocation holoLogId) {
        return this.holoCubeList.stream().anyMatch(data -> data.playerUUID().equals(playerUUID) && data.holoLogId().equals((Object)holoLogId));
    }

    public void addHoloCube(HoloCubePlayerData holoCubePlayerData) {
        if (holoCubePlayerData == null) {
            log.warn("Cannot add null holocube data");
            return;
        }
        this.holoCubeList.add(holoCubePlayerData);
        log.info("Added holocube {} for player {} at {}", (Object)holoCubePlayerData.holoLogId(), (Object)holoCubePlayerData.playerUUID(), (Object)holoCubePlayerData.receivedTimestamp());
        this.m_77762_();
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        HoloCubePlayerData.CODEC.listOf().encodeStart((DynamicOps)NbtOps.f_128958_, this.holoCubeList).resultOrPartial(error -> log.error("Failed to encode holocube data: {}", error)).ifPresent(tag -> compoundTag.m_128365_(HOLO_CUBES_TAG, tag));
        return compoundTag;
    }
}

