/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.blockentity;

import de.markusbordihn.scraptechworkshop.block.entity.recycler.RecyclerBlockEntity;
import de.markusbordihn.scraptechworkshop.block.recycler.RecyclerBlock;
import de.markusbordihn.scraptechworkshop.data.recycler.RecyclerStatus;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;

public class RecyclerBlockEntityRenderer
implements class_827<RecyclerBlockEntity> {
    private static final int INPUT_SLOT = 0;
    private static final int PROGRESS_DATA_INDEX = 0;
    private static final int MAX_PROGRESS_DATA_INDEX = 1;
    private static final double ITEM_X_OFFSET = 0.5;
    private static final double ITEM_Y_OFFSET = 0.85;
    private static final double ITEM_Z_OFFSET = 0.56;
    private static final float INITIAL_SCALE = 0.4f;
    private static final float FINAL_SCALE = 0.01f;
    private static final float ANIMATION_SPEED_MULTIPLIER = 2.0f;
    private static final float DOWNWARD_MOVEMENT_FACTOR = 0.3f;
    private static final int PARTICLE_SPAWN_INTERVAL = 30;
    private static final int DUST_PARTICLE_INTERVAL = 40;
    private static final float DUST_PARTICLE_CHANCE = 0.3f;
    private static final double CLOSE_RENDER_DISTANCE_SQUARED = 256.0;
    private static final int PROXIMITY_CHECK_INTERVAL = 20;
    private final class_918 itemRenderer;
    private long lastProximityCheck = -1L;
    private boolean cachedPlayerNearby = false;
    private class_2338 lastCheckedPos = null;

    public RecyclerBlockEntityRenderer(class_5614.class_5615 context) {
        this.itemRenderer = context.method_43335();
    }

    public void render(RecyclerBlockEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_1937 level = blockEntity.method_10997();
        if (level == null || !level.field_9236) {
            return;
        }
        RecyclerStatus status = (RecyclerStatus)((Object)blockEntity.method_11010().method_11654(RecyclerBlock.STATUS));
        if (status != RecyclerStatus.WORKING) {
            return;
        }
        class_1799 inputStack = blockEntity.method_5438(0);
        if (inputStack.method_7960()) {
            return;
        }
        if (this.isSolidBlockAbove(level, blockEntity.method_11016())) {
            return;
        }
        if (!this.isPlayerNearbyCached(level, blockEntity.method_11016())) {
            return;
        }
        float progress = this.getProcessingProgress(blockEntity, partialTick);
        if (progress <= 0.0f) {
            return;
        }
        this.addParticleEffects(blockEntity, level, inputStack);
        this.renderAnimatedItem(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay, inputStack, level, progress);
    }

    private void renderAnimatedItem(RecyclerBlockEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, class_1799 inputStack, class_1937 level, float progress) {
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.85, 0.56);
        class_2350 facing = (class_2350)blockEntity.method_11010().method_11654((class_2769)RecyclerBlock.FACING);
        switch (facing) {
            case field_11035: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case field_11039: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
                break;
            }
            case field_11034: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
        }
        long gameTime = level.method_8510();
        float animationTime = (float)gameTime + partialTick;
        int rotationAxis = (int)(gameTime % 3L);
        float rotation = animationTime * 2.0f % 360.0f;
        float scale = class_3532.method_16439((float)progress, (float)0.4f, (float)0.01f);
        float scaleReduction = 0.4f - scale;
        float downwardMovement = scaleReduction * 0.3f;
        poseStack.method_46416(0.0f, -downwardMovement, 0.0f);
        poseStack.method_22905(scale, scale, scale);
        switch (rotationAxis) {
            case 0: {
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(rotation));
                break;
            }
            case 1: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(rotation));
                break;
            }
            case 2: {
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(rotation));
                break;
            }
            default: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(rotation));
            }
        }
        this.itemRenderer.method_23178(inputStack, class_811.field_4319, packedLight, packedOverlay, poseStack, bufferSource, level, (int)blockEntity.method_11016().method_10063());
        poseStack.method_22909();
    }

    private void addParticleEffects(RecyclerBlockEntity blockEntity, class_1937 level, class_1799 inputStack) {
        long gameTime = level.method_8510();
        if (gameTime % 30L != 0L) {
            return;
        }
        double blockX = (double)blockEntity.method_11016().method_10263() + 0.5;
        double blockY = (double)blockEntity.method_11016().method_10264() + 0.75;
        double blockZ = (double)blockEntity.method_11016().method_10260() + 0.5;
        double offsetX = (level.method_8409().method_43058() - 0.5) * 0.0375;
        double offsetY = (level.method_8409().method_43058() - 0.5) * 0.025;
        double offsetZ = (level.method_8409().method_43058() - 0.5) * 0.0375;
        double velocityX = (level.method_8409().method_43058() - 0.5) * 0.0025;
        double velocityY = level.method_8409().method_43058() * 0.00125;
        double velocityZ = (level.method_8409().method_43058() - 0.5) * 0.0025;
        class_2392 particleOption = new class_2392(class_2398.field_11218, inputStack);
        level.method_8406((class_2394)particleOption, blockX + offsetX, blockY + offsetY, blockZ + offsetZ, velocityX, velocityY, velocityZ);
        if (gameTime % 40L == 0L && level.method_8409().method_43057() < 0.3f) {
            level.method_8406((class_2394)class_2398.field_11251, blockX + (level.method_8409().method_43058() - 0.5) * 0.025, blockY + 0.0125, blockZ + (level.method_8409().method_43058() - 0.5) * 0.025, 0.0, 0.0025, 0.0);
        }
    }

    private float getProcessingProgress(RecyclerBlockEntity blockEntity, float partialTick) {
        int progress = blockEntity.getContainerData().method_17390(0);
        int maxProgress = blockEntity.getContainerData().method_17390(1);
        if (maxProgress <= 0) {
            return 0.0f;
        }
        return Math.min(1.0f, ((float)progress + partialTick) / (float)maxProgress);
    }

    private boolean isSolidBlockAbove(class_1937 level, class_2338 pos) {
        class_2338 abovePos = pos.method_10084();
        class_2680 stateAbove = level.method_8320(abovePos);
        return stateAbove.method_26216((class_1922)level, abovePos);
    }

    private boolean isPlayerNearbyCached(class_1937 level, class_2338 pos) {
        long currentTime = level.method_8510();
        if (this.lastProximityCheck == -1L || currentTime - this.lastProximityCheck >= 20L || !pos.equals((Object)this.lastCheckedPos)) {
            this.lastProximityCheck = currentTime;
            this.lastCheckedPos = pos.method_10062();
            this.cachedPlayerNearby = this.calculatePlayerNearby(level, pos);
        }
        return this.cachedPlayerNearby;
    }

    private boolean calculatePlayerNearby(class_1937 level, class_2338 pos) {
        double deltaZ;
        double deltaY;
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if (player == null) {
            return false;
        }
        double deltaX = player.method_23317() - ((double)pos.method_10263() + 0.5);
        double distanceSquared = deltaX * deltaX + (deltaY = player.method_23318() - ((double)pos.method_10264() + 0.5)) * deltaY + (deltaZ = player.method_23321() - ((double)pos.method_10260() + 0.5)) * deltaZ;
        return distanceSquared <= 256.0;
    }
}

