/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.config;

import de.markusbordihn.scraptechworkshop.config.Config;
import java.io.File;
import java.util.Map;
import java.util.Properties;

public class ScrapRobotConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "scrap_robot.cfg";
    public static final String CONFIG_FILE_HEADER = " Scrap Robot Configuration\n\n This configuration file allows you to define spawn settings for Scrap Robots.\n\n Spawn Settings:\n - spawn_enabled: Enable/disable natural spawning of scrap robots\n - spawn_weight: Spawn weight (higher = more common, vanilla mobs are usually 10-100)\n - spawn_min_group: Minimum number of robots per spawn\n - spawn_max_group: Maximum number of robots per spawn\n - spawn_biome_type: Biome type filter (ALL, OVERWORLD, NETHER, END, PLAINS, FOREST, DESERT, etc.)\n - despawn_distance: Distance at which robots can despawn (0 = never despawn)\n\n Performance:\n - Lower spawn_weight for better performance\n - Keep spawn groups small (1-2) to prevent lag\n - Consider disabling if you have performance issues\n\n";
    public static boolean mixedScrapRobotSpawnEnabled = true;
    public static int mixedScrapRobotSpawnWeight = 3;
    public static int mixedScrapRobotSpawnMinGroup = 1;
    public static int mixedScrapRobotSpawnMaxGroup = 1;
    public static String mixedScrapRobotBiomeType = "OVERWORLD";
    public static int mixedScrapRobotDespawnDistance = 0;

    private ScrapRobotConfig() {
    }

    public static void registerConfig() {
        File configFile = ScrapRobotConfig.getConfigFile(CONFIG_FILE_NAME);
        ScrapRobotConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        Properties properties = ScrapRobotConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = new Properties();
        unmodifiedProperties.putAll((Map<?, ?>)properties);
        mixedScrapRobotSpawnEnabled = ScrapRobotConfig.parseConfigValue(properties, "spawn_enabled", mixedScrapRobotSpawnEnabled);
        mixedScrapRobotSpawnWeight = ScrapRobotConfig.parseConfigValue(properties, "spawn_weight", mixedScrapRobotSpawnWeight);
        mixedScrapRobotSpawnMinGroup = ScrapRobotConfig.parseConfigValue(properties, "spawn_min_group", mixedScrapRobotSpawnMinGroup);
        mixedScrapRobotSpawnMaxGroup = ScrapRobotConfig.parseConfigValue(properties, "spawn_max_group", mixedScrapRobotSpawnMaxGroup);
        mixedScrapRobotBiomeType = ScrapRobotConfig.parseConfigValue(properties, "spawn_biome_type", mixedScrapRobotBiomeType);
        mixedScrapRobotDespawnDistance = ScrapRobotConfig.parseConfigValue(properties, "despawn_distance", mixedScrapRobotDespawnDistance);
        if (mixedScrapRobotSpawnWeight < 0) {
            mixedScrapRobotSpawnWeight = 0;
            log.warn("Invalid spawn_weight, setting to 0 (disabled)");
        }
        if (mixedScrapRobotSpawnMinGroup < 1) {
            mixedScrapRobotSpawnMinGroup = 1;
        }
        if (mixedScrapRobotSpawnMaxGroup < mixedScrapRobotSpawnMinGroup) {
            mixedScrapRobotSpawnMaxGroup = mixedScrapRobotSpawnMinGroup;
        }
        ScrapRobotConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }
}

