/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.loot;

import de.markusbordihn.scraptechworkshop.item.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapLootGenerator {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String LOG_PREFIX = "[ScrapLootGenerator]";
    private static final Random RANDOM = new Random();

    public static List<class_1799> generateScrapForBiome(class_1937 level, class_2338 pos, String biomeKey) {
        ArrayList<class_1799> loot = new ArrayList<class_1799>();
        int itemCount = 1 + RANDOM.nextInt(3);
        for (int i = 0; i < itemCount; ++i) {
            class_1799 scrap;
            class_1799 class_17992 = scrap = RANDOM.nextInt(100) < 20 ? ScrapLootGenerator.generateFishingJunk() : ScrapLootGenerator.generateSingleScrap(level, pos, biomeKey);
            if (scrap.method_7960()) continue;
            loot.add(scrap);
        }
        log.debug("{} Generated {} scrap items for biome {} at {}", (Object)LOG_PREFIX, (Object)loot.size(), (Object)biomeKey, (Object)pos);
        return loot;
    }

    private static class_1799 generateFishingJunk() {
        return switch (RANDOM.nextInt(15)) {
            case 0 -> new class_1799((class_1935)class_1802.field_8745, 1);
            case 1 -> new class_1799((class_1935)class_1802.field_8370, 1);
            case 2 -> new class_1799((class_1935)class_1802.field_8511, 1 + RANDOM.nextInt(2));
            case 3 -> new class_1799((class_1935)class_1802.field_8600, 1 + RANDOM.nextInt(3));
            case 4 -> new class_1799((class_1935)class_1802.field_8276, 1 + RANDOM.nextInt(3));
            case 5 -> new class_1799((class_1935)class_1802.field_8428, 1);
            case 6 -> new class_1799((class_1935)class_1802.field_8469, 1 + RANDOM.nextInt(2));
            case 7 -> new class_1799((class_1935)class_1802.field_8606, 1 + RANDOM.nextInt(2));
            case 8 -> new class_1799((class_1935)class_1802.field_8366, 1);
            case 9 -> new class_1799((class_1935)class_1802.field_8794, 1 + RANDOM.nextInt(2));
            case 10 -> new class_1799((class_1935)class_1802.field_8648, 1 + RANDOM.nextInt(4));
            case 11 -> new class_1799((class_1935)class_1802.field_8116, 1 + RANDOM.nextInt(2));
            case 12 -> new class_1799((class_1935)class_1802.field_17524, 1);
            case 13 -> new class_1799((class_1935)class_1802.field_8153, 1 + RANDOM.nextInt(2));
            default -> new class_1799((class_1935)class_1802.field_8600, 1);
        };
    }

    private static class_1799 generateSingleScrap(class_1937 level, class_2338 pos, String biomeKey) {
        class_1959 biome = (class_1959)level.method_23753(pos).comp_349();
        if (biome.method_33599(pos)) {
            return ScrapLootGenerator.generateColdBiomeScrap();
        }
        if (biome.method_8712() > 1.0f) {
            return ScrapLootGenerator.generateHotBiomeScrap();
        }
        if (biomeKey.contains("ocean") || biomeKey.contains("river") || biomeKey.contains("beach")) {
            return ScrapLootGenerator.generateWaterBiomeScrap();
        }
        if (biomeKey.contains("desert")) {
            return ScrapLootGenerator.generateDesertScrap();
        }
        if (biomeKey.contains("jungle")) {
            return ScrapLootGenerator.generateJungleScrap();
        }
        if (biomeKey.contains("forest") || biomeKey.contains("taiga")) {
            return ScrapLootGenerator.generateForestScrap();
        }
        if (biomeKey.contains("mountain") || biomeKey.contains("hill")) {
            return ScrapLootGenerator.generateMountainScrap();
        }
        if (biomeKey.contains("swamp")) {
            return ScrapLootGenerator.generateSwampScrap();
        }
        if (biomeKey.contains("nether")) {
            return ScrapLootGenerator.generateNetherScrap();
        }
        if (biomeKey.contains("end")) {
            return ScrapLootGenerator.generateEndScrap();
        }
        return ScrapLootGenerator.generateGenericScrap();
    }

    private static class_1799 generateColdBiomeScrap() {
        return switch (RANDOM.nextInt(5)) {
            case 0 -> new class_1799((class_1935)ModItems.METAL_SCRAP.get(), 1 + RANDOM.nextInt(3));
            case 1 -> new class_1799((class_1935)ModItems.TECH_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 2 -> new class_1799((class_1935)ModItems.IRON_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 3 -> new class_1799((class_1935)ModItems.ALLOY_SCRAP.get(), 1 + RANDOM.nextInt(2));
            default -> new class_1799((class_1935)ModItems.METAL_SCRAP.get(), 1);
        };
    }

    private static class_1799 generateHotBiomeScrap() {
        return switch (RANDOM.nextInt(5)) {
            case 0 -> new class_1799((class_1935)ModItems.ALLOY_SCRAP.get(), 1 + RANDOM.nextInt(3));
            case 1 -> new class_1799((class_1935)ModItems.METAL_SCRAP.get(), 1);
            case 2 -> new class_1799((class_1935)ModItems.COPPER_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 3 -> new class_1799((class_1935)ModItems.TECH_SCRAP.get(), 1);
            default -> new class_1799((class_1935)ModItems.ALLOY_SCRAP.get(), 1 + RANDOM.nextInt(2));
        };
    }

    private static class_1799 generateWaterBiomeScrap() {
        return switch (RANDOM.nextInt(6)) {
            case 0 -> new class_1799((class_1935)ModItems.METAL_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 1 -> new class_1799((class_1935)ModItems.ALLOY_SCRAP.get(), 1 + RANDOM.nextInt(3));
            case 2 -> new class_1799((class_1935)ModItems.COPPER_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 3 -> new class_1799((class_1935)ModItems.TECH_SCRAP.get(), 1);
            case 4 -> new class_1799((class_1935)ModItems.FASTENER_SCRAP.get(), 2 + RANDOM.nextInt(4));
            default -> new class_1799((class_1935)ModItems.ALLOY_SCRAP.get(), 1);
        };
    }

    private static class_1799 generateDesertScrap() {
        return switch (RANDOM.nextInt(5)) {
            case 0 -> new class_1799((class_1935)ModItems.TECH_SCRAP.get(), 1 + RANDOM.nextInt(3));
            case 1 -> new class_1799((class_1935)ModItems.CIRCUIT_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 2 -> new class_1799((class_1935)ModItems.GOLD_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 3 -> new class_1799((class_1935)ModItems.ALLOY_SCRAP.get(), 1);
            default -> new class_1799((class_1935)ModItems.TECH_SCRAP.get(), 1 + RANDOM.nextInt(2));
        };
    }

    private static class_1799 generateJungleScrap() {
        return switch (RANDOM.nextInt(5)) {
            case 0 -> new class_1799((class_1935)ModItems.BIO_SCRAP.get(), 2 + RANDOM.nextInt(3));
            case 1 -> new class_1799((class_1935)ModItems.WOOD_SCRAP.get(), 1 + RANDOM.nextInt(3));
            case 2 -> new class_1799((class_1935)ModItems.FIBER_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 3 -> new class_1799((class_1935)ModItems.ALLOY_SCRAP.get(), 1);
            default -> new class_1799((class_1935)ModItems.BIO_SCRAP.get(), 1 + RANDOM.nextInt(2));
        };
    }

    private static class_1799 generateForestScrap() {
        return switch (RANDOM.nextInt(6)) {
            case 0 -> new class_1799((class_1935)ModItems.METAL_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 1 -> new class_1799((class_1935)ModItems.TECH_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 2 -> new class_1799((class_1935)ModItems.WOOD_SCRAP.get(), 1 + RANDOM.nextInt(3));
            case 3 -> new class_1799((class_1935)ModItems.IRON_SCRAP.get(), 1);
            case 4 -> new class_1799((class_1935)ModItems.COPPER_SCRAP.get(), 1);
            default -> new class_1799((class_1935)ModItems.ALLOY_SCRAP.get(), 1);
        };
    }

    private static class_1799 generateMountainScrap() {
        return switch (RANDOM.nextInt(6)) {
            case 0 -> new class_1799((class_1935)ModItems.METAL_SCRAP.get(), 2 + RANDOM.nextInt(3));
            case 1 -> new class_1799((class_1935)ModItems.IRON_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 2 -> new class_1799((class_1935)ModItems.COPPER_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 3 -> new class_1799((class_1935)ModItems.MINERAL_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 4 -> new class_1799((class_1935)ModItems.GOLD_SCRAP.get(), 1);
            default -> new class_1799((class_1935)ModItems.METAL_SCRAP.get(), 1 + RANDOM.nextInt(2));
        };
    }

    private static class_1799 generateSwampScrap() {
        return switch (RANDOM.nextInt(5)) {
            case 0 -> new class_1799((class_1935)ModItems.ALLOY_SCRAP.get(), 2 + RANDOM.nextInt(4));
            case 1 -> new class_1799((class_1935)ModItems.BIO_SCRAP.get(), 1 + RANDOM.nextInt(3));
            case 2 -> new class_1799((class_1935)ModItems.FASTENER_SCRAP.get(), 1 + RANDOM.nextInt(4));
            case 3 -> new class_1799((class_1935)ModItems.RUBBER_SCRAP.get(), 1 + RANDOM.nextInt(2));
            default -> new class_1799((class_1935)ModItems.ALLOY_SCRAP.get(), 1 + RANDOM.nextInt(3));
        };
    }

    private static class_1799 generateNetherScrap() {
        return switch (RANDOM.nextInt(5)) {
            case 0 -> new class_1799((class_1935)ModItems.TECH_SCRAP.get(), 2 + RANDOM.nextInt(3));
            case 1 -> new class_1799((class_1935)ModItems.GOLD_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 2 -> new class_1799((class_1935)ModItems.COIL_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 3 -> new class_1799((class_1935)class_1802.field_22021, 1);
            default -> new class_1799((class_1935)ModItems.TECH_SCRAP.get(), 1 + RANDOM.nextInt(2));
        };
    }

    private static class_1799 generateEndScrap() {
        return switch (RANDOM.nextInt(5)) {
            case 0 -> new class_1799((class_1935)ModItems.TECH_SCRAP.get(), 2 + RANDOM.nextInt(4));
            case 1 -> new class_1799((class_1935)ModItems.CRYSTAL_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 2 -> new class_1799((class_1935)ModItems.LUMINOUS_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 3 -> new class_1799((class_1935)ModItems.ENERGY_CELL_SCRAP.get(), 1);
            default -> new class_1799((class_1935)ModItems.TECH_SCRAP.get(), 1 + RANDOM.nextInt(3));
        };
    }

    private static class_1799 generateGenericScrap() {
        return switch (RANDOM.nextInt(6)) {
            case 0 -> new class_1799((class_1935)ModItems.METAL_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 1 -> new class_1799((class_1935)ModItems.TECH_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 2 -> new class_1799((class_1935)ModItems.ALLOY_SCRAP.get(), 1 + RANDOM.nextInt(3));
            case 3 -> new class_1799((class_1935)ModItems.FASTENER_SCRAP.get(), 1 + RANDOM.nextInt(3));
            case 4 -> new class_1799((class_1935)ModItems.WOOD_SCRAP.get(), 1 + RANDOM.nextInt(2));
            default -> new class_1799((class_1935)ModItems.ALLOY_SCRAP.get(), 1 + RANDOM.nextInt(2));
        };
    }
}

