/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.menu;

import de.markusbordihn.scraptechworkshop.block.entity.recycler.RecyclerBlockEntity;
import de.markusbordihn.scraptechworkshop.block.recycler.RecyclerBlock;
import de.markusbordihn.scraptechworkshop.data.recycler.RecyclerStatus;
import de.markusbordihn.scraptechworkshop.menu.slots.DummySlot;
import de.markusbordihn.scraptechworkshop.menu.slots.RecyclerInputSlot;
import de.markusbordihn.scraptechworkshop.menu.slots.RecyclerOutputSlot;
import de.markusbordihn.scraptechworkshop.menu.slots.RecyclerUpgradeSlot;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecyclerMenu
extends class_1703 {
    public static final int INPUT_SLOT_X = 26;
    public static final int INPUT_SLOT_Y = 35;
    public static final int SLOT_SPACING = 18;
    public static final int OUTPUT_GRID_START_X = 116;
    public static final int OUTPUT_GRID_START_Y = 17;
    public static final int OUTPUT_GRID_ROWS = 3;
    public static final int OUTPUT_GRID_COLUMNS = 3;
    public static final int UPGRADE_SLOT_START_X = 62;
    public static final int UPGRADE_SLOT_Y = 71;
    public static final int PLAYER_INVENTORY_START_X = 8;
    public static final int PLAYER_INVENTORY_START_Y = 124;
    public static final int PLAYER_INVENTORY_ROWS = 3;
    public static final int PLAYER_INVENTORY_COLUMNS = 9;
    public static final int PLAYER_HOTBAR_START_X = 8;
    public static final int PLAYER_HOTBAR_START_Y = 182;
    public static final int PLAYER_HOTBAR_SLOTS = 9;
    public static final int PROGRESS_ARROW_SIZE = 26;
    public static final int CONTAINER_DATA_SIZE = 2;
    public static final int PROGRESS_DATA_INDEX = 0;
    public static final int MAX_PROGRESS_DATA_INDEX = 1;
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String LOG_PREFIX = "[RECYCLER]";
    public static class_3917<RecyclerMenu> TYPE;
    private final RecyclerBlockEntity blockEntity;
    private final class_1937 level;
    private final class_3913 data;
    private final class_1277 dummyContainer;
    private final class_2338 blockPos;

    public RecyclerMenu(int windowId, class_1661 playerInventory, class_2540 additionalData) {
        this(windowId, playerInventory, RecyclerMenu.getBlockEntityFromData(playerInventory, additionalData), (class_3913)new class_3919(2));
    }

    public RecyclerMenu(int windowId, class_1661 playerInventory, class_2586 entity, class_3913 data) {
        super(TYPE, windowId);
        this.level = playerInventory.field_7546.method_37908();
        this.data = data != null ? data : new class_3919(2);
        this.dummyContainer = new class_1277(12);
        if (entity instanceof RecyclerBlockEntity) {
            RecyclerBlockEntity recyclerEntity;
            this.blockEntity = recyclerEntity = (RecyclerBlockEntity)entity;
            this.blockPos = recyclerEntity.method_11016();
        } else {
            log.error("{} Expected RecyclerBlockEntity but got {} at {}", (Object)LOG_PREFIX, (Object)entity, entity != null ? entity.method_11016() : "NULL");
            this.blockEntity = null;
            this.blockPos = null;
        }
        RecyclerMenu.method_17359((class_1263)playerInventory, (int)12);
        this.addRecyclerSlots();
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        this.method_17360(this.data);
    }

    private static class_2586 getBlockEntityFromData(class_1661 playerInventory, class_2540 additionalData) {
        if (additionalData == null) {
            log.error("{} additionalData is NULL", (Object)LOG_PREFIX);
            return null;
        }
        try {
            class_2338 pos = additionalData.method_10811();
            class_1937 level = playerInventory.field_7546.method_37908();
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity == null) {
                log.error("{} BlockEntity is NULL at {}", (Object)LOG_PREFIX, (Object)pos);
                return null;
            }
            return blockEntity;
        }
        catch (Exception e) {
            log.error("{} Error reading BlockEntity from additionalData: {}", (Object)LOG_PREFIX, (Object)e.getMessage());
            return null;
        }
    }

    private void addRecyclerSlots() {
        RecyclerBlockEntity entityToUse = this.getValidBlockEntity();
        if (entityToUse != null) {
            this.method_7621(new RecyclerInputSlot(entityToUse, 0, 26, 35));
            int outputStartIndex = 1;
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    this.method_7621(new RecyclerOutputSlot(entityToUse, outputStartIndex++, 116 + col * 18, 17 + row * 18));
                }
            }
            this.method_7621(new RecyclerUpgradeSlot(entityToUse, 10, 62, 71));
            this.method_7621(new RecyclerUpgradeSlot(entityToUse, 11, 80, 71));
        } else {
            for (int i = 0; i < 12; ++i) {
                this.method_7621(new DummySlot((class_1263)this.dummyContainer, i, -1000, -1000));
            }
        }
    }

    private RecyclerBlockEntity getValidBlockEntity() {
        class_2586 entity;
        if (this.blockEntity != null) {
            return this.blockEntity;
        }
        if (this.blockPos != null && this.level != null && (entity = this.level.method_8321(this.blockPos)) instanceof RecyclerBlockEntity) {
            RecyclerBlockEntity recyclerEntity = (RecyclerBlockEntity)entity;
            log.debug("{} Resolved BlockEntity on delayed lookup", (Object)LOG_PREFIX);
            return recyclerEntity;
        }
        return null;
    }

    private void addPlayerInventory(class_1661 playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.method_7621(new class_1735((class_1263)playerInventory, col + row * 9 + 9, 8 + col * 18, 124 + row * 18));
            }
        }
    }

    private void addPlayerHotbar(class_1661 playerInventory) {
        for (int col = 0; col < 9; ++col) {
            this.method_7621(new class_1735((class_1263)playerInventory, col, 8 + col * 18, 182));
        }
    }

    public class_1799 getCurrentInput() {
        return this.blockEntity != null ? this.blockEntity.method_5438(0) : class_1799.field_8037;
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            itemStack = slotStack.method_7972();
            int playerInventoryEnd = 39;
            int playerHotbarEnd = playerInventoryEnd + 9;
            if (this.blockEntity != null) {
                int inputEnd = 1;
                int outputEnd = inputEnd + 9;
                int upgradeEnd = outputEnd + 2;
                if (index < inputEnd ? !this.method_7616(slotStack, 12, playerHotbarEnd, false) : (index < outputEnd ? !this.method_7616(slotStack, 12, playerHotbarEnd, false) : (index < upgradeEnd ? !this.method_7616(slotStack, 12, playerHotbarEnd, false) : (index < playerInventoryEnd ? !this.method_7616(slotStack, 0, inputEnd, false) && !this.method_7616(slotStack, outputEnd, upgradeEnd, false) && !this.method_7616(slotStack, playerInventoryEnd, playerHotbarEnd, false) : index < playerHotbarEnd && !this.method_7616(slotStack, 0, inputEnd, false) && !this.method_7616(slotStack, outputEnd, upgradeEnd, false) && !this.method_7616(slotStack, 12, playerInventoryEnd, false))))) {
                    return class_1799.field_8037;
                }
            } else if (index < playerInventoryEnd ? !this.method_7616(slotStack, playerInventoryEnd, playerHotbarEnd, false) : index < playerHotbarEnd && !this.method_7616(slotStack, 12, playerInventoryEnd, false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return itemStack;
    }

    public boolean method_7597(class_1657 player) {
        if (this.blockEntity == null) {
            return false;
        }
        return RecyclerMenu.method_17695((class_3914)class_3914.method_17392((class_1937)this.level, (class_2338)this.blockEntity.method_11016()), (class_1657)player, (class_2248)this.blockEntity.method_11010().method_26204());
    }

    public boolean isCrafting() {
        return this.data.method_17390(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.method_17390(0);
        int maxProgress = this.data.method_17390(1);
        return maxProgress != 0 && progress != 0 ? progress * 26 / maxProgress : 0;
    }

    public RecyclerBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public RecyclerStatus getRecyclerStatus() {
        if (this.blockEntity == null || this.blockEntity.method_10997() == null) {
            return RecyclerStatus.IDLE;
        }
        return (RecyclerStatus)((Object)this.blockEntity.method_11010().method_11654(RecyclerBlock.STATUS));
    }
}

