/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.scrap;

import de.markusbordihn.scraptechworkshop.block.scrap.ScrapPileCollector;
import de.markusbordihn.scraptechworkshop.block.scrap.ScrapPileCooldownManager;
import de.markusbordihn.scraptechworkshop.block.scrap.ScrapPileDecay;
import de.markusbordihn.scraptechworkshop.block.scrap.ScrapPileMerger;
import de.markusbordihn.scraptechworkshop.config.ScrapPileConfig;
import de.markusbordihn.scraptechworkshop.data.ScrapPileVariant;
import de.markusbordihn.scraptechworkshop.loot.ScrapLootTables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ScrapPileBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final String ID = "scrap_pile";
    public static final IntegerProperty SIZE = IntegerProperty.m_61631_((String)"size", (int)1, (int)4);
    public static final EnumProperty<ScrapPileVariant> VARIANT = EnumProperty.m_61587_((String)"variant", ScrapPileVariant.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_SIZE_1 = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    private static final VoxelShape SHAPE_SIZE_2 = Block.m_49796_((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)4.0, (double)14.5);
    private static final VoxelShape SHAPE_SIZE_3 = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
    private static final VoxelShape SHAPE_SIZE_4 = Block.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)4.0, (double)15.5);

    public ScrapPileBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SIZE, (Comparable)Integer.valueOf(1))).m_61124_(VARIANT, (Comparable)((Object)ScrapPileVariant.MIXED))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    private static VoxelShape getShapeForSize(int size) {
        return switch (size) {
            case 2 -> SHAPE_SIZE_2;
            case 3 -> SHAPE_SIZE_3;
            case 4 -> SHAPE_SIZE_4;
            default -> SHAPE_SIZE_1;
        };
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ItemStack tool = (ItemStack)builder.m_287159_(LootContextParams.f_81463_);
        if (tool != null && ScrapPileConfig.silkTouchEnabled && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) > 0) {
            return Collections.singletonList(new ItemStack((ItemLike)this.m_5456_()));
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ScrapPileVariant variant = (ScrapPileVariant)((Object)state.m_61143_(VARIANT));
        int size = (Integer)state.m_61143_((Property)SIZE);
        RandomSource random = RandomSource.m_216327_();
        int fortuneLevel = 0;
        if (tool != null && ScrapPileConfig.fortuneEnabled) {
            fortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool);
        }
        for (int i = 0; i < size; ++i) {
            ItemStack scrap = ScrapLootTables.generateRandomScrap(variant, random);
            if (scrap.m_41619_()) continue;
            drops.add(scrap);
            for (int j = 0; j < fortuneLevel; ++j) {
                if (!(random.m_188501_() < 0.33f)) continue;
                drops.add(scrap.m_41777_());
            }
        }
        return drops;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ScrapPileBlock.getShapeForSize((Integer)state.m_61143_((Property)SIZE));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ScrapPileBlock.getShapeForSize((Integer)state.m_61143_((Property)SIZE));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            if (player.m_6144_()) {
                return ScrapPileConfig.autoMergeEnabled && ScrapPileMerger.attemptMergeWithNeighbors(level, pos, state) ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
            ScrapPileCollector.handleScrapCollection(level, pos, state, player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            if (ScrapPileConfig.autoPickupEnabled && (ScrapPileConfig.autoPickupDelayTicks == 0 || !ScrapPileCooldownManager.isPlayerOnCooldown(player))) {
                if ((Integer)state.m_61143_((Property)SIZE) == 1 || ScrapPileConfig.autoPickupDelayTicks == 0) {
                    while (level.m_8055_(pos).m_60734_() == this) {
                        ScrapPileCollector.handleScrapCollection(level, pos, level.m_8055_(pos), player);
                    }
                } else {
                    ScrapPileCollector.handleScrapCollection(level, pos, state, player);
                }
                if (ScrapPileConfig.autoPickupDelayTicks > 0) {
                    ScrapPileCooldownManager.setPlayerCooldown(player);
                }
            }
        }
        super.m_141947_(level, pos, state, entity);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)SIZE, (Comparable)Integer.valueOf(1))).m_61124_(VARIANT, (Comparable)((Object)ScrapPileVariant.MIXED))).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.f_46443_ && !isMoving && oldState.m_60734_() != this && ScrapPileConfig.autoMergeEnabled) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (ScrapPileConfig.autoMergeEnabled) {
            ScrapPileMerger.attemptMergeWithNeighbors((Level)level, pos, state);
        }
    }

    public boolean m_6724_(BlockState state) {
        return ScrapPileConfig.decayEnabled;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (ScrapPileConfig.decayEnabled && random.m_188503_(ScrapPileConfig.decayChance) == 0) {
            ScrapPileDecay.handleDecay(state, level, pos, random);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return state;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SIZE, VARIANT, FACING, WATERLOGGED});
    }
}

