/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.config;

import de.markusbordihn.scraptechworkshop.config.Config;
import java.io.File;
import java.util.Properties;

public class CollectorStationConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "collector_station.cfg";
    public static final String CONFIG_FILE_HEADER = " Collector Station Configuration\n\n This configuration file allows you to define the general settings for Collector Stations.\n collectionRadius: Radius in blocks where the robot will collect scraps (default: 16)\n collectingTime: Time in ticks for robot to collect scrap (default: 12000 = 10 minutes)\n returningTime: Time in ticks for robot to return with scrap (default: 120 = 6 seconds)\n processingTime: Time in ticks to process collected scrap (default: 40 = 2 seconds)\n chargingTime: Time in ticks for robot to charge after returning (default: 1200 = 1 minute)\n checkInterval: Time in ticks between status checks (default: 20 = 1 second)\n energyPerCycle: Energy consumed per collection cycle (default: 100)\n maxStorageSlots: Number of storage slots in the station (default: 24)\n requiresBattery: Whether the station requires a battery to operate (default: true)\n\n";
    public static final int DEFAULT_COLLECTION_RADIUS = 16;
    public static final int DEFAULT_COLLECTING_TIME = 12000;
    public static final int DEFAULT_RETURNING_TIME = 300;
    public static final int DEFAULT_PROCESSING_TIME = 40;
    public static final int DEFAULT_CHARGING_TIME = 1200;
    public static final int DEFAULT_CHECK_INTERVAL = 20;
    public static final int DEFAULT_ENERGY_PER_CYCLE = 100;
    public static final int DEFAULT_MAX_STORAGE_SLOTS = 24;
    public static final boolean DEFAULT_REQUIRES_BATTERY = true;
    public static int collectionRadius = 16;
    public static int collectingTime = 12000;
    public static int returningTime = 300;
    public static int processingTime = 40;
    public static int chargingTime = 1200;
    public static int checkInterval = 20;
    public static int energyPerCycle = 100;
    public static int maxStorageSlots = 24;
    public static boolean requiresBattery = true;

    public static void registerConfig() {
        CollectorStationConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        File configFile = CollectorStationConfig.getConfigFile(CONFIG_FILE_NAME);
        if (configFile == null) {
            return;
        }
        Properties properties = CollectorStationConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        collectionRadius = CollectorStationConfig.parseConfigValue(properties, "collectionRadius", 16);
        collectingTime = CollectorStationConfig.parseConfigValue(properties, "collectingTime", 12000);
        returningTime = CollectorStationConfig.parseConfigValue(properties, "returningTime", 300);
        processingTime = CollectorStationConfig.parseConfigValue(properties, "processingTime", 40);
        chargingTime = CollectorStationConfig.parseConfigValue(properties, "chargingTime", 1200);
        checkInterval = CollectorStationConfig.parseConfigValue(properties, "checkInterval", 20);
        energyPerCycle = CollectorStationConfig.parseConfigValue(properties, "energyPerCycle", 100);
        maxStorageSlots = CollectorStationConfig.parseConfigValue(properties, "maxStorageSlots", 24);
        requiresBattery = CollectorStationConfig.parseConfigValue(properties, "requiresBattery", true);
        CollectorStationConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }
}

