/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.drop;

import de.markusbordihn.scraptechworkshop.config.ScrapDropConfig;
import de.markusbordihn.scraptechworkshop.data.scrap.ScrapDropData;
import de.markusbordihn.scraptechworkshop.data.scrap.ScrapSoundType;
import de.markusbordihn.scraptechworkshop.data.scrap.ScrapType;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ScrapDropHandler {
    private static final Random RANDOM = new Random();
    private static final Map<Block, ScrapType> BLOCK_SCRAP_TYPES = ScrapDropHandler.createBlockScrapTypeMap();

    private static Map<Block, ScrapType> createBlockScrapTypeMap() {
        HashMap<Block, ScrapType> typeMap = new HashMap<Block, ScrapType>();
        typeMap.put(Blocks.f_50334_, ScrapType.METAL);
        typeMap.put(Blocks.f_152550_, ScrapType.METAL);
        typeMap.put(Blocks.f_50228_, ScrapType.METAL);
        typeMap.put(Blocks.f_50122_, ScrapType.METAL);
        typeMap.put(Blocks.f_50069_, ScrapType.METAL);
        typeMap.put(Blocks.f_50322_, ScrapType.GOLD);
        typeMap.put(Blocks.f_50323_, ScrapType.GOLD);
        typeMap.put(Blocks.f_50324_, ScrapType.GOLD);
        typeMap.put(Blocks.f_152467_, ScrapType.GOLD);
        typeMap.put(Blocks.f_50074_, ScrapType.GOLD);
        typeMap.put(Blocks.f_49995_, ScrapType.GOLD);
        typeMap.put(Blocks.f_152468_, ScrapType.IRON);
        typeMap.put(Blocks.f_50075_, ScrapType.IRON);
        typeMap.put(Blocks.f_49996_, ScrapType.IRON);
        typeMap.put(Blocks.f_152598_, ScrapType.IRON);
        typeMap.put(Blocks.f_152504_, ScrapType.COPPER);
        typeMap.put(Blocks.f_152505_, ScrapType.COPPER);
        typeMap.put(Blocks.f_152506_, ScrapType.COPPER);
        typeMap.put(Blocks.f_152503_, ScrapType.COPPER);
        typeMap.put(Blocks.f_152501_, ScrapType.COPPER);
        typeMap.put(Blocks.f_152599_, ScrapType.COPPER);
        typeMap.put(Blocks.f_152502_, ScrapType.COPPER);
        typeMap.put(Blocks.f_50721_, ScrapType.ALLOY);
        typeMap.put(Blocks.f_50259_, ScrapType.ALLOY);
        typeMap.put(Blocks.f_50492_, ScrapType.ALLOY);
        typeMap.put(Blocks.f_50441_, ScrapType.ALLOY);
        typeMap.put(Blocks.f_50443_, ScrapType.ALLOY);
        typeMap.put(Blocks.f_50450_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50056_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50057_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50542_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50543_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50544_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50545_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50494_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50495_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50496_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50497_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50498_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50499_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50500_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50501_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50502_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50503_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50504_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50505_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50287_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50288_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50289_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50290_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50291_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50292_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50293_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50294_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50295_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50296_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50297_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50298_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50299_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50300_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50301_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50302_, ScrapType.INSULATION);
        typeMap.put(Blocks.f_50352_, ScrapType.INSULATION);
        return typeMap;
    }

    public static void handleBlockBreak(ServerLevel serverLevel, BlockPos blockPos, Block brokenBlock) {
        ScrapType scrapType = BLOCK_SCRAP_TYPES.get(brokenBlock);
        if (scrapType == null) {
            return;
        }
        ScrapDropData dropData = ScrapDropHandler.getScrapDropDataForType(scrapType);
        if (dropData == null || !dropData.isEnabled()) {
            return;
        }
        float dropChance = dropData.dropChance() / 100.0f;
        if (RANDOM.nextFloat() < dropChance) {
            ItemStack scrapStack = new ItemStack((ItemLike)dropData.scrapItem(), 1);
            ItemEntity itemEntity = new ItemEntity((Level)serverLevel, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, scrapStack);
            serverLevel.m_7967_((Entity)itemEntity);
            ScrapDropHandler.playDropSound(serverLevel, blockPos, scrapType);
        }
    }

    private static void playDropSound(ServerLevel level, BlockPos pos, ScrapType scrapType) {
        if (!ScrapDropConfig.enableDropSounds || ScrapDropConfig.dropSoundVolume <= 0.0f) {
            return;
        }
        SoundEvent soundEvent = ScrapSoundType.forScrapType(scrapType).getSoundEvent();
        level.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, Math.min(1.0f, ScrapDropConfig.dropSoundVolume), 0.8f + RANDOM.nextFloat() * 0.4f);
    }

    private static ScrapDropData getScrapDropDataForType(ScrapType scrapType) {
        return switch (scrapType) {
            default -> throw new IncompatibleClassChangeError();
            case ScrapType.BIO -> new ScrapDropData(ModItems.BIO_SCRAP.get(), ScrapDropConfig.bioScrapDropChance);
            case ScrapType.CERAMIC -> new ScrapDropData(ModItems.CERAMIC_SCRAP.get(), ScrapDropConfig.ceramicScrapDropChance);
            case ScrapType.COPPER -> new ScrapDropData(ModItems.COPPER_SCRAP.get(), ScrapDropConfig.copperScrapDropChance);
            case ScrapType.CRYSTAL -> new ScrapDropData(ModItems.CRYSTAL_SCRAP.get(), ScrapDropConfig.crystalScrapDropChance);
            case ScrapType.FASTENER -> new ScrapDropData(ModItems.FASTENER_SCRAP.get(), ScrapDropConfig.fastenerScrapDropChance);
            case ScrapType.FIBER -> new ScrapDropData(ModItems.FIBER_SCRAP.get(), ScrapDropConfig.fiberScrapDropChance);
            case ScrapType.GLASS -> new ScrapDropData(ModItems.GLASS_SCRAP.get(), ScrapDropConfig.glassScrapDropChance);
            case ScrapType.GOLD -> new ScrapDropData(ModItems.GOLD_SCRAP.get(), ScrapDropConfig.goldScrapDropChance);
            case ScrapType.IRON -> new ScrapDropData(ModItems.IRON_SCRAP.get(), ScrapDropConfig.ironScrapDropChance);
            case ScrapType.LUMINOUS -> new ScrapDropData(ModItems.LUMINOUS_SCRAP.get(), ScrapDropConfig.luminousScrapDropChance);
            case ScrapType.METAL -> new ScrapDropData(ModItems.METAL_SCRAP.get(), ScrapDropConfig.metalScrapDropChance);
            case ScrapType.MINERAL -> new ScrapDropData(ModItems.MINERAL_SCRAP.get(), ScrapDropConfig.mineralScrapDropChance);
            case ScrapType.PLASTIC -> new ScrapDropData(ModItems.PLASTIC_SCRAP.get(), ScrapDropConfig.plasticScrapDropChance);
            case ScrapType.RUBBER -> new ScrapDropData(ModItems.RUBBER_SCRAP.get(), ScrapDropConfig.rubberScrapDropChance);
            case ScrapType.TECH -> new ScrapDropData(ModItems.TECH_SCRAP.get(), ScrapDropConfig.techScrapDropChance);
            case ScrapType.WOOD -> new ScrapDropData(ModItems.WOOD_SCRAP.get(), ScrapDropConfig.woodScrapDropChance);
            case ScrapType.CIRCUIT -> new ScrapDropData(ModItems.CIRCUIT_SCRAP.get(), ScrapDropConfig.techScrapDropChance);
            case ScrapType.COIL -> new ScrapDropData(ModItems.COIL_SCRAP.get(), ScrapDropConfig.techScrapDropChance);
            case ScrapType.CAPACITOR -> new ScrapDropData(ModItems.CAPACITOR_SCRAP.get(), ScrapDropConfig.techScrapDropChance);
            case ScrapType.ENERGY_CELL -> new ScrapDropData(ModItems.ENERGY_CELL_SCRAP.get(), ScrapDropConfig.techScrapDropChance);
            case ScrapType.ALLOY -> new ScrapDropData(ModItems.ALLOY_SCRAP.get(), ScrapDropConfig.metalScrapDropChance);
            case ScrapType.INSULATION -> new ScrapDropData(ModItems.INSULATION_SCRAP.get(), ScrapDropConfig.plasticScrapDropChance);
        };
    }
}

