/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.processing;

import de.markusbordihn.scraptechworkshop.data.block.StrippableBlocks;
import de.markusbordihn.scraptechworkshop.processing.AxeInteractionHandler;
import de.markusbordihn.scraptechworkshop.processing.ContextAnalyzer;
import de.markusbordihn.scraptechworkshop.processing.DirtPathTransformer;
import de.markusbordihn.scraptechworkshop.processing.FarmlandTransformer;
import de.markusbordihn.scraptechworkshop.processing.HoeInteractionHandler;
import de.markusbordihn.scraptechworkshop.processing.ShovelInteractionHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockInteractionProcessor {
    public static InteractionResult processCycleableBlock(UseOnContext context, BlockState blockState) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Block block = blockState.m_60734_();
        if (StrippableBlocks.isCycleableWood(block)) {
            return AxeInteractionHandler.processCycleableWood(context, blockState);
        }
        if (block == Blocks.f_152481_) {
            return DirtPathTransformer.convertToFarmland(context, level, pos);
        }
        if (block == Blocks.f_50093_) {
            return FarmlandTransformer.convertToGrass(context, level, pos);
        }
        boolean preferHoe = ContextAnalyzer.shouldPreferHoe(level, pos, blockState);
        if (preferHoe) {
            return HoeInteractionHandler.tillGround(context, level, pos, blockState);
        }
        return ShovelInteractionHandler.createPath(context, level, pos, blockState);
    }

    public static boolean isCycleableBlock(Block block) {
        return block == Blocks.f_50440_ || block == Blocks.f_50493_ || block == Blocks.f_50546_ || block == Blocks.f_152549_ || block == Blocks.f_50093_ || block == Blocks.f_152481_ || StrippableBlocks.isCycleableWood(block);
    }
}

