/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.recipe.recycler;

import de.markusbordihn.scraptechworkshop.config.RecyclerConfig;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipeSerializer;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public record RecyclerRecipe(ResourceLocation id, RecyclerMatch match, RecyclerOutput primaryOutput, List<RecyclerByproduct> byproducts, int processTime, int weight) implements Recipe<Container>
{
    private static final int INPUT_SLOT = 0;

    public RecyclerRecipe {
        if (byproducts == null) {
            byproducts = new ArrayList<RecyclerByproduct>();
        }
    }

    public boolean m_5818_(Container container, Level level) {
        if (container.m_7983_()) {
            return false;
        }
        ItemStack inputStack = container.m_8020_(0);
        return !inputStack.m_41619_() && this.match.matches(inputStack);
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess);
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.primaryOutput.createStack();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecyclerRecipeSerializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return RecyclerRecipeType.INSTANCE;
    }

    public boolean matchesInput(ItemStack stack) {
        return this.match.matches(stack);
    }

    public List<ItemStack> getOutputsForInput(ItemStack inputStack) {
        ArrayList<ItemStack> outputs;
        block3: {
            block4: {
                outputs = new ArrayList<ItemStack>();
                outputs.add(this.primaryOutput.createStackForInput(inputStack));
                if (!RecyclerConfig.isMultiByproductMode()) break block4;
                int addedByproducts = 0;
                for (RecyclerByproduct byproduct : this.byproducts) {
                    if (addedByproducts < RecyclerConfig.maxByproductsPerOperation) {
                        if (!byproduct.shouldProduce()) continue;
                        outputs.add(byproduct.createStack());
                        ++addedByproducts;
                        continue;
                    }
                    break block3;
                }
                break block3;
            }
            if (this.byproducts.isEmpty()) break block3;
            for (RecyclerByproduct byproduct : this.byproducts) {
                if (!byproduct.shouldProduce()) continue;
                outputs.add(byproduct.createStack());
                break;
            }
        }
        return outputs;
    }

    public static class RecyclerMatch {
        private final Item item;
        private final TagKey<Item> tag;

        public RecyclerMatch(Item item) {
            this.item = item;
            this.tag = null;
        }

        public RecyclerMatch(TagKey<Item> tag) {
            this.item = null;
            this.tag = tag;
        }

        public boolean matches(ItemStack stack) {
            if (this.item != null) {
                return stack.m_150930_(this.item);
            }
            if (this.tag != null) {
                return stack.m_204117_(this.tag);
            }
            return false;
        }

        public boolean isItemMatch() {
            return this.item != null;
        }

        public Item getItem() {
            return this.item;
        }

        public TagKey<Item> getTag() {
            return this.tag;
        }
    }

    public static class RecyclerOutput {
        private final Item item;
        private final int minCount;
        private final int maxCount;
        private final boolean durabilityScaling;

        public RecyclerOutput(Item item, int count) {
            this(item, count, count, false);
        }

        public RecyclerOutput(Item item, int minCount, int maxCount, boolean durabilityScaling) {
            this.item = item;
            this.minCount = minCount;
            this.maxCount = maxCount;
            this.durabilityScaling = durabilityScaling;
        }

        public ItemStack createStack() {
            int count = this.minCount == this.maxCount ? this.minCount : this.minCount + (int)(Math.random() * (double)(this.maxCount - this.minCount + 1));
            return new ItemStack((ItemLike)this.item, count);
        }

        public ItemStack createStackForInput(ItemStack inputStack) {
            int baseCount;
            int n = baseCount = this.minCount == this.maxCount ? this.minCount : this.minCount + (int)(Math.random() * (double)(this.maxCount - this.minCount + 1));
            if (this.durabilityScaling && RecyclerConfig.durabilityScaling && inputStack.m_41763_()) {
                double durabilityRatio = (double)(inputStack.m_41776_() - inputStack.m_41773_()) / (double)inputStack.m_41776_();
                double scalingFactor = 0.25 + 0.75 * durabilityRatio;
                baseCount = Math.max(1, (int)Math.floor((double)baseCount * scalingFactor));
            }
            return new ItemStack((ItemLike)this.item, baseCount);
        }

        public Item getItem() {
            return this.item;
        }

        public int getMinCount() {
            return this.minCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        public boolean isDurabilityScaling() {
            return this.durabilityScaling;
        }
    }

    public static class RecyclerByproduct {
        private final Item item;
        private final double chance;
        private final int minCount;
        private final int maxCount;

        public RecyclerByproduct(Item item, double chance) {
            this(item, chance, 1, 1);
        }

        public RecyclerByproduct(Item item, double chance, int minCount, int maxCount) {
            this.item = item;
            this.chance = chance;
            this.minCount = minCount;
            this.maxCount = maxCount;
        }

        public boolean shouldProduce() {
            return Math.random() < this.chance;
        }

        public ItemStack createStack() {
            int count = this.minCount == this.maxCount ? this.minCount : this.minCount + (int)(Math.random() * (double)(this.maxCount - this.minCount + 1));
            return new ItemStack((ItemLike)this.item, count);
        }

        public Item getItem() {
            return this.item;
        }

        public double getChance() {
            return this.chance;
        }

        public int getMinCount() {
            return this.minCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }
    }
}

