/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity.recycler;

import de.markusbordihn.scraptechworkshop.block.entity.AbstractWorkshopBlockEntity;
import de.markusbordihn.scraptechworkshop.block.entity.recycler.RecyclerContainer;
import de.markusbordihn.scraptechworkshop.block.entity.recycler.RecyclerState;
import de.markusbordihn.scraptechworkshop.block.entity.recycler.RecyclerTickProcessor;
import de.markusbordihn.scraptechworkshop.block.entity.recycler.RecyclerTickResult;
import de.markusbordihn.scraptechworkshop.block.recycler.RecyclerBlock;
import de.markusbordihn.scraptechworkshop.config.RecyclerConfig;
import de.markusbordihn.scraptechworkshop.data.recycler.RecyclerStatus;
import de.markusbordihn.scraptechworkshop.item.upgrade.SpeedUpgradeItem;
import de.markusbordihn.scraptechworkshop.menu.RecyclerMenu;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RecyclerBlockEntity
extends AbstractWorkshopBlockEntity {
    public static final String ID = "recycler";
    private static final int INPUT_SLOTS = 1;
    private static final int OUTPUT_SLOTS = 9;
    private static final int UPGRADE_SLOTS = 2;
    private static final int TOTAL_SLOTS = 12;
    private static final int FIRST_UPGRADE_SLOT = 10;
    private static final int LAST_UPGRADE_SLOT = 11;
    private static final String PROGRESS_TAG = "Progress";
    private static final String MAX_PROGRESS_TAG = "MaxProgress";
    private static final String NO_RECIPE_TIMER_TAG = "NoRecipeTimer";
    private static final String DONE_TIMER_TAG = "DoneTimer";
    private static final int PROGRESS_DATA_INDEX = 0;
    private static final int MAX_PROGRESS_DATA_INDEX = 1;
    private static final String TRANSLATION_KEY = "container.scrap_tech_workshop.recycler";
    public static BlockEntityType<RecyclerBlockEntity> TYPE;
    private final RecyclerContainer container;
    private int progress = 0;
    private int maxProgress = RecyclerConfig.processTime;
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> RecyclerBlockEntity.this.progress;
                case 1 -> RecyclerBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    RecyclerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    RecyclerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int noRecipeTimer = 0;
    private int doneTimer = 0;
    private RecyclerRecipe currentRecipe = null;
    private int tickCounter = 0;

    public RecyclerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(TYPE, blockPos, blockState);
        this.container = new RecyclerContainer(12, this::m_6596_);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, RecyclerBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        ++blockEntity.tickCounter;
        RecyclerStatus currentStatus = (RecyclerStatus)((Object)blockState.m_61143_(RecyclerBlock.STATUS));
        int speedMultiplier = blockEntity.getSpeedMultiplierBonus();
        RecyclerState recyclerState = new RecyclerState(level, blockPos, blockEntity.container.getItems(), blockEntity.progress, blockEntity.maxProgress, blockEntity.noRecipeTimer, blockEntity.doneTimer, blockEntity.currentRecipe, speedMultiplier);
        RecyclerTickResult result = switch (currentStatus) {
            default -> throw new IncompatibleClassChangeError();
            case RecyclerStatus.NO_RECIPE -> RecyclerTickProcessor.processNoRecipeStatus(recyclerState);
            case RecyclerStatus.DONE -> RecyclerTickProcessor.processDoneStatus(recyclerState);
            case RecyclerStatus.IDLE, RecyclerStatus.WORKING, RecyclerStatus.ERROR -> RecyclerTickProcessor.processActiveStatus(recyclerState, blockState);
        };
        blockEntity.progress = recyclerState.progress;
        blockEntity.noRecipeTimer = recyclerState.noRecipeTimer;
        blockEntity.doneTimer = recyclerState.doneTimer;
        blockEntity.currentRecipe = recyclerState.currentRecipe;
        if (result.newStatus() != currentStatus) {
            RecyclerBlock.updateStatus(level, blockPos, result.newStatus());
        }
        if (result.hasChanged() && blockEntity.tickCounter % RecyclerConfig.progressUpdateInterval == 0) {
            blockEntity.m_6596_();
        }
    }

    public RecyclerContainer getContainer() {
        return this.container;
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.container.getItems();
    }

    protected int getTotalSlots() {
        return 12;
    }

    @Override
    protected WorldlyContainer getContainerDelegate() {
        return this.container;
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.progress = compoundTag.m_128451_(PROGRESS_TAG);
        this.maxProgress = compoundTag.m_128451_(MAX_PROGRESS_TAG);
        this.noRecipeTimer = compoundTag.m_128451_(NO_RECIPE_TIMER_TAG);
        this.doneTimer = compoundTag.m_128451_(DONE_TIMER_TAG);
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128405_(PROGRESS_TAG, this.progress);
        compoundTag.m_128405_(MAX_PROGRESS_TAG, this.maxProgress);
        compoundTag.m_128405_(NO_RECIPE_TIMER_TAG, this.noRecipeTimer);
        compoundTag.m_128405_(DONE_TIMER_TAG, this.doneTimer);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)TRANSLATION_KEY);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new RecyclerMenu(windowId, playerInventory, this, this.containerData);
    }

    public int getRedstoneSignal() {
        if (this.maxProgress <= 0) {
            return 0;
        }
        return this.progress * 15 / this.maxProgress;
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    private void syncToClient() {
        Level currentLevel = this.m_58904_();
        if (currentLevel != null && !currentLevel.f_46443_) {
            currentLevel.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.syncToClient();
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private int getSpeedMultiplierBonus() {
        int totalMultiplier = 1;
        for (int i = 10; i <= 11; ++i) {
            Item item;
            ItemStack stack = this.container.m_8020_(i);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof SpeedUpgradeItem)) continue;
            SpeedUpgradeItem speedUpgrade = (SpeedUpgradeItem)item;
            totalMultiplier += speedUpgrade.getSpeedMultiplier() - 1;
        }
        return totalMultiplier;
    }
}

