/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.model.robot;

import de.markusbordihn.scraptechworkshop.client.model.robot.BaseRobotModel;
import de.markusbordihn.scraptechworkshop.data.collectorstation.CollectorStationStatus;
import de.markusbordihn.scraptechworkshop.entity.robot.BaseRobotEntity;
import de.markusbordihn.scraptechworkshop.entity.robot.collectorstationrobot.CollectorStationRobotEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;

public class CollectorStationRobotModel<T extends BaseRobotEntity>
extends BaseRobotModel<T> {
    public CollectorStationRobotModel(ModelPart root) {
        super(root);
    }

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (!(entity instanceof CollectorStationRobotEntity)) {
            return;
        }
        CollectorStationRobotEntity collectorStationRobotEntity = (CollectorStationRobotEntity)((Object)entity);
        CollectorStationStatus status = collectorStationRobotEntity.getStatus();
        if (status == CollectorStationStatus.NO_POWER || status == CollectorStationStatus.NO_STORAGE) {
            this.left_arm.f_104203_ = 0.4f;
            this.right_arm.f_104203_ = 0.4f;
            return;
        }
        if (collectorStationRobotEntity.isDigging()) {
            float diggingSpeed = ageInTicks * 0.8f;
            float leftHandRotation = Mth.m_14031_((float)diggingSpeed) * 0.5f;
            float rightHandRotation = Mth.m_14031_((float)(diggingSpeed + (float)Math.PI)) * 0.5f;
            this.left_hand.f_104204_ = leftHandRotation;
            this.right_hand.f_104204_ = rightHandRotation;
            this.left_hand.f_104205_ = leftHandRotation * 0.3f;
            this.right_hand.f_104205_ = rightHandRotation * 0.3f;
            return;
        }
        this.left_hand.f_104203_ = 0.0f;
        this.left_hand.f_104204_ = 0.0f;
        this.left_hand.f_104205_ = 0.0f;
        this.right_hand.f_104203_ = 0.0f;
        this.right_hand.f_104204_ = 0.0f;
        this.right_hand.f_104205_ = 0.0f;
        if (collectorStationRobotEntity.isMovingFromGoal()) {
            float bodyRotation;
            float wheelRotation = ageInTicks * 0.5f;
            float armSwing = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.6f;
            for (bodyRotation = ((BaseRobotEntity)((Object)entity)).f_20883_ - ((BaseRobotEntity)((Object)entity)).f_20884_; bodyRotation > 180.0f; bodyRotation -= 360.0f) {
            }
            while (bodyRotation < -180.0f) {
                bodyRotation += 360.0f;
            }
            float rotationEffect = bodyRotation * 0.2f;
            this.left_front_wheel.f_104203_ = wheelRotation + rotationEffect;
            this.left_back_wheel.f_104203_ = wheelRotation + rotationEffect;
            this.right_front_wheel.f_104203_ = wheelRotation - rotationEffect;
            this.right_back_wheel.f_104203_ = wheelRotation - rotationEffect;
            this.left_arm.f_104203_ = Mth.m_14036_((float)armSwing, (float)-0.087f, (float)0.436f);
            this.right_arm.f_104203_ = Mth.m_14036_((float)(-armSwing), (float)-0.087f, (float)0.436f);
        }
    }
}

