/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.item.tool;

import de.markusbordihn.scraptechworkshop.config.MultitoolConfig;
import de.markusbordihn.scraptechworkshop.data.block.StrippableBlocks;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyData;
import de.markusbordihn.scraptechworkshop.data.multitool.DisplayMode;
import de.markusbordihn.scraptechworkshop.data.multitool.ScrapMultitoolData;
import de.markusbordihn.scraptechworkshop.data.multitool.ToolMode;
import de.markusbordihn.scraptechworkshop.energy.EnergyCellConsumer;
import de.markusbordihn.scraptechworkshop.energy.EnergyManager;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.item.tool.ToolModeDetector;
import de.markusbordihn.scraptechworkshop.menu.MenuManager;
import de.markusbordihn.scraptechworkshop.processing.AxeInteractionHandler;
import de.markusbordihn.scraptechworkshop.processing.BlockInteractionProcessor;
import de.markusbordihn.scraptechworkshop.processing.ShovelInteractionHandler;
import de.markusbordihn.scraptechworkshop.processing.SwordInteractionHandler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ScrapMultitoolItem
extends DiggerItem
implements EnergyCellConsumer {
    public ScrapMultitoolItem(Item.Properties properties) {
        super(4.0f, -2.4f, (Tier)Tiers.IRON, BlockTags.f_144282_, properties.m_41503_(MultitoolConfig.energyMax).m_41497_(Rarity.RARE));
    }

    @Override
    public int getMaxEnergy() {
        return MultitoolConfig.energyMax;
    }

    public void m_7836_(ItemStack itemStack, Level level, Player player) {
        super.m_7836_(itemStack, level, player);
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        if (!data.hasBattery()) {
            ItemStack battery = new ItemStack((ItemLike)ModItems.SLIGHTLY_DAMAGED_ENERGY_CELL.get());
            Item item = battery.m_41720_();
            if (item instanceof EnergyCellItem) {
                EnergyCellItem energyCell = (EnergyCellItem)item;
                energyCell.setEnergy(battery, 2500);
            }
            data = data.withBattery(battery);
            data.saveToItemStack(itemStack);
            this.syncEnergyDisplay(itemStack);
            DisplayMode displayMode = new DisplayMode(itemStack);
            displayMode.updateModel(ToolMode.fromId(data.activeMode()), data.getBatteryLevel());
        }
    }

    public float m_8102_(ItemStack itemStack, BlockState state) {
        boolean isEffective;
        ToolModeDetector detector = new ToolModeDetector(itemStack);
        detector.updateToolMode(null, state);
        if (!this.hasEnergy(itemStack, MultitoolConfig.energyPerBlock)) {
            return 1.0f;
        }
        ToolMode mode = detector.getToolModeForBlock(state);
        if (mode != ToolMode.NONE) {
            return this.getPoweredSpeed(mode);
        }
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        ToolMode activeToolMode = ToolMode.fromId(data.activeMode());
        switch (activeToolMode) {
            case PICKAXE: {
                boolean bl = state.m_204336_(BlockTags.f_144282_);
                break;
            }
            case AXE: {
                boolean bl = state.m_204336_(BlockTags.f_144280_);
                break;
            }
            case SHOVEL: {
                boolean bl = state.m_204336_(BlockTags.f_144283_);
                break;
            }
            case HOE: {
                boolean bl = state.m_204336_(BlockTags.f_144281_);
                break;
            }
            default: {
                boolean bl = isEffective = state.m_204336_(BlockTags.f_144282_);
            }
        }
        if (isEffective) {
            return this.getPoweredSpeed(activeToolMode);
        }
        return super.m_8102_(itemStack, state);
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        ScrapMultitoolData data;
        if (attacker instanceof Player) {
            data = ScrapMultitoolData.fromItemStack(itemStack);
            if (!ToolMode.SWORD.getId().equals(data.activeMode())) {
                ScrapMultitoolData newData = data.withActiveMode(ToolMode.SWORD.getId());
                newData.saveToItemStack(itemStack);
                DisplayMode displayMode = new DisplayMode(itemStack);
                displayMode.updateModel(ToolMode.SWORD, newData.getBatteryLevel());
            }
        }
        data = ScrapMultitoolData.fromItemStack(itemStack);
        return this.consumeEnergy(itemStack, MultitoolConfig.energyPerAttack);
    }

    public boolean m_6813_(ItemStack itemStack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        ToolModeDetector detector;
        Player player;
        if (entity instanceof Player) {
            player = (Player)entity;
            detector = new ToolModeDetector(itemStack);
            detector.updateToolMode(player, state);
        }
        if (this.consumeEnergy(itemStack, MultitoolConfig.energyPerBlock)) {
            if (entity instanceof Player) {
                player = (Player)entity;
                detector = new ToolModeDetector(itemStack);
                detector.updateToolMode(player, state);
            }
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_6144_() && !level.f_46443_) {
            this.openMultitoolScreen(player, itemStack, hand);
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.f_46443_);
        }
        if (!level.f_46443_) {
            ToolModeDetector detector = new ToolModeDetector(itemStack);
            BlockState targetBlock = detector.getTargetBlock(level, player);
            detector.updateToolMode(player, targetBlock);
        }
        if (!level.f_46443_ && this.hasEnergy(itemStack, MultitoolConfig.energyPerUse)) {
            Vec3 playerPos = player.m_20182_().m_82520_(0.0, 1.0, 0.0);
            Vec3 lookDirection = player.m_20154_();
            Vec3 particlePos = playerPos.m_82549_(lookDirection.m_82490_(1.5));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 5, 0.1, 0.1, 0.1, 0.02);
            }
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11739_, SoundSource.PLAYERS, 0.5f, 1.2f);
            this.consumeEnergy(itemStack, MultitoolConfig.energyPerUse);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player != null && player.m_6144_()) {
            return InteractionResult.PASS;
        }
        ItemStack itemStack = context.m_43722_();
        if (!this.hasEnergy(itemStack, MultitoolConfig.energyPerUse)) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        ToolMode activeMode = ToolMode.fromId(data.activeMode());
        InteractionResult result = InteractionResult.PASS;
        ToolMode usedMode = null;
        if (BlockInteractionProcessor.isCycleableBlock(block) && context.m_43719_() != Direction.DOWN) {
            result = BlockInteractionProcessor.processCycleableBlock(context, state);
            if (result.m_19077_()) {
                usedMode = StrippableBlocks.isCycleableWood(block) ? ToolMode.AXE : (block == Blocks.f_152481_ || state.m_60734_() == Blocks.f_50093_ ? ToolMode.HOE : ToolMode.SHOVEL);
            }
        } else {
            switch (activeMode) {
                case AXE: {
                    usedMode = ToolMode.AXE;
                    InteractionResult interactionResult = AxeInteractionHandler.processAxeInteraction(context);
                    break;
                }
                case SHOVEL: {
                    usedMode = ToolMode.SHOVEL;
                    InteractionResult interactionResult = ShovelInteractionHandler.processInteraction(context);
                    break;
                }
                case SWORD: {
                    usedMode = ToolMode.SWORD;
                    InteractionResult interactionResult = SwordInteractionHandler.processInteraction(context);
                    break;
                }
                default: {
                    InteractionResult interactionResult = result = InteractionResult.PASS;
                }
            }
            if (result == InteractionResult.PASS && activeMode != ToolMode.AXE && (result = AxeInteractionHandler.processAxeInteraction(context)) != InteractionResult.PASS) {
                usedMode = ToolMode.AXE;
            }
            if (result == InteractionResult.PASS && activeMode != ToolMode.SHOVEL && (result = ShovelInteractionHandler.processInteraction(context)) != InteractionResult.PASS) {
                usedMode = ToolMode.SHOVEL;
            }
            if (result == InteractionResult.PASS && activeMode != ToolMode.SWORD && (result = SwordInteractionHandler.processInteraction(context)) != InteractionResult.PASS) {
                usedMode = ToolMode.SWORD;
            }
        }
        if (result.m_19077_() && usedMode != null && usedMode != activeMode) {
            ScrapMultitoolData newData = data.withActiveMode(usedMode.getId());
            newData.saveToItemStack(itemStack);
            DisplayMode displayMode = new DisplayMode(itemStack);
            displayMode.updateModel(usedMode, newData.getBatteryLevel());
            this.consumeEnergy(itemStack, MultitoolConfig.energyPerUse);
        } else if (result.m_19077_()) {
            this.consumeEnergy(itemStack, MultitoolConfig.energyPerUse);
        }
        return result != InteractionResult.PASS ? result : super.m_6225_(context);
    }

    private float getPoweredSpeed(ToolMode toolMode) {
        return switch (toolMode) {
            case ToolMode.PICKAXE -> 6.0f;
            case ToolMode.AXE -> 6.0f;
            case ToolMode.SHOVEL -> 6.0f;
            case ToolMode.HOE -> 4.0f;
            case ToolMode.SWORD -> 6.0f;
            default -> 6.0f;
        };
    }

    private void openMultitoolScreen(Player player, ItemStack itemStack, InteractionHand interactionHand) {
        MenuManager.openMenu(player, itemStack, interactionHand);
    }

    public boolean m_142522_(ItemStack itemStack) {
        return true;
    }

    public int m_142159_(ItemStack itemStack) {
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        if (!data.hasBattery()) {
            return 0xFF0000;
        }
        EnergyData energyData = EnergyManager.getEnergyData(itemStack, MultitoolConfig.energyMax);
        float energyRatio = energyData.getPercentage();
        return energyRatio > 0.6f ? 65280 : (energyRatio > 0.3f ? 0xFFFF00 : 0xFF0000);
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"item.scrap_tech_workshop.scrap_multitool.description"));
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        if (!data.hasBattery()) {
            tooltipComponents.add((Component)Component.m_237113_((String)"Energy: 0%").m_130938_(style -> style.m_178520_(0xFF0000)));
            tooltipComponents.add((Component)Component.m_237113_((String)"Battery: Not installed").m_130938_(style -> style.m_178520_(0xFF0000)));
        } else {
            EnergyData energyData = EnergyManager.getEnergyData(itemStack, MultitoolConfig.energyMax);
            int displayEnergy = energyData.getDisplayEnergy();
            tooltipComponents.add((Component)Component.m_237113_((String)("Energy: " + displayEnergy + "%")).m_130938_(style -> style.m_178520_(this.m_142159_(itemStack))));
            tooltipComponents.add((Component)Component.m_237113_((String)"Battery: Installed").m_130938_(style -> style.m_178520_(65280)));
        }
        ToolMode activeMode = ToolMode.fromId(data.activeMode());
        tooltipComponents.add((Component)Component.m_237115_((String)activeMode.getTranslationKey()).m_130938_(style -> style.m_178520_(activeMode.getColor())));
        tooltipComponents.add((Component)Component.m_237113_((String)"Shift + Right-click to configure").m_130938_(style -> style.m_131155_(Boolean.valueOf(true))));
        super.m_7373_(itemStack, level, tooltipComponents, isAdvanced);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean m_8120_(ItemStack itemStack) {
        return false;
    }
}

