/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.deco;

import de.markusbordihn.scraptechworkshop.block.MultiPlaceBlock;
import de.markusbordihn.scraptechworkshop.item.ModBlockItems;
import de.markusbordihn.scraptechworkshop.item.tool.ScrapMultitoolItem;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NeonTubeBlock
extends MultiPlaceBlock {
    public static final String ID = "neon_tube";
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty HORIZONTAL = BooleanProperty.m_61465_((String)"horizontal");
    private static final VoxelShape SHAPE_FLOOR_NORTH = Block.m_49796_((double)6.5, (double)0.0, (double)0.0, (double)9.5, (double)3.0, (double)16.0);
    private static final VoxelShape SHAPE_FLOOR_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)6.5, (double)16.0, (double)3.0, (double)9.5);
    private static final VoxelShape SHAPE_CEILING_NORTH = Block.m_49796_((double)6.5, (double)13.0, (double)0.0, (double)9.5, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_CEILING_WEST = Block.m_49796_((double)0.0, (double)13.0, (double)6.5, (double)16.0, (double)16.0, (double)9.5);
    private static final VoxelShape SHAPE_WALL_NORTH_VERTICAL = Block.m_49796_((double)6.5, (double)0.0, (double)13.0, (double)9.5, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WALL_SOUTH_VERTICAL = Block.m_49796_((double)6.5, (double)0.0, (double)0.0, (double)9.5, (double)16.0, (double)3.0);
    private static final VoxelShape SHAPE_WALL_WEST_VERTICAL = Block.m_49796_((double)13.0, (double)0.0, (double)6.5, (double)16.0, (double)16.0, (double)9.5);
    private static final VoxelShape SHAPE_WALL_EAST_VERTICAL = Block.m_49796_((double)0.0, (double)0.0, (double)6.5, (double)3.0, (double)16.0, (double)9.5);
    private static final VoxelShape SHAPE_WALL_NORTH_HORIZONTAL = Block.m_49796_((double)0.0, (double)6.5, (double)13.0, (double)16.0, (double)9.5, (double)16.0);
    private static final VoxelShape SHAPE_WALL_SOUTH_HORIZONTAL = Block.m_49796_((double)0.0, (double)6.5, (double)0.0, (double)16.0, (double)9.5, (double)3.0);
    private static final VoxelShape SHAPE_WALL_WEST_HORIZONTAL = Block.m_49796_((double)13.0, (double)6.5, (double)0.0, (double)16.0, (double)9.5, (double)16.0);
    private static final VoxelShape SHAPE_WALL_EAST_HORIZONTAL = Block.m_49796_((double)0.0, (double)6.5, (double)0.0, (double)3.0, (double)9.5, (double)16.0);

    public NeonTubeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.TRUE)).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE)).m_61124_((Property)HORIZONTAL, (Comparable)Boolean.FALSE)).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ATTACH_FACE, (Comparable)AttachFace.WALL));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        AttachFace face = (AttachFace)blockState.m_61143_((Property)ATTACH_FACE);
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        boolean horizontal = (Boolean)blockState.m_61143_((Property)HORIZONTAL);
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> {
                switch (direction) {
                    case NORTH: 
                    case SOUTH: {
                        yield SHAPE_FLOOR_NORTH;
                    }
                    case WEST: 
                    case EAST: {
                        yield SHAPE_FLOOR_WEST;
                    }
                }
                yield SHAPE_FLOOR_NORTH;
            }
            case AttachFace.CEILING -> {
                switch (direction) {
                    case NORTH: 
                    case SOUTH: {
                        yield SHAPE_CEILING_NORTH;
                    }
                    case WEST: 
                    case EAST: {
                        yield SHAPE_CEILING_WEST;
                    }
                }
                yield SHAPE_CEILING_NORTH;
            }
            case AttachFace.WALL -> {
                if (horizontal) {
                    switch (direction) {
                        case NORTH: {
                            yield SHAPE_WALL_NORTH_HORIZONTAL;
                        }
                        case SOUTH: {
                            yield SHAPE_WALL_SOUTH_HORIZONTAL;
                        }
                        case WEST: {
                            yield SHAPE_WALL_WEST_HORIZONTAL;
                        }
                        case EAST: {
                            yield SHAPE_WALL_EAST_HORIZONTAL;
                        }
                    }
                    yield SHAPE_WALL_NORTH_HORIZONTAL;
                }
                switch (direction) {
                    case NORTH: {
                        yield SHAPE_WALL_NORTH_VERTICAL;
                    }
                    case SOUTH: {
                        yield SHAPE_WALL_SOUTH_VERTICAL;
                    }
                    case WEST: {
                        yield SHAPE_WALL_WEST_VERTICAL;
                    }
                    case EAST: {
                        yield SHAPE_WALL_EAST_VERTICAL;
                    }
                }
                yield SHAPE_WALL_NORTH_VERTICAL;
            }
        };
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource random) {
        if (!((Boolean)blockState.m_61143_((Property)LIT)).booleanValue()) {
            return;
        }
        if (random.m_188503_(100) == 0) {
            AttachFace face = (AttachFace)blockState.m_61143_((Property)ATTACH_FACE);
            Direction direction = (Direction)blockState.m_61143_((Property)FACING);
            double centerX = (double)blockPos.m_123341_() + 0.5;
            double centerY = (double)blockPos.m_123342_() + 0.5;
            double centerZ = (double)blockPos.m_123343_() + 0.5;
            double particleX = centerX;
            double particleY = centerY;
            double particleZ = centerZ;
            double offsetAlongTube = (random.m_188500_() - 0.5) * 0.8;
            block0 : switch (face) {
                case FLOOR: {
                    particleY = (double)blockPos.m_123342_() + 0.15;
                    if (direction == Direction.NORTH || direction == Direction.SOUTH) {
                        particleZ += offsetAlongTube;
                        particleX += (random.m_188500_() - 0.5) * 0.15;
                        break;
                    }
                    particleX += offsetAlongTube;
                    particleZ += (random.m_188500_() - 0.5) * 0.15;
                    break;
                }
                case CEILING: {
                    particleY = (double)blockPos.m_123342_() + 0.85;
                    if (direction == Direction.NORTH || direction == Direction.SOUTH) {
                        particleZ += offsetAlongTube;
                        particleX += (random.m_188500_() - 0.5) * 0.15;
                        break;
                    }
                    particleX += offsetAlongTube;
                    particleZ += (random.m_188500_() - 0.5) * 0.15;
                    break;
                }
                case WALL: {
                    boolean horizontal = (Boolean)blockState.m_61143_((Property)HORIZONTAL);
                    if (horizontal) {
                        switch (direction) {
                            case NORTH: {
                                particleZ = (double)blockPos.m_123343_() + 0.85;
                                particleX += offsetAlongTube;
                                particleY += (random.m_188500_() - 0.5) * 0.15;
                                break block0;
                            }
                            case SOUTH: {
                                particleZ = (double)blockPos.m_123343_() + 0.15;
                                particleX += offsetAlongTube;
                                particleY += (random.m_188500_() - 0.5) * 0.15;
                                break block0;
                            }
                            case WEST: {
                                particleX = (double)blockPos.m_123341_() + 0.85;
                                particleZ += offsetAlongTube;
                                particleY += (random.m_188500_() - 0.5) * 0.15;
                                break block0;
                            }
                            case EAST: {
                                particleX = (double)blockPos.m_123341_() + 0.15;
                                particleZ += offsetAlongTube;
                                particleY += (random.m_188500_() - 0.5) * 0.15;
                                break block0;
                            }
                        }
                        break;
                    }
                    particleY += offsetAlongTube;
                    switch (direction) {
                        case NORTH: {
                            particleZ = (double)blockPos.m_123343_() + 0.85;
                            particleX += (random.m_188500_() - 0.5) * 0.15;
                            break block0;
                        }
                        case SOUTH: {
                            particleZ = (double)blockPos.m_123343_() + 0.15;
                            particleX += (random.m_188500_() - 0.5) * 0.15;
                            break block0;
                        }
                        case WEST: {
                            particleX = (double)blockPos.m_123341_() + 0.85;
                            particleZ += (random.m_188500_() - 0.5) * 0.15;
                            break block0;
                        }
                        case EAST: {
                            particleX = (double)blockPos.m_123341_() + 0.15;
                            particleZ += (random.m_188500_() - 0.5) * 0.15;
                            break block0;
                        }
                    }
                }
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
        if (random.m_188503_(800) == 0) {
            level.m_7785_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, SoundEvents.f_11737_, SoundSource.BLOCKS, 0.05f, random.m_188501_() * 0.1f + 1.8f, false);
        }
    }

    @Override
    public BlockState rotateBlock(BlockState blockState) {
        AttachFace attachFace = (AttachFace)blockState.m_61143_((Property)ATTACH_FACE);
        if (attachFace == AttachFace.WALL) {
            boolean isHorizontal = (Boolean)blockState.m_61143_((Property)HORIZONTAL);
            return (BlockState)blockState.m_61124_((Property)HORIZONTAL, (Comparable)Boolean.valueOf(!isHorizontal));
        }
        Direction currentFacing = (Direction)blockState.m_61143_((Property)FACING);
        Direction newFacing = currentFacing.m_122427_();
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)newFacing);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(interactionHand);
        if (heldItem.m_41720_() instanceof ScrapMultitoolItem || heldItem.m_150930_(ModBlockItems.NEON_TUBE.get().m_5456_())) {
            if (!level.f_46443_) {
                level.m_7731_(blockPos, this.rotateBlock(blockState), 3);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = super.m_5573_(context);
        Level level = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        if (blockState.m_61143_((Property)ATTACH_FACE) == AttachFace.WALL) {
            blockState = (BlockState)blockState.m_61124_((Property)HORIZONTAL, (Comparable)Boolean.valueOf(false));
        }
        boolean hasPoweredNearby = this.hasPoweredNeonTubeNearby(level, blockPos, new HashSet<BlockPos>());
        boolean hasRedstoneNearby = this.hasRedstoneSourceInArea(level, blockPos, new HashSet<BlockPos>());
        boolean powered = hasPoweredNearby || hasRedstoneNearby;
        boolean lit = powered ? level.m_276867_(blockPos) : true;
        return (BlockState)((BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(lit));
    }

    private boolean hasPoweredNeonTubeNearby(Level level, BlockPos startPos, Set<BlockPos> checked) {
        if (checked.contains(startPos)) {
            return false;
        }
        checked.add(startPos);
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = startPos.m_121945_(direction);
            BlockState neighborState = level.m_8055_(neighborPos);
            if (!(neighborState.m_60734_() instanceof NeonTubeBlock)) continue;
            if (((Boolean)neighborState.m_61143_((Property)POWERED)).booleanValue()) {
                return true;
            }
            if (checked.size() >= 256 || !this.hasPoweredNeonTubeNearby(level, neighborPos, checked)) continue;
            return true;
        }
        return false;
    }

    private boolean hasRedstoneSourceInArea(Level level, BlockPos startPos, Set<BlockPos> checked) {
        if (checked.contains(startPos)) {
            return false;
        }
        checked.add(startPos);
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    BlockPos checkPos = startPos.m_7918_(xOffset, yOffset, zOffset);
                    if (checkPos.equals((Object)startPos)) continue;
                    BlockState checkState = level.m_8055_(checkPos);
                    if (checkState.m_60803_()) {
                        return true;
                    }
                    for (Direction direction : Direction.values()) {
                        if (level.m_277185_(checkPos, direction) <= 0) continue;
                        return true;
                    }
                }
            }
        }
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = startPos.m_121945_(direction);
            BlockState neighborState = level.m_8055_(neighborPos);
            if (!(neighborState.m_60734_() instanceof NeonTubeBlock) || checked.size() >= 256 || !this.hasRedstoneSourceInArea(level, neighborPos, checked)) continue;
            return true;
        }
        return false;
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_) {
            this.updateChain(level, blockPos);
        }
    }

    private void updateChain(Level level, BlockPos startPos) {
        LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        toCheck.add(startPos);
        checked.add(startPos);
        boolean hasRedstoneInChain = this.hasRedstoneSourceInArea(level, startPos, new HashSet<BlockPos>());
        boolean anyBlockPowered = false;
        if (hasRedstoneInChain) {
            for (BlockPos pos : this.getAllConnectedBlocks(level, startPos)) {
                if (!level.m_276867_(pos)) continue;
                anyBlockPowered = true;
                break;
            }
        }
        while (!toCheck.isEmpty()) {
            boolean shouldBeLit;
            BlockPos currentPos = (BlockPos)toCheck.poll();
            BlockState currentState = level.m_8055_(currentPos);
            if (!(currentState.m_60734_() instanceof NeonTubeBlock)) continue;
            boolean powered = hasRedstoneInChain;
            boolean bl = shouldBeLit = powered ? anyBlockPowered : true;
            if ((Boolean)currentState.m_61143_((Property)POWERED) != powered || (Boolean)currentState.m_61143_((Property)LIT) != shouldBeLit) {
                level.m_7731_(currentPos, (BlockState)((BlockState)currentState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(shouldBeLit)), 3);
            }
            for (Direction direction : Direction.values()) {
                BlockState neighborState;
                BlockPos neighborPos = currentPos.m_121945_(direction);
                if (checked.contains(neighborPos) || !((neighborState = level.m_8055_(neighborPos)).m_60734_() instanceof NeonTubeBlock)) continue;
                toCheck.add(neighborPos);
                checked.add(neighborPos);
            }
        }
    }

    private Set<BlockPos> getAllConnectedBlocks(Level level, BlockPos startPos) {
        HashSet<BlockPos> connected = new HashSet<BlockPos>();
        LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        toCheck.add(startPos);
        connected.add(startPos);
        while (!toCheck.isEmpty()) {
            BlockPos currentPos = (BlockPos)toCheck.poll();
            for (Direction direction : Direction.values()) {
                BlockState neighborState;
                BlockPos neighborPos = currentPos.m_121945_(direction);
                if (connected.contains(neighborPos) || !((neighborState = level.m_8055_(neighborPos)).m_60734_() instanceof NeonTubeBlock)) continue;
                toCheck.add(neighborPos);
                connected.add(neighborPos);
            }
        }
        return connected;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIT, POWERED, HORIZONTAL});
    }
}

