/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity.rechargestation;

import de.markusbordihn.scraptechworkshop.block.entity.AbstractWorkshopBlockEntity;
import de.markusbordihn.scraptechworkshop.block.entity.rechargestation.RechargeStationContainer;
import de.markusbordihn.scraptechworkshop.block.rechargestation.RechargeStationBlock;
import de.markusbordihn.scraptechworkshop.data.rechargestation.RechargeStationStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerConsumer;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerData;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.item.component.EmptyEnergyCellItem;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.menu.RechargeStationMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RechargeStationBlockEntity
extends AbstractWorkshopBlockEntity
implements EnergyPowerConsumer {
    public static final String ID = "recharge_station";
    private static final int ENERGY_CAPACITY_MAH = 10000;
    private static final int ENERGY_CHARGE_INTERVAL = 5;
    private static final int ENERGY_CONSUMPTION_PER_TICK = 5;
    private static final int RECHARGE_RATE = 5;
    private static final String PROGRESS_TAG = "Progress";
    private static final String MAX_PROGRESS_TAG = "MaxProgress";
    private static final int PROGRESS_DATA_INDEX = 0;
    private static final int MAX_PROGRESS_DATA_INDEX = 1;
    private static final String TRANSLATION_KEY = "container.scrap_tech_workshop.recharge_station";
    public static BlockEntityType<RechargeStationBlockEntity> TYPE;
    private final RechargeStationContainer container;
    private int progress = 0;
    private int maxProgress = 100;
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> RechargeStationBlockEntity.this.progress;
                case 1 -> RechargeStationBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    RechargeStationBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    RechargeStationBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private EnergyPowerData energyData = EnergyPowerData.empty();
    private int tickCounter = 0;

    public RechargeStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(TYPE, blockPos, blockState);
        this.container = new RechargeStationContainer(2, this::m_6596_);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, RechargeStationBlockEntity blockEntity) {
        ItemStack inputItem;
        if (level.f_46443_) {
            return;
        }
        ++blockEntity.tickCounter;
        if (blockEntity.tickCounter % 5 == 0) {
            blockEntity.chargeFromBattery(blockEntity.getEnergyTransferRate());
        }
        RechargeStationStatus currentStatus = (RechargeStationStatus)((Object)blockState.m_61143_(RechargeStationBlock.STATUS));
        boolean hasEnoughEnergy = blockEntity.getCurrentEnergy() >= 5;
        RechargeStationStatus newStatus = RechargeStationBlockEntity.determineStatus(hasEnoughEnergy, inputItem = blockEntity.container.m_8020_(0));
        if (newStatus != currentStatus) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_(RechargeStationBlock.STATUS, (Comparable)((Object)newStatus)), 3);
            blockEntity.progress = 0;
        }
        if (newStatus == RechargeStationStatus.CHARGING && hasEnoughEnergy) {
            if (inputItem.m_41720_() instanceof EmptyEnergyCellItem) {
                ItemStack chargedCell = new ItemStack((ItemLike)ModItems.ENERGY_CELL.get());
                Item item = chargedCell.m_41720_();
                if (item instanceof EnergyCellItem) {
                    EnergyCellItem energyCellItem = (EnergyCellItem)item;
                    energyCellItem.setEnergy(chargedCell, 5);
                    blockEntity.container.m_6836_(0, chargedCell);
                    blockEntity.consumeEnergy(5);
                    blockEntity.progress = 1;
                    blockEntity.maxProgress = 100;
                    blockEntity.m_6596_();
                    if (blockEntity.tickCounter % 10 == 0) {
                        RechargeStationBlockEntity.spawnChargingParticles(level, blockPos, blockState);
                    }
                    if (blockEntity.tickCounter % 20 == 0) {
                        RechargeStationBlockEntity.playChargingSound(level, blockPos);
                    }
                }
            } else {
                Item chargedCell = inputItem.m_41720_();
                if (chargedCell instanceof EnergyCellItem) {
                    int maxBatteryEnergy;
                    EnergyCellItem batteryItem = (EnergyCellItem)chargedCell;
                    int currentBatteryEnergy = batteryItem.getEnergy(inputItem);
                    if (currentBatteryEnergy < (maxBatteryEnergy = 5000)) {
                        int energyToTransfer = Math.min(5, maxBatteryEnergy - currentBatteryEnergy);
                        batteryItem.setEnergy(inputItem, currentBatteryEnergy + energyToTransfer);
                        blockEntity.consumeEnergy(5);
                        blockEntity.progress = currentBatteryEnergy * 100 / maxBatteryEnergy;
                        blockEntity.maxProgress = 100;
                        blockEntity.m_6596_();
                        if (blockEntity.tickCounter % 10 == 0) {
                            RechargeStationBlockEntity.spawnChargingParticles(level, blockPos, blockState);
                        }
                        if (blockEntity.tickCounter % 20 == 0) {
                            RechargeStationBlockEntity.playChargingSound(level, blockPos);
                        }
                    } else {
                        level.m_7731_(blockPos, (BlockState)blockState.m_61124_(RechargeStationBlock.STATUS, (Comparable)((Object)RechargeStationStatus.DONE)), 3);
                    }
                }
            }
        }
        if (newStatus == RechargeStationStatus.DONE || newStatus == RechargeStationStatus.IDLE) {
            blockEntity.progress = 0;
        }
    }

    private static RechargeStationStatus determineStatus(boolean hasEnoughEnergy, ItemStack inputItem) {
        if (!hasEnoughEnergy) {
            return RechargeStationStatus.NO_POWER;
        }
        if (inputItem.m_41619_()) {
            return RechargeStationStatus.IDLE;
        }
        if (inputItem.m_41720_() instanceof EmptyEnergyCellItem) {
            return RechargeStationStatus.CHARGING;
        }
        Item item = inputItem.m_41720_();
        if (item instanceof EnergyCellItem) {
            int maxEnergy;
            EnergyCellItem batteryItem = (EnergyCellItem)item;
            int currentEnergy = batteryItem.getEnergy(inputItem);
            if (currentEnergy >= (maxEnergy = 5000)) {
                return RechargeStationStatus.DONE;
            }
            return RechargeStationStatus.CHARGING;
        }
        return RechargeStationStatus.IDLE;
    }

    private static void spawnChargingParticles(Level level, BlockPos blockPos, BlockState blockState) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x = (double)blockPos.m_123341_() + 0.5;
            double z = (double)blockPos.m_123343_() + 0.5;
            Direction facing = (Direction)blockState.m_61143_((Property)RechargeStationBlock.FACING);
            double offsetFromCenter = 0.15;
            switch (facing) {
                case NORTH: {
                    z -= offsetFromCenter;
                    break;
                }
                case SOUTH: {
                    z += offsetFromCenter;
                    break;
                }
                case WEST: {
                    x -= offsetFromCenter;
                    break;
                }
                case EAST: {
                    x += offsetFromCenter;
                    break;
                }
            }
            for (int i = 0; i < 2; ++i) {
                double offsetX = (level.f_46441_.m_188500_() - 0.5) * 0.2;
                double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 0.2;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x + offsetX, (double)blockPos.m_123342_() + 0.75, z + offsetZ, 1, 0.0, 0.05, 0.0, 0.01);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x + offsetX, (double)blockPos.m_123342_() + 0.2, z + offsetZ, 1, 0.0, 0.05, 0.0, 0.01);
            }
        }
    }

    private static void playChargingSound(Level level, BlockPos blockPos) {
        level.m_5594_(null, blockPos, SoundEvents.f_11737_, SoundSource.BLOCKS, 0.15f, 1.8f);
    }

    public RechargeStationContainer getContainer() {
        return this.container;
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.container.getItems();
    }

    protected int getTotalSlots() {
        return 2;
    }

    @Override
    protected WorldlyContainer getContainerDelegate() {
        return this.container;
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.progress = compoundTag.m_128451_(PROGRESS_TAG);
        this.maxProgress = compoundTag.m_128451_(MAX_PROGRESS_TAG);
        this.loadEnergyPowerConsumer(compoundTag);
        this.energyData = new EnergyPowerData(this.energyData.currentEnergy(), this.container.m_8020_(1));
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128405_(PROGRESS_TAG, this.progress);
        compoundTag.m_128405_(MAX_PROGRESS_TAG, this.maxProgress);
        this.saveEnergyPowerConsumer(compoundTag);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)TRANSLATION_KEY);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new RechargeStationMenu(windowId, playerInventory, this, this.containerData);
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    private void syncToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.syncToClient();
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public EnergyPowerData getEnergyData() {
        return new EnergyPowerData(this.energyData.currentEnergy(), this.container.m_8020_(1));
    }

    @Override
    public void setEnergyData(EnergyPowerData data) {
        this.energyData = new EnergyPowerData(data.currentEnergy(), data.battery());
        this.container.m_6836_(1, data.battery());
        this.m_6596_();
    }

    @Override
    public int getEnergyCapacity() {
        return 10000;
    }

    @Override
    public int getBatterySlot() {
        return 1;
    }

    @Override
    public void markDirty() {
        this.m_6596_();
    }

    public ItemStack getInputItem() {
        return this.container.m_8020_(0);
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }
}

