/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy.compat;

import de.markusbordihn.scraptechworkshop.energy.EnergyPowerConsumer;
import de.markusbordihn.scraptechworkshop.energy.compat.ForgeEnergyWrapper;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="scrap_tech_workshop")
public class EnergyCapabilityHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"Scrap Tech Workshop");

    @SubscribeEvent
    public static void attachBlockEntityCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        BlockEntity blockEntity = (BlockEntity)event.getObject();
        if (blockEntity instanceof EnergyPowerConsumer) {
            EnergyPowerConsumer energyConsumer = (EnergyPowerConsumer)blockEntity;
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"scrap_tech_workshop", (String)"forge_energy"), (ICapabilityProvider)new ForgeEnergyCapabilityProvider(energyConsumer));
            LOGGER.debug("Attached Forge Energy capability to {}", (Object)blockEntity.getClass().getSimpleName());
        }
    }

    private static class ForgeEnergyCapabilityProvider
    implements ICapabilityProvider {
        private final LazyOptional<ForgeEnergyWrapper> forgeEnergyOptional = LazyOptional.of(() -> new ForgeEnergyWrapper(energyConsumer));

        public ForgeEnergyCapabilityProvider(EnergyPowerConsumer energyConsumer) {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
            if (capability == ForgeCapabilities.ENERGY) {
                return this.forgeEnergyOptional.cast();
            }
            return LazyOptional.empty();
        }
    }
}

