/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.item;

import de.markusbordihn.scraptechworkshop.data.floatingscrapcollector.ScrapFilterType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ScrapFilterItem
extends Item {
    private final ScrapFilterType filterType;
    private final int maxDurability;

    public ScrapFilterItem(ScrapFilterType filterType, int maxDurability) {
        super(new Item.Properties().m_41487_(1).m_41503_(maxDurability));
        this.filterType = filterType;
        this.maxDurability = maxDurability;
    }

    public static int getDurability(ItemStack stack) {
        return stack.m_41776_() - stack.m_41773_();
    }

    public static int getMaxDurability(ItemStack stack) {
        return stack.m_41776_();
    }

    public static float getDurabilityPercent(ItemStack stack) {
        if (stack.m_41776_() == 0) {
            return 0.0f;
        }
        return (float)ScrapFilterItem.getDurability(stack) / (float)stack.m_41776_();
    }

    public static void consumeDurability(ItemStack stack, int amount) {
        stack.m_41721_(Math.min(stack.m_41773_() + amount, stack.m_41776_()));
    }

    public ScrapFilterType getFilterType() {
        return this.filterType;
    }

    public int getMaxDurability() {
        return this.maxDurability;
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> tooltipComponents, TooltipFlag flag) {
        super.m_7373_(itemStack, level, tooltipComponents, flag);
        tooltipComponents.add((Component)Component.m_237115_((String)("item.scrap_tech_workshop.scrap_filter." + this.filterType.m_7912_())).m_130940_(ChatFormatting.GRAY));
        float percent = ScrapFilterItem.getDurabilityPercent(itemStack);
        ChatFormatting durabilityColor = percent > 0.75f ? ChatFormatting.GREEN : (percent > 0.5f ? ChatFormatting.YELLOW : (percent > 0.25f ? ChatFormatting.GOLD : ChatFormatting.RED));
        tooltipComponents.add((Component)Component.m_237110_((String)"item.scrap_tech_workshop.scrap_filter.durability", (Object[])new Object[]{ScrapFilterItem.getDurability(itemStack), ScrapFilterItem.getMaxDurability(itemStack)}).m_130940_(durabilityColor));
        tooltipComponents.add((Component)Component.m_237115_((String)"item.scrap_tech_workshop.scrap_filter.usage").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
    }
}

