/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.pathfinding;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ClientSideMovement {
    private static final double REACH_DISTANCE = 0.5;
    private static final double GRAVITY = -0.08;
    private static final double JUMP_VELOCITY = 0.42;

    public static boolean moveTowards(Mob entity, double targetX, double targetY, double targetZ, double speed) {
        double dx = targetX - entity.m_20185_();
        double dy = targetY - entity.m_20186_();
        double dz = targetZ - entity.m_20189_();
        double distanceXZ = Math.sqrt(dx * dx + dz * dz);
        if (distanceXZ < 0.5) {
            entity.m_20334_(0.0, entity.m_20184_().f_82480_, 0.0);
            entity.m_7910_(0.0f);
            return false;
        }
        if (ClientSideMovement.isObstacleAhead(entity, dx, dz, distanceXZ)) {
            entity.m_20334_(0.0, entity.m_20184_().f_82480_, 0.0);
            entity.m_7910_(0.0f);
            return false;
        }
        double moveX = dx / distanceXZ * speed;
        double moveZ = dz / distanceXZ * speed;
        double moveY = ClientSideMovement.handleVerticalMovement(entity, targetY, dy, dx, dz, distanceXZ);
        entity.m_20334_(moveX, moveY, moveZ);
        entity.m_6478_(MoverType.SELF, entity.m_20184_());
        entity.m_7910_((float)speed);
        return true;
    }

    private static boolean isObstacleAhead(Mob entity, double dx, double dz, double distance) {
        Level level = entity.m_9236_();
        BlockPos currentPos = entity.m_20183_();
        int offsetX = (int)Math.round(dx / distance);
        int offsetZ = (int)Math.round(dz / distance);
        if (offsetX == 0 && offsetZ == 0) {
            return false;
        }
        BlockPos checkPos = currentPos.m_7918_(offsetX, 0, offsetZ);
        BlockState blockAtLevel = level.m_8055_(checkPos);
        BlockState blockAbove = level.m_8055_(checkPos.m_7494_());
        boolean levelBlocked = !blockAtLevel.m_60795_() && blockAtLevel.m_60804_((BlockGetter)level, checkPos) && blockAtLevel.m_60815_();
        boolean aboveBlocked = !blockAbove.m_60795_() && blockAbove.m_60804_((BlockGetter)level, checkPos.m_7494_());
        return levelBlocked && aboveBlocked;
    }

    private static double handleVerticalMovement(Mob entity, double targetY, double dy, double dx, double dz, double distanceXZ) {
        if (!entity.m_20096_()) {
            return entity.m_20184_().f_82480_ + -0.08;
        }
        if (dy > 0.3) {
            boolean isSolidFront;
            Level level = entity.m_9236_();
            BlockPos currentPos = entity.m_20183_();
            int offsetX = (int)Math.round(dx / distanceXZ);
            int offsetZ = (int)Math.round(dz / distanceXZ);
            BlockPos frontPos = currentPos.m_7918_(offsetX, 0, offsetZ);
            BlockState frontBlock = level.m_8055_(frontPos);
            BlockState aboveBlock = level.m_8055_(frontPos.m_7494_());
            BlockState above2Block = level.m_8055_(frontPos.m_6630_(2));
            boolean bl = isSolidFront = !frontBlock.m_60795_() && frontBlock.m_60804_((BlockGetter)level, frontPos) && frontBlock.m_60815_();
            if (isSolidFront && aboveBlock.m_60795_() && above2Block.m_60795_() && Math.abs(entity.m_20184_().f_82480_) < 0.05) {
                return 0.42;
            }
        }
        if (dy < -0.5) {
            return dy * 0.1;
        }
        return 0.0;
    }

    public static Vec3 findGroundPosition(Level level, double x, double startY, double z, int searchRadius) {
        BlockPos checkPos;
        int i;
        BlockPos centerPos = new BlockPos((int)x, (int)startY, (int)z);
        for (i = 0; i <= searchRadius; ++i) {
            checkPos = centerPos.m_6625_(i);
            if (!ClientSideMovement.isValidGroundPosition(level, checkPos)) continue;
            return new Vec3(x, (double)checkPos.m_123342_() + 1.0, z);
        }
        for (i = 1; i <= searchRadius / 2; ++i) {
            checkPos = centerPos.m_6630_(i);
            if (!ClientSideMovement.isValidGroundPosition(level, checkPos)) continue;
            return new Vec3(x, (double)checkPos.m_123342_() + 1.0, z);
        }
        return new Vec3(x, startY, z);
    }

    private static boolean isValidGroundPosition(Level level, BlockPos pos) {
        BlockState ground = level.m_8055_(pos);
        BlockState above = level.m_8055_(pos.m_7494_());
        BlockState above2 = level.m_8055_(pos.m_6630_(2));
        boolean isGroundSolid = !ground.m_60795_() && (ground.m_60804_((BlockGetter)level, pos) || ground.m_60815_()) && ground.m_60819_().m_76178_();
        return isGroundSolid && above.m_60795_() && above2.m_60795_();
    }
}

