/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.entity;

import de.markusbordihn.scraptechworkshop.config.ScrapRobotConfig;
import de.markusbordihn.scraptechworkshop.registry.entity.MixedScrapRobotEntityRegistry;
import de.markusbordihn.scraptechworkshop.spawner.ScrapRobotSpawner;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_6880;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FabricEntitySpawnHandler {
    protected static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String LOG_PREFIX = "[Entity Spawn Handler]";

    private FabricEntitySpawnHandler() {
    }

    public static void registerSpawns() {
        if (!ScrapRobotConfig.mixedScrapRobotSpawnEnabled) {
            log.info("{} Mixed Scrap Robot spawning is disabled in config", (Object)LOG_PREFIX);
            return;
        }
        if (MixedScrapRobotEntityRegistry.MIXED_SCRAP_ROBOT_ENTITY_TYPE == null) {
            log.error("{} Mixed Scrap Robot entity type is null, cannot register spawns", (Object)LOG_PREFIX);
            return;
        }
        BiomeModifications.addSpawn(context -> {
            if (!ScrapRobotConfig.mixedScrapRobotSpawnEnabled) {
                return false;
            }
            return ScrapRobotSpawner.shouldSpawnInBiome((class_6880<class_1959>)context.getBiomeRegistryEntry(), ScrapRobotConfig.mixedScrapRobotBiomeType);
        }, (class_1311)class_1311.field_6294, MixedScrapRobotEntityRegistry.MIXED_SCRAP_ROBOT_ENTITY_TYPE, (int)ScrapRobotConfig.mixedScrapRobotSpawnWeight, (int)ScrapRobotConfig.mixedScrapRobotSpawnMinGroup, (int)ScrapRobotConfig.mixedScrapRobotSpawnMaxGroup);
        log.info("{} Registered Mixed Scrap Robot natural spawning (weight: {}, group: {}-{}, biomes: {})", (Object)LOG_PREFIX, (Object)ScrapRobotConfig.mixedScrapRobotSpawnWeight, (Object)ScrapRobotConfig.mixedScrapRobotSpawnMinGroup, (Object)ScrapRobotConfig.mixedScrapRobotSpawnMaxGroup, (Object)ScrapRobotConfig.mixedScrapRobotBiomeType);
    }
}

