/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.entity.robot.collectorstationrobot;

import de.markusbordihn.scraptechworkshop.data.collectorstation.CollectorStationStatus;
import de.markusbordihn.scraptechworkshop.entity.robot.BaseRobotEntity;
import de.markusbordihn.scraptechworkshop.entity.robot.collectorstationrobot.RandomCollectGoal;
import de.markusbordihn.scraptechworkshop.entity.robot.collectorstationrobot.ReturnToStationGoal;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_5132;

public class CollectorStationRobotEntity
extends BaseRobotEntity {
    public static final String ID = "collector_station_robot";
    private CollectorStationStatus status = CollectorStationStatus.CHARGING;
    private int collectionRadius = 16;
    private float animationPosition = 0.0f;
    private float animationSpeed = 0.0f;
    private boolean isMovingFromGoal = false;
    private boolean isDigging = false;

    public CollectorStationRobotEntity(class_1299<? extends BaseRobotEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    public static class_5132.class_5133 createAttributes() {
        return CollectorStationRobotEntity.createBaseAttributes();
    }

    protected void method_5959() {
    }

    public void registerClientSideGoals() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new ReturnToStationGoal(this, 1.2));
        this.field_6201.method_6277(2, (class_1352)new RandomCollectGoal(this, 0.7, 64));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
    }

    @Override
    public void method_5773() {
        if (!this.method_37908().field_9236) {
            return;
        }
        super.method_5773();
        this.updateWalkAnimation();
        this.tickAiAndNavigation();
    }

    private void updateWalkAnimation() {
        double dz;
        double dx = this.method_23317() - this.field_6014;
        float distanceMoved = (float)Math.sqrt(dx * dx + (dz = this.method_23321() - this.field_5969) * dz);
        if (distanceMoved > 0.01f) {
            this.animationSpeed = Math.min(1.0f, this.animationSpeed + 0.15f);
            this.animationPosition += distanceMoved * 8.0f;
        } else {
            this.animationSpeed = Math.max(0.0f, this.animationSpeed - 0.15f);
        }
        this.field_42108.method_48568(this.animationSpeed, 0.4f);
    }

    private void tickAiAndNavigation() {
        this.field_6201.method_6275();
        this.field_6189.method_6360();
        this.field_6206.method_6231();
        this.field_6207.method_6240();
    }

    private void onStatusChanged(CollectorStationStatus oldStatus, CollectorStationStatus newStatus) {
        if (newStatus == CollectorStationStatus.COLLECTING || newStatus == CollectorStationStatus.RETURNING) {
            return;
        }
        this.method_5942().method_6340();
    }

    public CollectorStationStatus getStatus() {
        return this.status;
    }

    public void setStatus(CollectorStationStatus newStatus) {
        if (this.status != newStatus) {
            CollectorStationStatus oldStatus = this.status;
            this.status = newStatus;
            this.onStatusChanged(oldStatus, newStatus);
        }
    }

    public boolean isMovingFromGoal() {
        return this.isMovingFromGoal;
    }

    public void setMovingFromGoal(boolean moving) {
        this.isMovingFromGoal = moving;
    }

    public boolean isDigging() {
        return this.isDigging;
    }

    public void setDigging(boolean digging) {
        this.isDigging = digging;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return true;
    }
}

