/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.pathfinding;

import net.minecraft.class_1308;
import net.minecraft.class_1313;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public class ClientSideMovement {
    private static final double REACH_DISTANCE = 0.5;
    private static final double GRAVITY = -0.08;
    private static final double JUMP_VELOCITY = 0.42;

    public static boolean moveTowards(class_1308 entity, double targetX, double targetY, double targetZ, double speed) {
        double dx = targetX - entity.method_23317();
        double dy = targetY - entity.method_23318();
        double dz = targetZ - entity.method_23321();
        double distanceXZ = Math.sqrt(dx * dx + dz * dz);
        if (distanceXZ < 0.5) {
            entity.method_18800(0.0, entity.method_18798().field_1351, 0.0);
            entity.method_6125(0.0f);
            return false;
        }
        if (ClientSideMovement.isObstacleAhead(entity, dx, dz, distanceXZ)) {
            entity.method_18800(0.0, entity.method_18798().field_1351, 0.0);
            entity.method_6125(0.0f);
            return false;
        }
        double moveX = dx / distanceXZ * speed;
        double moveZ = dz / distanceXZ * speed;
        double moveY = ClientSideMovement.handleVerticalMovement(entity, targetY, dy, dx, dz, distanceXZ);
        entity.method_18800(moveX, moveY, moveZ);
        entity.method_5784(class_1313.field_6308, entity.method_18798());
        entity.method_6125((float)speed);
        return true;
    }

    private static boolean isObstacleAhead(class_1308 entity, double dx, double dz, double distance) {
        class_1937 level = entity.method_37908();
        class_2338 currentPos = entity.method_24515();
        int offsetX = (int)Math.round(dx / distance);
        int offsetZ = (int)Math.round(dz / distance);
        if (offsetX == 0 && offsetZ == 0) {
            return false;
        }
        class_2338 checkPos = currentPos.method_10069(offsetX, 0, offsetZ);
        class_2680 blockAtLevel = level.method_8320(checkPos);
        class_2680 blockAbove = level.method_8320(checkPos.method_10084());
        boolean levelBlocked = !blockAtLevel.method_26215() && blockAtLevel.method_26216((class_1922)level, checkPos) && blockAtLevel.method_26225();
        boolean aboveBlocked = !blockAbove.method_26215() && blockAbove.method_26216((class_1922)level, checkPos.method_10084());
        return levelBlocked && aboveBlocked;
    }

    private static double handleVerticalMovement(class_1308 entity, double targetY, double dy, double dx, double dz, double distanceXZ) {
        if (!entity.method_24828()) {
            return entity.method_18798().field_1351 + -0.08;
        }
        if (dy > 0.3) {
            boolean isSolidFront;
            class_1937 level = entity.method_37908();
            class_2338 currentPos = entity.method_24515();
            int offsetX = (int)Math.round(dx / distanceXZ);
            int offsetZ = (int)Math.round(dz / distanceXZ);
            class_2338 frontPos = currentPos.method_10069(offsetX, 0, offsetZ);
            class_2680 frontBlock = level.method_8320(frontPos);
            class_2680 aboveBlock = level.method_8320(frontPos.method_10084());
            class_2680 above2Block = level.method_8320(frontPos.method_10086(2));
            boolean bl = isSolidFront = !frontBlock.method_26215() && frontBlock.method_26216((class_1922)level, frontPos) && frontBlock.method_26225();
            if (isSolidFront && aboveBlock.method_26215() && above2Block.method_26215() && Math.abs(entity.method_18798().field_1351) < 0.05) {
                return 0.42;
            }
        }
        if (dy < -0.5) {
            return dy * 0.1;
        }
        return 0.0;
    }

    public static class_243 findGroundPosition(class_1937 level, double x, double startY, double z, int searchRadius) {
        class_2338 checkPos;
        int i;
        class_2338 centerPos = new class_2338((int)x, (int)startY, (int)z);
        for (i = 0; i <= searchRadius; ++i) {
            checkPos = centerPos.method_10087(i);
            if (!ClientSideMovement.isValidGroundPosition(level, checkPos)) continue;
            return new class_243(x, (double)checkPos.method_10264() + 1.0, z);
        }
        for (i = 1; i <= searchRadius / 2; ++i) {
            checkPos = centerPos.method_10086(i);
            if (!ClientSideMovement.isValidGroundPosition(level, checkPos)) continue;
            return new class_243(x, (double)checkPos.method_10264() + 1.0, z);
        }
        return new class_243(x, startY, z);
    }

    private static boolean isValidGroundPosition(class_1937 level, class_2338 pos) {
        class_2680 ground = level.method_8320(pos);
        class_2680 above = level.method_8320(pos.method_10084());
        class_2680 above2 = level.method_8320(pos.method_10086(2));
        boolean isGroundSolid = !ground.method_26215() && (ground.method_26216((class_1922)level, pos) || ground.method_26225()) && ground.method_26227().method_15769();
        return isGroundSolid && above.method_26215() && above2.method_26215();
    }
}

