/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block;

import de.markusbordihn.scraptechworkshop.Constants;
import de.markusbordihn.scraptechworkshop.block.entity.RecyclerBlockEntity;
import de.markusbordihn.scraptechworkshop.data.recycler.RecyclerStatus;
import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecyclerBlock
extends BaseEntityBlock {
    public static final String ID = "recycler";
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<RecyclerStatus> STATUS = EnumProperty.m_61587_((String)"status", RecyclerStatus.class);
    private static final VoxelShape SHAPE_NORTH_SOUTH = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");

    public RecyclerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE)).m_61124_(STATUS, (Comparable)((Object)RecyclerStatus.IDLE)));
    }

    public static void updateStatus(Level level, BlockPos pos, RecyclerStatus newStatus) {
        BlockState currentState = level.m_8055_(pos);
        if (currentState.m_60734_() instanceof RecyclerBlock && currentState.m_61143_(STATUS) != newStatus) {
            level.m_7731_(pos, (BlockState)currentState.m_61124_(STATUS, (Comparable)((Object)newStatus)), 3);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return switch (facing) {
            case Direction.NORTH, Direction.SOUTH -> SHAPE_NORTH_SOUTH;
            case Direction.EAST, Direction.WEST -> SHAPE_EAST_WEST;
            default -> SHAPE_NORTH_SOUTH;
        };
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RecyclerBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return RecyclerBlock.m_152132_(blockEntityType, RecyclerBlockEntity.TYPE, RecyclerBlockEntity::tick);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof RecyclerBlockEntity) {
            RecyclerBlockEntity recyclerBlockEntity = (RecyclerBlockEntity)blockEntity;
            this.openRecyclerMenu(player, recyclerBlockEntity);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private void openRecyclerMenu(Player player, RecyclerBlockEntity recyclerBlockEntity) {
        if (Constants.IS_FABRIC) {
            try {
                Class<?> fabricFactoryClass;
                try {
                    fabricFactoryClass = Class.forName("de.markusbordihn.scraptechworkshop.menu.BlockBaseScreenHandler");
                }
                catch (ClassNotFoundException e) {
                    fabricFactoryClass = Class.forName("de.markusbordihn.scraptechworkshop.menu.BaseScreenHandler");
                }
                Object fabricFactory = fabricFactoryClass.getConstructor(BlockEntity.class).newInstance(new Object[]{recyclerBlockEntity});
                player.m_5893_((MenuProvider)fabricFactory);
            }
            catch (Exception e) {
                log.error("Failed to open Recycler menu on Fabric: {}", (Object)e.getMessage());
                player.m_5893_((MenuProvider)recyclerBlockEntity);
            }
        } else if (Constants.IS_FORGE) {
            try {
                Class<?> forgeMenuProviderClass = Class.forName("de.markusbordihn.scraptechworkshop.block.entity.ForgeRecyclerMenuProvider");
                Object menuProvider = forgeMenuProviderClass.getConstructor(RecyclerBlockEntity.class).newInstance(new Object[]{recyclerBlockEntity});
                Class<?> networkHooksClass = Class.forName("net.minecraftforge.network.NetworkHooks");
                try {
                    Method openGuiMethod = networkHooksClass.getMethod("openGui", ServerPlayer.class, MenuProvider.class, BlockPos.class);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        openGuiMethod.invoke(null, serverPlayer, menuProvider, recyclerBlockEntity.m_58899_());
                    }
                }
                catch (NoSuchMethodException e1) {
                    Method openScreenMethod = networkHooksClass.getMethod("openScreen", ServerPlayer.class, MenuProvider.class, BlockPos.class);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        openScreenMethod.invoke(null, serverPlayer, menuProvider, recyclerBlockEntity.m_58899_());
                    }
                }
            }
            catch (Exception e) {
                log.error("[RECYCLER] Failed to use Forge NetworkHooks, falling back to standard: {}", (Object)e.getMessage());
                player.m_5893_((MenuProvider)recyclerBlockEntity);
            }
        } else {
            player.m_5893_((MenuProvider)recyclerBlockEntity);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof RecyclerBlockEntity) {
                RecyclerBlockEntity recyclerBlockEntity = (RecyclerBlockEntity)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)recyclerBlockEntity.getContainer());
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE)).m_61124_(STATUS, (Comparable)((Object)RecyclerStatus.IDLE));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED, STATUS});
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof RecyclerBlockEntity) {
            RecyclerBlockEntity recyclerBlockEntity = (RecyclerBlockEntity)blockEntity;
            return recyclerBlockEntity.getRedstoneSignal();
        }
        return 0;
    }
}

