/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity;

import de.markusbordihn.scraptechworkshop.block.hololog.HoloCubeBlock;
import de.markusbordihn.scraptechworkshop.client.renderer.hololog.HoloLogBlockPlayer;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogData;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogManager;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogStatus;
import de.markusbordihn.scraptechworkshop.data.hololog.WorldContext;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloCubeBlockEntity
extends BlockEntity {
    public static final String ID = "holocube";
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String CUBE_UUID_TAG = "CubeUUID";
    private static final String HOLOLOG_ID_TAG = "HolologId";
    private static final String PLAYER_UUID_TAG = "PlayerUUID";
    private static final String LAST_STATUS_TAG = "LastStatus";
    private static final String ENDED_TICK_TAG = "EndedTick";
    private static final ResourceLocation DEFAULT_HOLO_LOG = new ResourceLocation("scrap_tech_workshop", "holologs/intro/introduction");
    private static final double MAX_PLAYER_DISTANCE = 32.0;
    private static final int AUTO_RESET_TICKS = 20;
    public static BlockEntityType<HoloCubeBlockEntity> TYPE;
    private UUID cubeUUID;
    private ResourceLocation holoLogId;
    private UUID playerUUID;
    private HoloLogBlockPlayer player;
    private HoloLogStatus lastKnownStatus = HoloLogStatus.READY;
    private long endedAtTick = -1L;

    public HoloCubeBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
        this.cubeUUID = UUID.randomUUID();
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, HoloCubeBlockEntity blockEntity) {
        if (!level.f_46443_) {
            return;
        }
        HoloLogStatus status = (HoloLogStatus)((Object)blockState.m_61143_(HoloCubeBlock.STATUS));
        ResourceLocation holoLogId = blockEntity.getHoloLogId();
        if (holoLogId == null) {
            if (status != HoloLogStatus.READY) {
                log.warn("[{}] Hololog ID is null but status is {}, resetting to READY", (Object)blockEntity.cubeUUID, (Object)status);
                HoloCubeBlock.updateStatus(level, blockPos, HoloLogStatus.READY);
            }
            return;
        }
        if (status == HoloLogStatus.ENDED) {
            if (blockEntity.endedAtTick < 0L) {
                blockEntity.endedAtTick = level.m_46467_();
            } else if (level.m_46467_() - blockEntity.endedAtTick > 20L) {
                log.debug("[{}] Auto-resetting from ENDED to READY", (Object)blockEntity.cubeUUID);
                HoloCubeBlock.updateStatus(level, blockPos, HoloLogStatus.READY);
                blockEntity.endedAtTick = -1L;
                blockEntity.stopPlayback();
            }
            return;
        }
        blockEntity.endedAtTick = -1L;
        boolean playerInRange = HoloCubeBlockEntity.hasNonSpectatorPlayerInRange(level, blockPos);
        if (status == HoloLogStatus.PLAYING) {
            log.trace("[{}] PLAYING - player exists: {}, playerInRange: {}", (Object)blockEntity.cubeUUID, (Object)(blockEntity.player != null ? 1 : 0), (Object)playerInRange);
            if (!playerInRange && blockEntity.player != null) {
                log.debug("[{}] No player in range, stopping playback", (Object)blockEntity.cubeUUID);
                HoloCubeBlock.updateStatus(level, blockPos, HoloLogStatus.READY);
                blockEntity.stopPlayback();
                return;
            }
            if (blockEntity.player == null && playerInRange) {
                log.info("[{}] Starting playback for hololog: {}", (Object)blockEntity.cubeUUID, (Object)holoLogId);
                blockEntity.startPlayback(level, blockPos, holoLogId);
            }
        } else if (status == HoloLogStatus.READY && blockEntity.player != null) {
            blockEntity.stopPlayback();
        }
        if (blockEntity.player != null && blockEntity.player.isPlaying()) {
            blockEntity.player.tick();
        }
        blockEntity.lastKnownStatus = status;
    }

    private static boolean hasNonSpectatorPlayerInRange(Level level, BlockPos blockPos) {
        return level.m_6907_().stream().filter(player -> !player.m_5833_()).anyMatch(player -> {
            boolean inRange;
            double distance = player.m_20275_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
            boolean bl = inRange = distance <= 1024.0;
            if (log.isTraceEnabled()) {
                log.trace("Player {} at distance {} blocks (max: {}): {}", (Object)player.m_7755_().getString(), (Object)Math.sqrt(distance), (Object)32.0, (Object)(inRange ? "IN RANGE" : "out of range"));
            }
            return inRange;
        });
    }

    private void startPlayback(Level level, BlockPos blockPos, ResourceLocation holoLogId) {
        log.info("[{}] startPlayback() called for hololog: {}", (Object)this.cubeUUID, (Object)holoLogId);
        if (holoLogId == null) {
            log.error("[{}] Cannot start playback: holoLogId is null", (Object)this.cubeUUID);
            return;
        }
        if (!level.f_46443_) {
            log.error("[{}] startPlayback() called on server side - this should never happen!", (Object)this.cubeUUID);
            return;
        }
        Optional<HoloLogData> optionalHoloLogData = HoloLogManager.loadHoloLog(holoLogId);
        if (optionalHoloLogData.isEmpty()) {
            log.error("[{}] Failed to load hololog data for: {}", (Object)this.cubeUUID, (Object)holoLogId);
            HoloCubeBlock.updateStatus(level, blockPos, HoloLogStatus.READY);
            return;
        }
        HoloLogData holoLogData = optionalHoloLogData.get();
        log.info("[{}] Hololog loaded successfully: {} (lines: {}, default delay: {}s)", (Object)this.cubeUUID, (Object)holoLogId, (Object)holoLogData.lines().size(), (Object)Float.valueOf(holoLogData.lineDelay()));
        WorldContext holoLogPlaybackContext = new WorldContext(level, blockPos);
        this.player = new HoloLogBlockPlayer(holoLogData, holoLogPlaybackContext, UUID.randomUUID(), text -> {
            LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
            if (clientPlayer != null && !clientPlayer.m_5833_()) {
                clientPlayer.m_5661_((Component)Component.m_237113_((String)("\u00a77[Hololog] \u00a7f" + text)), false);
            }
        }, () -> {
            log.info("[{}] Playback finished", (Object)this.cubeUUID);
            HoloCubeBlock.updateStatus(level, blockPos, HoloLogStatus.ENDED);
        });
        this.player.start();
        log.info("[{}] Playback started", (Object)this.cubeUUID);
    }

    private void stopPlayback() {
        if (this.player != null) {
            log.debug("[{}] Stopping playback", (Object)this.cubeUUID);
            this.player.stop();
            this.player = null;
        }
    }

    public void cleanup() {
        this.stopPlayback();
    }

    public void m_7651_() {
        super.m_7651_();
        this.cleanup();
    }

    public UUID getCubeUUID() {
        return this.cubeUUID;
    }

    public ResourceLocation getHoloLogId() {
        return this.holoLogId != null ? this.holoLogId : DEFAULT_HOLO_LOG;
    }

    public void setHoloLogId(ResourceLocation holoLogId) {
        log.debug("[{}] Setting holo log ID to: {}", (Object)this.cubeUUID, (Object)holoLogId);
        this.holoLogId = holoLogId;
        this.m_6596_();
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        if (compoundTag.m_128441_(CUBE_UUID_TAG)) {
            this.cubeUUID = compoundTag.m_128342_(CUBE_UUID_TAG);
        }
        if (compoundTag.m_128441_(HOLOLOG_ID_TAG)) {
            try {
                this.holoLogId = new ResourceLocation(compoundTag.m_128461_(HOLOLOG_ID_TAG));
            }
            catch (Exception e) {
                log.warn("[{}] Failed to load hololog ID: {}", (Object)this.cubeUUID, (Object)e.getMessage());
                this.holoLogId = DEFAULT_HOLO_LOG;
            }
        }
        if (compoundTag.m_128441_(PLAYER_UUID_TAG)) {
            this.playerUUID = compoundTag.m_128342_(PLAYER_UUID_TAG);
        }
        if (compoundTag.m_128441_(LAST_STATUS_TAG)) {
            try {
                this.lastKnownStatus = HoloLogStatus.valueOf(compoundTag.m_128461_(LAST_STATUS_TAG).toUpperCase());
            }
            catch (Exception e) {
                log.warn("[{}] Failed to load last status: {}", (Object)this.cubeUUID, (Object)e.getMessage());
                this.lastKnownStatus = HoloLogStatus.READY;
            }
        }
        if (compoundTag.m_128441_(ENDED_TICK_TAG)) {
            this.endedAtTick = compoundTag.m_128454_(ENDED_TICK_TAG);
        }
        log.debug("[{}] Loaded HoloCube data", (Object)this.cubeUUID);
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128362_(CUBE_UUID_TAG, this.cubeUUID);
        compoundTag.m_128359_(LAST_STATUS_TAG, this.lastKnownStatus.name());
        compoundTag.m_128356_(ENDED_TICK_TAG, this.endedAtTick);
        if (this.holoLogId != null) {
            compoundTag.m_128359_(HOLOLOG_ID_TAG, this.holoLogId.toString());
        }
        if (this.playerUUID != null) {
            compoundTag.m_128362_(PLAYER_UUID_TAG, this.playerUUID);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private void syncToClient() {
        Level currentLevel = this.f_58857_;
        if (currentLevel != null && !currentLevel.f_46443_) {
            currentLevel.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public HoloLogBlockPlayer getPlayer() {
        return this.player;
    }

    public void m_6596_() {
        super.m_6596_();
        this.syncToClient();
    }
}

