/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity;

import de.markusbordihn.scraptechworkshop.block.RecyclerBlock;
import de.markusbordihn.scraptechworkshop.block.entity.RecyclerContainer;
import de.markusbordihn.scraptechworkshop.block.entity.RecyclerTickProcessor;
import de.markusbordihn.scraptechworkshop.config.RecyclerConfig;
import de.markusbordihn.scraptechworkshop.data.recycler.RecyclerStatus;
import de.markusbordihn.scraptechworkshop.menu.RecyclerMenu;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RecyclerBlockEntity
extends BlockEntity
implements MenuProvider,
WorldlyContainer {
    public static final String ID = "recycler";
    private static final int INPUT_SLOTS = 1;
    private static final int OUTPUT_SLOTS = 9;
    private static final int UPGRADE_SLOTS = 2;
    private static final int TOTAL_SLOTS = 12;
    private static final int INPUT_SLOT = 0;
    private static final int FIRST_OUTPUT_SLOT = 1;
    private static final int LAST_OUTPUT_SLOT = 9;
    private static final String PROGRESS_TAG = "Progress";
    private static final String MAX_PROGRESS_TAG = "MaxProgress";
    private static final String NO_RECIPE_TIMER_TAG = "NoRecipeTimer";
    private static final String DONE_TIMER_TAG = "DoneTimer";
    private static final String ITEM_TAG_PREFIX = "Item";
    private static final int PROGRESS_DATA_INDEX = 0;
    private static final int MAX_PROGRESS_DATA_INDEX = 1;
    private static final String TRANSLATION_KEY = "container.scrap_tech_workshop.recycler";
    public static BlockEntityType<RecyclerBlockEntity> TYPE;
    private final RecyclerContainer container;
    private int progress = 0;
    private int maxProgress = RecyclerConfig.processTime;
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> RecyclerBlockEntity.this.progress;
                case 1 -> RecyclerBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    RecyclerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    RecyclerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int noRecipeTimer = 0;
    private int doneTimer = 0;
    private RecyclerRecipe currentRecipe = null;
    private int tickCounter = 0;

    public RecyclerBlockEntity(BlockPos pos, BlockState blockState) {
        super(TYPE, pos, blockState);
        this.container = new RecyclerContainer(12, this::m_6596_);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RecyclerBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        ++blockEntity.tickCounter;
        RecyclerStatus currentStatus = (RecyclerStatus)((Object)state.m_61143_(RecyclerBlock.STATUS));
        RecyclerTickProcessor.RecyclerState recyclerState = new RecyclerTickProcessor.RecyclerState(level, pos, blockEntity.container.getItems(), blockEntity.progress, blockEntity.maxProgress, blockEntity.noRecipeTimer, blockEntity.doneTimer, blockEntity.currentRecipe);
        RecyclerTickProcessor.TickResult result = switch (currentStatus) {
            default -> throw new IncompatibleClassChangeError();
            case RecyclerStatus.NO_RECIPE -> RecyclerTickProcessor.processNoRecipeStatus(recyclerState);
            case RecyclerStatus.DONE -> RecyclerTickProcessor.processDoneStatus(recyclerState);
            case RecyclerStatus.IDLE, RecyclerStatus.WORKING, RecyclerStatus.ERROR -> RecyclerTickProcessor.processActiveStatus(recyclerState, state);
        };
        blockEntity.progress = recyclerState.progress;
        blockEntity.noRecipeTimer = recyclerState.noRecipeTimer;
        blockEntity.doneTimer = recyclerState.doneTimer;
        blockEntity.currentRecipe = recyclerState.currentRecipe;
        if (result.newStatus != currentStatus) {
            RecyclerBlock.updateStatus(level, pos, result.newStatus);
        }
        if (result.hasChanged && blockEntity.tickCounter % RecyclerConfig.progressUpdateInterval == 0) {
            blockEntity.m_6596_();
        }
    }

    public RecyclerContainer getContainer() {
        return this.container;
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        for (int i = 0; i < 12; ++i) {
            this.container.getItems()[i] = compoundTag.m_128441_(ITEM_TAG_PREFIX + i) ? ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_(ITEM_TAG_PREFIX + i)) : ItemStack.f_41583_;
        }
        this.progress = compoundTag.m_128451_(PROGRESS_TAG);
        this.maxProgress = compoundTag.m_128451_(MAX_PROGRESS_TAG);
        this.noRecipeTimer = compoundTag.m_128451_(NO_RECIPE_TIMER_TAG);
        this.doneTimer = compoundTag.m_128451_(DONE_TIMER_TAG);
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        for (int i = 0; i < 12; ++i) {
            if (this.container.getItems()[i].m_41619_()) continue;
            compoundTag.m_128365_(ITEM_TAG_PREFIX + i, (Tag)this.container.getItems()[i].m_41739_(new CompoundTag()));
        }
        compoundTag.m_128405_(PROGRESS_TAG, this.progress);
        compoundTag.m_128405_(MAX_PROGRESS_TAG, this.maxProgress);
        compoundTag.m_128405_(NO_RECIPE_TIMER_TAG, this.noRecipeTimer);
        compoundTag.m_128405_(DONE_TIMER_TAG, this.doneTimer);
    }

    public int m_6643_() {
        return this.container.m_6643_();
    }

    public boolean m_7983_() {
        return this.container.m_7983_();
    }

    public ItemStack m_8020_(int slot) {
        return this.container.m_8020_(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.container.m_7407_(slot, amount);
    }

    public ItemStack m_8016_(int slot) {
        return this.container.m_8016_(slot);
    }

    public void m_6836_(int slot, ItemStack itemStack) {
        this.container.m_6836_(slot, itemStack);
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public boolean m_7013_(int slot, ItemStack itemStack) {
        return this.container.m_7013_(slot, itemStack);
    }

    public void m_6211_() {
        this.container.m_6211_();
    }

    public int[] m_7071_(Direction direction) {
        return this.container.m_7071_(direction);
    }

    public boolean m_7155_(int slot, ItemStack itemStack, Direction direction) {
        return this.container.m_7155_(slot, itemStack, direction);
    }

    public boolean m_7157_(int slot, ItemStack itemStack, Direction direction) {
        return this.container.m_7157_(slot, itemStack, direction);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)TRANSLATION_KEY);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new RecyclerMenu(windowId, playerInventory, this, this.containerData);
    }

    public int getRedstoneSignal() {
        if (this.maxProgress <= 0) {
            return 0;
        }
        return this.progress * 15 / this.maxProgress;
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    private void syncToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.syncToClient();
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

