/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity;

import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipe;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipeSelector;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecyclerRecipeHandler {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");

    public static RecyclerRecipe findRecipe(Level level, ItemStack inputStack) {
        if (level == null || inputStack.m_41619_()) {
            return null;
        }
        RecyclerRecipe recipe = RecyclerRecipeSelector.selectBestRecipe(level, inputStack).orElse(null);
        if (recipe == null) {
            log.debug("No recycler recipe found for item: {} ({})", (Object)inputStack.m_41720_(), (Object)inputStack.m_41720_().m_5524_());
        }
        return recipe;
    }

    public static boolean canProcessRecipe(RecyclerRecipe recipe, ItemStack inputStack, ItemStack[] items) {
        if (recipe == null || inputStack.m_41619_() || !recipe.matchesInput(inputStack)) {
            return false;
        }
        return RecyclerRecipeHandler.canInsertOutputs(recipe.getOutputsForInput(inputStack), items);
    }

    public static void processRecipe(RecyclerRecipe recipe, ItemStack inputStack, ItemStack[] items) {
        if (recipe == null || inputStack.m_41619_()) {
            return;
        }
        List<ItemStack> outputs = recipe.getOutputsForInput(inputStack);
        outputs.forEach(output -> RecyclerRecipeHandler.insertOutput(output, items));
        inputStack.m_41774_(1);
        log.debug("Processed item with recipe: {} -> {} outputs", (Object)inputStack.m_41720_(), (Object)outputs.size());
    }

    private static boolean canInsertOutputs(List<ItemStack> outputs, ItemStack[] items) {
        ItemStack[] simulatedItems = new ItemStack[items.length];
        for (int i = 0; i < items.length; ++i) {
            simulatedItems[i] = items[i].m_41777_();
        }
        for (ItemStack output : outputs) {
            if (RecyclerRecipeHandler.tryInsertOutput(simulatedItems, output, true)) continue;
            return false;
        }
        return true;
    }

    private static boolean tryInsertOutput(ItemStack[] itemArray, ItemStack output, boolean isSimulation) {
        ItemStack remaining = output.m_41777_();
        for (int i = 1; i <= 9 && !remaining.m_41619_(); ++i) {
            ItemStack slotStack = itemArray[i];
            if (slotStack.m_41619_()) {
                itemArray[i] = remaining.m_41777_();
                remaining = ItemStack.f_41583_;
                continue;
            }
            if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)remaining)) continue;
            int canAdd = slotStack.m_41741_() - slotStack.m_41613_();
            int toAdd = Math.min(canAdd, remaining.m_41613_());
            slotStack.m_41769_(toAdd);
            remaining.m_41774_(toAdd);
        }
        return remaining.m_41619_();
    }

    private static void insertOutput(ItemStack output, ItemStack[] items) {
        RecyclerRecipeHandler.tryInsertOutput(items, output, false);
    }
}

