/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.scrap;

import de.markusbordihn.scraptechworkshop.block.ScrapPileBlock;
import de.markusbordihn.scraptechworkshop.data.ScrapPileVariant;
import de.markusbordihn.scraptechworkshop.effects.ParticleEffects;
import de.markusbordihn.scraptechworkshop.loot.ScrapLootTables;
import de.markusbordihn.scraptechworkshop.spawner.ScrapPileSpawner;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ScrapPileCollector {
    private ScrapPileCollector() {
    }

    public static void handleScrapCollection(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        int currentSize = (Integer)blockState.m_61143_((Property)ScrapPileBlock.SIZE);
        ScrapPileVariant variant = (ScrapPileVariant)((Object)blockState.m_61143_(ScrapPileBlock.VARIANT));
        ItemStack scrapItem = ScrapLootTables.generateRandomScrap(variant, level.f_46441_);
        boolean itemAdded = true;
        if (!scrapItem.m_41619_() && !player.m_150109_().m_36054_(scrapItem)) {
            Block.m_49840_((Level)level, (BlockPos)blockPos, (ItemStack)scrapItem);
            itemAdded = false;
        }
        ParticleEffects.spawnScrapDustParticles(level, blockPos);
        level.m_5594_(null, blockPos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.5f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
        if (currentSize <= 1) {
            level.m_7471_(blockPos, false);
            try {
                ScrapPileSpawner.decrementChunkCount(new ChunkPos(blockPos));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (itemAdded) {
                level.m_5594_(null, blockPos, SoundEvents.f_11871_, SoundSource.BLOCKS, 0.3f, 1.2f);
            }
        } else {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)ScrapPileBlock.SIZE, (Comparable)Integer.valueOf(currentSize - 1)), 3);
        }
    }
}

